/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx;

import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.netty.shaded.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpRequest;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpResponse;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaders;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpMethod;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpVersion;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocket13FrameEncoder;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketUtil;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.URI;

public class WebSocketClientHandshaker13
extends WebSocketClientHandshaker {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketClientHandshaker13.class);
    public static final String MAGIC_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private String expectedChallengeResponseString;
    private final boolean allowExtensions;
    private final boolean performMasking;
    private final boolean allowMaskMismatch;

    public WebSocketClientHandshaker13(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength) {
        this(webSocketURL, version, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, true, false);
    }

    public WebSocketClientHandshaker13(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean performMasking, boolean allowMaskMismatch) {
        this(webSocketURL, version, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, allowMaskMismatch, 10000L);
    }

    public WebSocketClientHandshaker13(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean performMasking, boolean allowMaskMismatch, long forceCloseTimeoutMillis) {
        this(webSocketURL, version, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, allowMaskMismatch, forceCloseTimeoutMillis, false);
    }

    WebSocketClientHandshaker13(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean performMasking, boolean allowMaskMismatch, long forceCloseTimeoutMillis, boolean absoluteUpgradeUrl) {
        this(webSocketURL, version, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, allowMaskMismatch, forceCloseTimeoutMillis, absoluteUpgradeUrl, true);
    }

    WebSocketClientHandshaker13(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean performMasking, boolean allowMaskMismatch, long forceCloseTimeoutMillis, boolean absoluteUpgradeUrl, boolean generateOriginHeader) {
        super(webSocketURL, version, subprotocol, customHeaders, maxFramePayloadLength, forceCloseTimeoutMillis, absoluteUpgradeUrl, generateOriginHeader);
        this.allowExtensions = allowExtensions;
        this.performMasking = performMasking;
        this.allowMaskMismatch = allowMaskMismatch;
    }

    @Override
    protected FullHttpRequest newHandshakeRequest() {
        String expectedSubprotocol;
        URI wsURL = this.uri();
        byte[] nonce = WebSocketUtil.randomBytes(16);
        String key = WebSocketUtil.base64(nonce);
        String acceptSeed = key + MAGIC_GUID;
        byte[] sha1 = WebSocketUtil.sha1(acceptSeed.getBytes(CharsetUtil.US_ASCII));
        this.expectedChallengeResponseString = WebSocketUtil.base64(sha1);
        if (logger.isDebugEnabled()) {
            logger.debug("WebSocket version 13 client handshake key: {}, expected response: {}", (Object)key, (Object)this.expectedChallengeResponseString);
        }
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, this.upgradeUrl(wsURL), Unpooled.EMPTY_BUFFER);
        HttpHeaders headers = request.headers();
        if (this.customHeaders != null) {
            headers.add(this.customHeaders);
            if (!headers.contains(HttpHeaderNames.HOST)) {
                headers.set((CharSequence)HttpHeaderNames.HOST, (Object)WebSocketClientHandshaker13.websocketHostValue(wsURL));
            }
        } else {
            headers.set((CharSequence)HttpHeaderNames.HOST, (Object)WebSocketClientHandshaker13.websocketHostValue(wsURL));
        }
        headers.set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY, (Object)key);
        if (this.generateOriginHeader && !headers.contains(HttpHeaderNames.ORIGIN)) {
            headers.set((CharSequence)HttpHeaderNames.ORIGIN, (Object)WebSocketClientHandshaker13.websocketOriginValue(wsURL));
        }
        if ((expectedSubprotocol = this.expectedSubprotocol()) != null && !expectedSubprotocol.isEmpty()) {
            headers.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)expectedSubprotocol);
        }
        headers.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)this.version().toAsciiString());
        return request;
    }

    @Override
    protected void verify(FullHttpResponse response) {
        HttpResponseStatus status = response.status();
        if (!HttpResponseStatus.SWITCHING_PROTOCOLS.equals(status)) {
            throw new WebSocketClientHandshakeException("Invalid handshake response getStatus: " + status, response);
        }
        HttpHeaders headers = response.headers();
        String upgrade = headers.get(HttpHeaderNames.UPGRADE);
        if (!HttpHeaderValues.WEBSOCKET.contentEqualsIgnoreCase(upgrade)) {
            throw new WebSocketClientHandshakeException("Invalid handshake response upgrade: " + upgrade, response);
        }
        if (!headers.containsValue(HttpHeaderNames.CONNECTION, HttpHeaderValues.UPGRADE, true)) {
            throw new WebSocketClientHandshakeException("Invalid handshake response connection: " + headers.get(HttpHeaderNames.CONNECTION), response);
        }
        String accept = headers.get(HttpHeaderNames.SEC_WEBSOCKET_ACCEPT);
        if (accept == null || !accept.equals(this.expectedChallengeResponseString)) {
            throw new WebSocketClientHandshakeException(String.format("Invalid challenge. Actual: %s. Expected: %s", accept, this.expectedChallengeResponseString), response);
        }
    }

    @Override
    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket13FrameDecoder(false, this.allowExtensions, this.maxFramePayloadLength(), this.allowMaskMismatch);
    }

    @Override
    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket13FrameEncoder(this.performMasking);
    }

    @Override
    public WebSocketClientHandshaker13 setForceCloseTimeoutMillis(long forceCloseTimeoutMillis) {
        super.setForceCloseTimeoutMillis(forceCloseTimeoutMillis);
        return this;
    }

    public boolean isAllowExtensions() {
        return this.allowExtensions;
    }

    public boolean isPerformMasking() {
        return this.performMasking;
    }

    public boolean isAllowMaskMismatch() {
        return this.allowMaskMismatch;
    }
}

