/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.com.google.re2j;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.re2j.RE2;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.re2j.Utils;

abstract class MachineInput {
    static final int EOF = -8;

    MachineInput() {
    }

    static MachineInput fromUTF8(byte[] b) {
        return new UTF8Input(b);
    }

    static MachineInput fromUTF8(byte[] b, int start, int end) {
        return new UTF8Input(b, start, end);
    }

    static MachineInput fromUTF16(CharSequence s) {
        return new UTF16Input(s, 0, s.length());
    }

    static MachineInput fromUTF16(CharSequence s, int start, int end) {
        return new UTF16Input(s, start, end);
    }

    abstract int step(int var1);

    abstract boolean canCheckPrefix();

    abstract int index(RE2 var1, int var2);

    abstract int context(int var1);

    abstract int endPos();

    private static class UTF16Input
    extends MachineInput {
        final CharSequence str;
        final int start;
        final int end;

        public UTF16Input(CharSequence str, int start, int end) {
            this.str = str;
            this.start = start;
            this.end = end;
        }

        @Override
        int step(int pos) {
            if ((pos += this.start) < this.end) {
                int rune = Character.codePointAt(this.str, pos);
                int nextPos = pos + Character.charCount(rune);
                int width = nextPos - pos;
                return rune << 3 | width;
            }
            return -8;
        }

        @Override
        boolean canCheckPrefix() {
            return true;
        }

        @Override
        int index(RE2 re2, int pos) {
            int i = this.indexOf(this.str, re2.prefix, pos += this.start);
            return i < 0 ? i : i - pos;
        }

        @Override
        int context(int pos) {
            int r1 = (pos += this.start) > this.start && pos <= this.end ? Character.codePointBefore(this.str, pos) : -1;
            int r2 = pos < this.end ? Character.codePointAt(this.str, pos) : -1;
            return Utils.emptyOpContext(r1, r2);
        }

        @Override
        int endPos() {
            return this.end;
        }

        private int indexOf(CharSequence hayStack, String needle, int pos) {
            if (hayStack instanceof String) {
                return ((String)hayStack).indexOf(needle, pos);
            }
            if (hayStack instanceof StringBuilder) {
                return ((StringBuilder)hayStack).indexOf(needle, pos);
            }
            return this.indexOfFallback(hayStack, needle, pos);
        }

        private int indexOfFallback(CharSequence hayStack, String needle, int fromIndex) {
            if (fromIndex >= hayStack.length()) {
                return needle.isEmpty() ? 0 : -1;
            }
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            if (needle.isEmpty()) {
                return fromIndex;
            }
            char first = needle.charAt(0);
            int max = hayStack.length() - needle.length();
            for (int i = fromIndex; i <= max; ++i) {
                if (hayStack.charAt(i) != first) {
                    while (++i <= max && hayStack.charAt(i) != first) {
                    }
                }
                if (i > max) continue;
                int j = i + 1;
                int end = j + needle.length() - 1;
                int k = 1;
                while (j < end && hayStack.charAt(j) == needle.charAt(k)) {
                    ++j;
                    ++k;
                }
                if (j != end) continue;
                return i;
            }
            return -1;
        }
    }

    private static class UTF8Input
    extends MachineInput {
        final byte[] b;
        final int start;
        final int end;

        UTF8Input(byte[] b) {
            this.b = b;
            this.start = 0;
            this.end = b.length;
        }

        UTF8Input(byte[] b, int start, int end) {
            if (end > b.length) {
                throw new ArrayIndexOutOfBoundsException("end is greater than length: " + end + " > " + b.length);
            }
            this.b = b;
            this.start = start;
            this.end = end;
        }

        @Override
        int step(int i) {
            int x;
            if ((i += this.start) >= this.end) {
                return -8;
            }
            if (((x = this.b[i++] & 0xFF) & 0x80) == 0) {
                return x << 3 | 1;
            }
            if ((x & 0xE0) == 192) {
                x &= 0x1F;
                if (i >= this.end) {
                    return -8;
                }
                x = x << 6 | this.b[i++] & 0x3F;
                return x << 3 | 2;
            }
            if ((x & 0xF0) == 224) {
                x &= 0xF;
                if (i + 1 >= this.end) {
                    return -8;
                }
                x = x << 6 | this.b[i++] & 0x3F;
                x = x << 6 | this.b[i++] & 0x3F;
                return x << 3 | 3;
            }
            x &= 7;
            if (i + 2 >= this.end) {
                return -8;
            }
            x = x << 6 | this.b[i++] & 0x3F;
            x = x << 6 | this.b[i++] & 0x3F;
            x = x << 6 | this.b[i++] & 0x3F;
            return x << 3 | 4;
        }

        @Override
        boolean canCheckPrefix() {
            return true;
        }

        @Override
        int index(RE2 re2, int pos) {
            int i = Utils.indexOf(this.b, re2.prefixUTF8, pos += this.start);
            return i < 0 ? i : i - pos;
        }

        @Override
        int context(int pos) {
            int r1 = -1;
            if ((pos += this.start) > this.start && pos <= this.end) {
                int start = pos - 1;
                if ((r1 = this.b[start--]) >= 128) {
                    int lim = pos - 4;
                    if (lim < this.start) {
                        lim = this.start;
                    }
                    while (start >= lim && (this.b[start] & 0xC0) == 128) {
                        --start;
                    }
                    if (start < this.start) {
                        start = this.start;
                    }
                    r1 = this.step(start) >> 3;
                }
            }
            int r2 = pos < this.end ? this.step(pos) >> 3 : -1;
            return Utils.emptyOpContext(r1, r2);
        }

        @Override
        int endPos() {
            return this.end;
        }
    }
}

