/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.com.google.monitoring.v3;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.resourcenames.ResourceName;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OrganizationName
implements ResourceName {
    private static final PathTemplate ORGANIZATION = PathTemplate.createWithoutUrlEncoding("organizations/{organization}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;

    @Deprecated
    protected OrganizationName() {
        this.organization = null;
    }

    private OrganizationName(Builder builder) {
        this.organization = Preconditions.checkNotNull(builder.getOrganization());
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static OrganizationName of(String organization) {
        return OrganizationName.newBuilder().setOrganization(organization).build();
    }

    public static String format(String organization) {
        return OrganizationName.newBuilder().setOrganization(organization).build().toString();
    }

    public static OrganizationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = ORGANIZATION.validatedMatch(formattedString, "OrganizationName.parse: formattedString not in valid format");
        return OrganizationName.of(matchMap.get("organization"));
    }

    public static List<OrganizationName> parseList(List<String> formattedStrings) {
        ArrayList<OrganizationName> list = new ArrayList<OrganizationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(OrganizationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<OrganizationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (OrganizationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            OrganizationName organizationName = this;
            synchronized (organizationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put("organization", this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION.instantiate("organization", this.organization);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            OrganizationName that = (OrganizationName)o;
            return Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    public static class Builder {
        private String organization;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        private Builder(OrganizationName organizationName) {
            this.organization = organizationName.organization;
        }

        public OrganizationName build() {
            return new OrganizationName(this);
        }
    }
}

