/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Utils;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.collect.ImmutableMap;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.collect.MapDifference;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;

final class XGoogApiClientHeaderProvider
implements HeaderProvider {
    private static final Collector<CharSequence, ?, String> COMBINER = Collectors.joining(" ");
    private final Map<String, String> headers;

    private XGoogApiClientHeaderProvider(Map<String, String> headers) {
        this.headers = headers;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    static XGoogApiClientHeaderProvider of(HeaderProvider baseValue, ImmutableList<String> additionalEntries) {
        if (additionalEntries.isEmpty()) {
            return new XGoogApiClientHeaderProvider(baseValue.getHeaders());
        }
        ImmutableMap<String, String> right = ImmutableMap.of("x-goog-api-client", additionalEntries.stream().collect(COMBINER));
        ImmutableMap<String, String> union = XGoogApiClientHeaderProvider.union(baseValue.getHeaders(), right);
        return new XGoogApiClientHeaderProvider(union);
    }

    @VisibleForTesting
    static ImmutableMap<String, String> union(Map<String, String> left, Map<String, String> right) {
        Map<String, String> r;
        if (left.equals(right)) {
            return ImmutableMap.copyOf(left);
        }
        Map<String, String> l = XGoogApiClientHeaderProvider.lowerKeys(left);
        if (l.equals(r = XGoogApiClientHeaderProvider.lowerKeys(right))) {
            return ImmutableMap.copyOf(l);
        }
        HashMap<String, String> tmp = new HashMap<String, String>();
        MapDifference<String, String> diff = Maps.difference(l, r);
        tmp.putAll(diff.entriesOnlyOnLeft());
        tmp.putAll(diff.entriesOnlyOnRight());
        tmp.putAll(diff.entriesInCommon());
        for (Map.Entry<String, MapDifference.ValueDifference<String>> e : diff.entriesDiffering().entrySet()) {
            String k = e.getKey();
            MapDifference.ValueDifference<String> v = e.getValue();
            tmp.put(k, ImmutableList.of(v.leftValue(), v.rightValue()).stream().collect(COMBINER));
        }
        return ImmutableMap.copyOf(tmp);
    }

    private static Map<String, String> lowerKeys(Map<String, String> orig) {
        HashMap<String, String> tmp = new HashMap<String, String>();
        for (Map.Entry<String, String> e : orig.entrySet()) {
            String k = e.getKey();
            String v = e.getValue();
            tmp.put(Utils.headerNameToLowerCase(k), v);
        }
        return tmp;
    }
}

