/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.client.util.Data;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.core.ApiFuture;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.paging.Page;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.services.storage.model.BucketAccessControl;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.services.storage.model.HmacKeyMetadata;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.services.storage.model.ObjectAccessControl;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.auth.ServiceAccountSigner;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.BaseService;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.BatchResult;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.PageImpl;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.Policy;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.WriteChannel;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Acl;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Blob;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BlobId;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BlobInfo;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BlobReadChannelV2;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BlobWriteChannelV2;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BlobWriteSession;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BlobWriteSessionConfig;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BlobWriteSessions;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Bucket;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BucketInfo;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.ByteRangeSpec;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Conversions;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.CopyWriter;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.HmacKey;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.HttpClientContext;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.HttpContentRange;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.HttpCopyWriter;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.HttpMethod;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.HttpRetryAlgorithmManager;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.HttpStorageOptions;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.JsonConversions;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.JsonResumableSession;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.JsonResumableWrite;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Notification;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.NotificationInfo;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.PostPolicyV4;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.ResumableMedia;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.ResumableOperationResult;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.ResumableSession;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Retrying;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.RewindableContent;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.RewindableContentInputStream;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.ServiceAccount;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.SignatureInfo;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.SignedUrlEncodingHelper;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Storage;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.StorageBatch;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.StorageException;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.StorageInternal;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.StorageOptions;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.StorageReadChannel;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.StorageWriteChannel;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.UnifiedOpts;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.WritableByteChannelSession;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.spi.v1.StorageRpc;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.base.CharMatcher;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.collect.ImmutableMap;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.collect.ImmutableSet;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.collect.Iterables;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.collect.Lists;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.collect.Maps;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.hash.Hashing;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.io.BaseEncoding;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.io.CountingOutputStream;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.primitives.Ints;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class StorageImpl
extends BaseService<StorageOptions>
implements Storage,
StorageInternal {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final String EMPTY_BYTE_ARRAY_MD5 = "1B2M2Y8AsgTpgAmY7PhCfg==";
    private static final String EMPTY_BYTE_ARRAY_CRC32C = "AAAAAA==";
    private static final String PATH_DELIMITER = "/";
    private final String STORAGE_XML_URI_SCHEME;
    private final String STORAGE_XML_URI_HOST_NAME;
    private static final int DEFAULT_BUFFER_SIZE = 0xF00000;
    private static final int MIN_BUFFER_SIZE = 262144;
    private static final JsonConversions codecs = Conversions.json();
    final HttpRetryAlgorithmManager retryAlgorithmManager;
    final StorageRpc storageRpc;
    final BlobWriteSessionConfig.WriterFactory writerFactory;
    final Retrying.Retrier retrier;

    StorageImpl(HttpStorageOptions options, BlobWriteSessionConfig.WriterFactory writerFactory, Retrying.Retrier retrier) {
        super(options);
        this.retryAlgorithmManager = options.getRetryAlgorithmManager();
        this.storageRpc = options.getStorageRpcV1();
        this.writerFactory = writerFactory;
        try {
            String resolvedApiaryHost = options.getResolvedApiaryHost("storage");
            URI uri = new URI(resolvedApiaryHost);
            this.STORAGE_XML_URI_HOST_NAME = uri.getHost();
            this.STORAGE_XML_URI_SCHEME = MoreObjects.firstNonNull(uri.getScheme(), "https");
        }
        catch (URISyntaxException e) {
            throw StorageException.coalesce(e);
        }
        this.retrier = retrier;
    }

    @Override
    public Bucket create(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.services.storage.model.Bucket bucketPb = (com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.services.storage.model.Bucket)codecs.bucketInfo().encode(bucketInfo);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(bucketInfo).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketsCreate(bucketPb, optionsMap);
        return this.run(algorithm, () -> this.storageRpc.create(bucketPb, optionsMap), b -> ((BucketInfo)Conversions.json().bucketInfo().decode(b)).asBucket(this));
    }

    @Override
    public Blob create(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        BlobInfo updatedInfo = blobInfo.toBuilder().setMd5(EMPTY_BYTE_ARRAY_MD5).setCrc32c(EMPTY_BYTE_ARRAY_CRC32C).build();
        UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> objectTargetOptOpts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(updatedInfo);
        return this.internalCreate(updatedInfo, EMPTY_BYTE_ARRAY, 0, 0, objectTargetOptOpts);
    }

    @Override
    public Blob create(BlobInfo blobInfo, byte[] content, Storage.BlobTargetOption ... options) {
        content = MoreObjects.firstNonNull(content, EMPTY_BYTE_ARRAY);
        BlobInfo updatedInfo = blobInfo.toBuilder().setMd5(BaseEncoding.base64().encode(Hashing.md5().hashBytes(content).asBytes())).setCrc32c(BaseEncoding.base64().encode(Ints.toByteArray(Hashing.crc32c().hashBytes(content).asInt()))).build();
        UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> objectTargetOptOpts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(updatedInfo);
        return this.internalCreate(updatedInfo, content, 0, content.length, objectTargetOptOpts);
    }

    @Override
    public Blob create(BlobInfo blobInfo, byte[] content, int offset, int length, Storage.BlobTargetOption ... options) {
        content = MoreObjects.firstNonNull(content, EMPTY_BYTE_ARRAY);
        BlobInfo updatedInfo = blobInfo.toBuilder().setMd5(BaseEncoding.base64().encode(Hashing.md5().hashBytes(content, offset, length).asBytes())).setCrc32c(BaseEncoding.base64().encode(Ints.toByteArray(Hashing.crc32c().hashBytes(content, offset, length).asInt()))).build();
        UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> objectTargetOptOpts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(updatedInfo);
        return this.internalCreate(updatedInfo, content, offset, length, objectTargetOptOpts);
    }

    @Override
    @Deprecated
    public Blob create(BlobInfo blobInfo, InputStream content, Storage.BlobWriteOption ... options) {
        UnifiedOpts.Opts opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(blobInfo);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = opts.getRpcOptions();
        BlobInfo.Builder builder = blobInfo.toBuilder().setMd5(null).setCrc32c(null);
        BlobInfo updated = opts.blobInfoMapper().apply(builder).build();
        StorageObject blobPb = (StorageObject)codecs.blobInfo().encode(updated);
        InputStream inputStreamParam = MoreObjects.firstNonNull(content, new ByteArrayInputStream(EMPTY_BYTE_ARRAY));
        BlobInfo info = (BlobInfo)Conversions.json().blobInfo().decode(this.storageRpc.create(blobPb, inputStreamParam, optionsMap));
        return info.asBlob(this);
    }

    private Blob internalCreate(BlobInfo info, byte @NonNull [] content, int offset, int length, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts) {
        Preconditions.checkNotNull(content);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = opts.getRpcOptions();
        BlobInfo updated = opts.blobInfoMapper().apply(info.toBuilder()).build();
        StorageObject blobPb = (StorageObject)codecs.blobInfo().encode(updated);
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectsCreate(blobPb, optionsMap);
        return this.run(algorithm, () -> this.storageRpc.create(blobPb, new ByteArrayInputStream(content, offset, length), optionsMap), x -> {
            BlobInfo info1 = (BlobInfo)Conversions.json().blobInfo().decode(x);
            return info1.asBlob(this);
        });
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, Path path, Storage.BlobWriteOption ... options) throws IOException {
        return this.createFrom(blobInfo, path, 0xF00000, options);
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, Path path, int bufferSize, Storage.BlobWriteOption ... options) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new StorageException(0, path + " is a directory");
        }
        long size = Files.size(path);
        if (size == 0L) {
            return this.create(blobInfo, null, options);
        }
        UnifiedOpts.Opts opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(blobInfo);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = opts.getRpcOptions();
        BlobInfo.Builder builder = blobInfo.toBuilder().setMd5(null).setCrc32c(null);
        BlobInfo updated = opts.blobInfoMapper().apply(builder).build();
        StorageObject encode = (StorageObject)codecs.blobInfo().encode(updated);
        Supplier<String> uploadIdSupplier = ResumableMedia.startUploadForBlobInfo(this.getOptions(), updated, optionsMap, this.retrier.withAlg(this.retryAlgorithmManager.getForResumableUploadSessionCreate(optionsMap)));
        JsonResumableWrite jsonResumableWrite = JsonResumableWrite.of(encode, optionsMap, uploadIdSupplier.get(), 0L);
        JsonResumableSession session = ResumableSession.json(HttpClientContext.from(this.storageRpc), this.retrier.withAlg(this.retryAlgorithmManager.idempotent()), jsonResumableWrite);
        HttpContentRange.Total contentRange = HttpContentRange.of(ByteRangeSpec.explicit(0L, size), size);
        ResumableOperationResult<StorageObject> put = session.put(RewindableContent.of(path), contentRange);
        StorageObject object = put.getObject();
        if (object == null) {
            ResumableOperationResult<@Nullable StorageObject> query = session.query();
            object = query.getObject();
        }
        return ((BlobInfo)codecs.blobInfo().decode(object)).asBlob(this);
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, InputStream content, Storage.BlobWriteOption ... options) throws IOException {
        return this.createFrom(blobInfo, content, 0xF00000, options);
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, InputStream content, int bufferSize, Storage.BlobWriteOption ... options) throws IOException {
        ApiFuture<BlobInfo> objectFuture;
        try (StorageWriteChannel writer = this.writer(blobInfo, options);){
            objectFuture = writer.getObject();
            StorageImpl.uploadHelper(Channels.newChannel(content), writer, bufferSize);
        }
        try {
            BlobInfo info = (BlobInfo)objectFuture.get(10L, TimeUnit.SECONDS);
            return info.asBlob(this);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw StorageException.coalesce(e);
        }
    }

    private static void uploadHelper(ReadableByteChannel reader, WriteChannel writer, int bufferSize) throws IOException {
        bufferSize = Math.max(bufferSize, 262144);
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        writer.setChunkSize(bufferSize);
        while (reader.read(buffer) >= 0) {
            buffer.flip();
            writer.write(buffer);
            buffer.clear();
        }
    }

    @Override
    public Bucket get(String bucket, Storage.BucketGetOption ... options) {
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        return this.internalBucketGet(bucket, optionsMap);
    }

    @Override
    public Blob get(String bucket, String blob, Storage.BlobGetOption ... options) {
        return this.get(BlobId.of(bucket, blob), options);
    }

    @Override
    public Blob get(BlobId blob, Storage.BlobGetOption ... options) {
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(blob).getRpcOptions();
        return this.internalGetBlob(blob, optionsMap);
    }

    @Override
    public Blob get(BlobId blob) {
        return this.get(blob, new Storage.BlobGetOption[0]);
    }

    @Override
    public Blob restore(BlobId blob, Storage.BlobRestoreOption ... options) {
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(blob).getRpcOptions();
        StorageObject obj = (StorageObject)codecs.blobId().encode(blob);
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectsRestore(obj, optionsMap);
        return this.run(algorithm, () -> this.storageRpc.restore(obj, optionsMap), x -> {
            BlobInfo info = (BlobInfo)Conversions.json().blobInfo().decode(x);
            return info.asBlob(this);
        });
    }

    @Override
    public Page<Bucket> list(Storage.BucketListOption ... options) {
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        return StorageImpl.listBuckets(this.getOptions(), optionsMap, this.retrier);
    }

    @Override
    public Page<Blob> list(String bucket, Storage.BlobListOption ... options) {
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        return StorageImpl.listBlobs(bucket, this.getOptions(), optionsMap, this.retrier);
    }

    private static Page<Bucket> listBuckets(HttpStorageOptions serviceOptions, Map<StorageRpc.Option, ?> optionsMap, Retrying.Retrier retrier) {
        ResultRetryAlgorithm<?> algorithm = serviceOptions.getRetryAlgorithmManager().getForBucketsList(optionsMap);
        return retrier.run(algorithm, () -> serviceOptions.getStorageRpcV1().list(optionsMap), (Response result) -> {
            String cursor = (String)result.x();
            ImmutableList buckets = result.y() == null ? ImmutableList.of() : Iterables.transform((Iterable)result.y(), bucketPb -> ((BucketInfo)Conversions.json().bucketInfo().decode(bucketPb)).asBucket((Storage)serviceOptions.getService()));
            return new PageImpl<Bucket>(new BucketPageFetcher(serviceOptions, cursor, optionsMap, retrier), cursor, buckets);
        });
    }

    private static Page<Blob> listBlobs(String bucket, HttpStorageOptions serviceOptions, Map<StorageRpc.Option, ?> optionsMap, Retrying.Retrier retrier) {
        ResultRetryAlgorithm<?> algorithm = serviceOptions.getRetryAlgorithmManager().getForObjectsList(bucket, optionsMap);
        return retrier.run(algorithm, () -> serviceOptions.getStorageRpcV1().list(bucket, optionsMap), (Response result) -> {
            String cursor = (String)result.x();
            ImmutableList blobs = result.y() == null ? ImmutableList.of() : Iterables.transform((Iterable)result.y(), storageObject -> {
                BlobInfo info = (BlobInfo)Conversions.json().blobInfo().decode(storageObject);
                return info.asBlob((Storage)serviceOptions.getService());
            });
            return new PageImpl<Blob>(new BlobPageFetcher(bucket, serviceOptions, cursor, optionsMap, retrier), cursor, blobs);
        });
    }

    @Override
    public Bucket update(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(bucketInfo).getRpcOptions();
        ImmutableSet<UnifiedOpts.NamedField> modifiedFields = bucketInfo.getModifiedFields();
        if (modifiedFields.isEmpty()) {
            return this.internalBucketGet(bucketInfo.getName(), optionsMap);
        }
        com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.services.storage.model.Bucket tmp = (com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.services.storage.model.Bucket)codecs.bucketInfo().encode(bucketInfo);
        com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.services.storage.model.Bucket bucketPb = new com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.services.storage.model.Bucket();
        Stream.concat(modifiedFields.stream(), Storage.BucketField.REQUIRED_FIELDS.stream()).map(f -> {
            if (f instanceof UnifiedOpts.NestedNamedField) {
                return ((UnifiedOpts.NestedNamedField)f).getParent();
            }
            return f;
        }).forEach(field -> {
            String jsonName = field.getApiaryName();
            if (tmp.containsKey(jsonName)) {
                bucketPb.put(jsonName, tmp.get(jsonName));
            } else {
                Storage.BucketField lookup = Storage.BucketField.lookup(field);
                if (lookup != null) {
                    bucketPb.put(jsonName, Data.nullOf(lookup.getJsonClass()));
                }
            }
        });
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketsUpdate(bucketPb, optionsMap);
        return this.run(algorithm, () -> this.storageRpc.patch(bucketPb, optionsMap), x -> ((BucketInfo)Conversions.json().bucketInfo().decode(x)).asBucket(this));
    }

    @Override
    public Blob update(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        UnifiedOpts.Opts opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(blobInfo);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = opts.getRpcOptions();
        ImmutableSet<UnifiedOpts.NamedField> modifiedFields = blobInfo.getModifiedFields();
        boolean unmodifiedBeforeOpts = modifiedFields.isEmpty();
        BlobInfo.Builder builder = blobInfo.toBuilder();
        if (modifiedFields.contains(Storage.BlobField.RETENTION)) {
            builder.setRetention(blobInfo.getRetention());
        }
        BlobInfo updated = opts.blobInfoMapper().apply(builder).build();
        boolean unmodifiedAfterOpts = updated.getModifiedFields().isEmpty();
        if (unmodifiedBeforeOpts && unmodifiedAfterOpts) {
            return this.internalGetBlob(blobInfo.getBlobId(), optionsMap);
        }
        StorageObject tmp = (StorageObject)codecs.blobInfo().encode(updated);
        StorageObject pb = new StorageObject();
        Stream.of(modifiedFields.stream(), Storage.BlobField.REQUIRED_FIELDS.stream(), Stream.of(Storage.BlobField.GENERATION)).flatMap(s -> s).map(f -> {
            if (f instanceof UnifiedOpts.NestedNamedField) {
                return ((UnifiedOpts.NestedNamedField)f).getParent();
            }
            return f;
        }).forEach(field -> {
            String jsonName = field.getApiaryName();
            if (tmp.containsKey(jsonName)) {
                pb.put(jsonName, tmp.get(jsonName));
            } else {
                Storage.BlobField lookup = Storage.BlobField.lookup(field);
                if (lookup != null) {
                    pb.put(jsonName, Data.nullOf(lookup.getJsonClass()));
                }
            }
        });
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectsUpdate(pb, optionsMap);
        return this.run(algorithm, () -> this.storageRpc.patch(pb, optionsMap), x -> {
            BlobInfo info = (BlobInfo)Conversions.json().blobInfo().decode(x);
            return info.asBlob(this);
        });
    }

    @Override
    public Blob update(BlobInfo blobInfo) {
        return this.update(blobInfo, new Storage.BlobTargetOption[0]);
    }

    @Override
    public boolean delete(String bucket, Storage.BucketSourceOption ... options) {
        com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.services.storage.model.Bucket bucketPb = (com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.services.storage.model.Bucket)codecs.bucketInfo().encode(BucketInfo.of(bucket));
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketsDelete(bucketPb, optionsMap);
        return (Boolean)this.run(algorithm, () -> this.storageRpc.delete(bucketPb, optionsMap), Conversions.Decoder.identity());
    }

    @Override
    public boolean delete(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return this.delete(BlobId.of(bucket, blob), options);
    }

    @Override
    public boolean delete(BlobId blob, Storage.BlobSourceOption ... options) {
        StorageObject storageObject = (StorageObject)codecs.blobId().encode(blob);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(blob).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectsDelete(storageObject, optionsMap);
        return (Boolean)this.run(algorithm, () -> this.storageRpc.delete(storageObject, optionsMap), Conversions.Decoder.identity());
    }

    @Override
    public boolean delete(BlobId blob) {
        return this.delete(blob, new Storage.BlobSourceOption[0]);
    }

    @Override
    public Blob compose(Storage.ComposeRequest composeRequest) {
        ArrayList<StorageObject> sources = Lists.newArrayListWithCapacity(composeRequest.getSourceBlobs().size());
        BlobInfo target = composeRequest.getTarget();
        for (Storage.ComposeRequest.SourceBlob sourceBlob : composeRequest.getSourceBlobs()) {
            sources.add((StorageObject)codecs.blobInfo().encode(BlobInfo.newBuilder(BlobId.of(target.getBucket(), sourceBlob.getName(), sourceBlob.getGeneration())).build()));
        }
        UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> targetOpts = composeRequest.getTargetOpts();
        StorageObject targetPb = (StorageObject)codecs.blobInfo().encode(composeRequest.getTarget());
        ImmutableMap<StorageRpc.Option, ?> targetOptions = targetOpts.getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectsCompose(sources, targetPb, targetOptions);
        return this.run(algorithm, () -> this.storageRpc.compose(sources, targetPb, targetOptions), x -> {
            BlobInfo info = (BlobInfo)Conversions.json().blobInfo().decode(x);
            return info.asBlob(this);
        });
    }

    @Override
    public CopyWriter copy(Storage.CopyRequest copyRequest) {
        BlobId source = copyRequest.getSource();
        BlobInfo target = copyRequest.getTarget();
        UnifiedOpts.Opts sourceOpts = UnifiedOpts.Opts.unwrap(copyRequest.getSourceOptions()).resolveFrom(source).projectAsSource();
        UnifiedOpts.Opts targetOpts = UnifiedOpts.Opts.unwrap(copyRequest.getTargetOptions()).resolveFrom(target);
        StorageObject sourcePb = (StorageObject)codecs.blobId().encode(source);
        StorageObject targetPb = (StorageObject)codecs.blobInfo().encode(target);
        ImmutableMap<StorageRpc.Option, ?> sourceOptions = sourceOpts.getRpcOptions();
        ImmutableMap<StorageRpc.Option, ?> targetOptions = targetOpts.getRpcOptions();
        StorageRpc.RewriteRequest rewriteRequest = new StorageRpc.RewriteRequest(sourcePb, sourceOptions, copyRequest.overrideInfo(), targetPb, targetOptions, copyRequest.getMegabytesCopiedPerChunk());
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectsRewrite(rewriteRequest);
        return this.run(algorithm, () -> this.storageRpc.openRewrite(rewriteRequest), r -> new HttpCopyWriter(this.getOptions(), (StorageRpc.RewriteResponse)r, this.retrier));
    }

    @Override
    public byte[] readAllBytes(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return this.readAllBytes(BlobId.of(bucket, blob), options);
    }

    @Override
    public byte[] readAllBytes(BlobId blob, Storage.BlobSourceOption ... options) {
        StorageObject storageObject = (StorageObject)codecs.blobId().encode(blob);
        UnifiedOpts.Opts unwrap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options);
        UnifiedOpts.Opts resolve = unwrap.resolveFrom(blob);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = resolve.getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectsGet(storageObject, optionsMap);
        return (byte[])this.run(algorithm, () -> this.storageRpc.load(storageObject, optionsMap), Conversions.Decoder.identity());
    }

    @Override
    public StorageBatch batch() {
        return new StorageBatch(this.getOptions());
    }

    @Override
    public StorageReadChannel reader(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return this.reader(BlobId.of(bucket, blob), options);
    }

    @Override
    public StorageReadChannel reader(BlobId blob, Storage.BlobSourceOption ... options) {
        UnifiedOpts.Opts opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(blob);
        StorageObject storageObject = (StorageObject)Conversions.json().blobId().encode(blob);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = opts.getRpcOptions();
        return new BlobReadChannelV2(storageObject, optionsMap, BlobReadChannelV2.BlobReadChannelContext.from(this));
    }

    @Override
    public void downloadTo(BlobId blob, Path path, Storage.BlobSourceOption ... options) {
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            this.downloadTo(blob, outputStream, options);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void downloadTo(BlobId blob, OutputStream outputStream, Storage.BlobSourceOption ... options) {
        CountingOutputStream countingOutputStream = new CountingOutputStream(outputStream);
        StorageObject pb = (StorageObject)codecs.blobId().encode(blob);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(blob).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectsGet(pb, optionsMap);
        this.run(algorithm, Executors.callable(() -> this.storageRpc.read(pb, optionsMap, countingOutputStream.getCount(), countingOutputStream)), Conversions.Decoder.identity());
    }

    @Override
    public StorageWriteChannel writer(BlobInfo blobInfo, Storage.BlobWriteOption ... options) {
        UnifiedOpts.Opts opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(blobInfo);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = opts.getRpcOptions();
        BlobInfo.Builder builder = blobInfo.toBuilder().setMd5(null).setCrc32c(null);
        BlobInfo updated = opts.blobInfoMapper().apply(builder).build();
        StorageObject encode = (StorageObject)codecs.blobInfo().encode(updated);
        Supplier<String> uploadIdSupplier = ResumableMedia.startUploadForBlobInfo(this.getOptions(), updated, optionsMap, this.retrier.withAlg(this.retryAlgorithmManager.getForResumableUploadSessionCreate(optionsMap)));
        JsonResumableWrite jsonResumableWrite = JsonResumableWrite.of(encode, optionsMap, uploadIdSupplier.get(), 0L);
        return new BlobWriteChannelV2(BlobReadChannelV2.BlobReadChannelContext.from(this), jsonResumableWrite);
    }

    @Override
    public StorageWriteChannel writer(URL signedURL) {
        ResultRetryAlgorithm<?> forResumableUploadSessionCreate = this.retryAlgorithmManager.getForResumableUploadSessionCreate(Collections.emptyMap());
        String signedUrlString = signedURL.toString();
        Supplier<String> uploadIdSupplier = ResumableMedia.startUploadForSignedUrl(this.getOptions(), signedURL, this.retrier.withAlg(forResumableUploadSessionCreate));
        JsonResumableWrite jsonResumableWrite = JsonResumableWrite.of(signedUrlString, uploadIdSupplier.get(), 0L);
        return new BlobWriteChannelV2(BlobReadChannelV2.BlobReadChannelContext.from(this), jsonResumableWrite);
    }

    @Override
    public URL signUrl(BlobInfo blobInfo, long duration, TimeUnit unit, Storage.SignUrlOption ... options) {
        boolean usePathStyle;
        String storageXmlHostName;
        EnumMap<Storage.SignUrlOption.Option, Object> optionMap = Maps.newEnumMap(Storage.SignUrlOption.Option.class);
        for (Storage.SignUrlOption option : options) {
            optionMap.put(option.getOption(), option.getValue());
        }
        boolean isV2 = this.getPreferredSignatureVersion(optionMap).equals((Object)Storage.SignUrlOption.SignatureVersion.V2);
        boolean isV4 = this.getPreferredSignatureVersion(optionMap).equals((Object)Storage.SignUrlOption.SignatureVersion.V4);
        ServiceAccountSigner credentials = (ServiceAccountSigner)optionMap.get((Object)Storage.SignUrlOption.Option.SERVICE_ACCOUNT_CRED);
        if (credentials == null) {
            Preconditions.checkState(this.getOptions().getCredentials() instanceof ServiceAccountSigner, "Signing key was not provided and could not be derived");
            credentials = (ServiceAccountSigner)((Object)this.getOptions().getCredentials());
        }
        long expiration = isV4 ? TimeUnit.SECONDS.convert(unit.toMillis(duration), TimeUnit.MILLISECONDS) : TimeUnit.SECONDS.convert(this.getOptions().getClock().millisTime() + unit.toMillis(duration), TimeUnit.MILLISECONDS);
        Preconditions.checkArgument(!optionMap.containsKey((Object)Storage.SignUrlOption.Option.VIRTUAL_HOSTED_STYLE) || !optionMap.containsKey((Object)Storage.SignUrlOption.Option.PATH_STYLE) || !optionMap.containsKey((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME), "Only one of VIRTUAL_HOSTED_STYLE, PATH_STYLE, or BUCKET_BOUND_HOST_NAME SignUrlOptions can be specified.");
        String bucketName = this.slashlessBucketNameFromBlobInfo(blobInfo);
        String escapedBlobName = "";
        if (!Strings.isNullOrEmpty(blobInfo.getName())) {
            escapedBlobName = SignedUrlEncodingHelper.Rfc3986UriEncode(blobInfo.getName(), false);
        }
        String string = storageXmlHostName = (usePathStyle = this.shouldUsePathStyleForSignedUrl(optionMap)) ? this.STORAGE_XML_URI_SCHEME + "://" + this.getBaseStorageHostName(optionMap) : this.STORAGE_XML_URI_SCHEME + "://" + bucketName + "." + this.getBaseStorageHostName(optionMap);
        if (optionMap.containsKey((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME)) {
            storageXmlHostName = (String)optionMap.get((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME);
        }
        String stPath = usePathStyle ? this.constructResourceUriPath(bucketName, escapedBlobName, optionMap) : this.constructResourceUriPath("", escapedBlobName, optionMap);
        URI path = URI.create(stPath);
        URI pathForSigning = isV2 ? URI.create(this.constructResourceUriPath(bucketName, escapedBlobName, optionMap)) : path;
        try {
            SignatureInfo signatureInfo = this.buildSignatureInfo(optionMap, blobInfo, expiration, pathForSigning, credentials.getAccount());
            String unsignedPayload = signatureInfo.constructUnsignedPayload();
            byte[] signatureBytes = credentials.sign(unsignedPayload.getBytes(StandardCharsets.UTF_8));
            StringBuilder stBuilder = new StringBuilder();
            stBuilder.append(storageXmlHostName).append(path);
            if (isV4) {
                BaseEncoding encoding = BaseEncoding.base16().lowerCase();
                String signature = URLEncoder.encode(encoding.encode(signatureBytes), StandardCharsets.UTF_8.name());
                String v4QueryString = signatureInfo.constructV4QueryString();
                stBuilder.append('?');
                if (!Strings.isNullOrEmpty(v4QueryString)) {
                    stBuilder.append(v4QueryString).append('&');
                }
                stBuilder.append("X-Goog-Signature=").append(signature);
            } else {
                BaseEncoding encoding = BaseEncoding.base64();
                String signature = URLEncoder.encode(encoding.encode(signatureBytes), StandardCharsets.UTF_8.name());
                String v2QueryString = signatureInfo.constructV2QueryString();
                stBuilder.append('?');
                if (!Strings.isNullOrEmpty(v2QueryString)) {
                    stBuilder.append(v2QueryString).append('&');
                }
                stBuilder.append("GoogleAccessId=").append(credentials.getAccount());
                stBuilder.append("&Expires=").append(expiration);
                stBuilder.append("&Signature=").append(signature);
            }
            return new URL(stBuilder.toString());
        }
        catch (UnsupportedEncodingException | MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, PostPolicyV4.PostFieldsV4 fields, PostPolicyV4.PostConditionsV4 conditions, Storage.PostPolicyV4Option ... options) {
        EnumMap<Storage.SignUrlOption.Option, Object> optionMap = Maps.newEnumMap(Storage.SignUrlOption.Option.class);
        for (Storage.PostPolicyV4Option option : options) {
            optionMap.put(Storage.SignUrlOption.Option.valueOf(option.getOption().name()), option.getValue());
        }
        optionMap.put(Storage.SignUrlOption.Option.SIGNATURE_VERSION, (Object)Storage.SignUrlOption.SignatureVersion.V4);
        ServiceAccountSigner credentials = (ServiceAccountSigner)optionMap.get((Object)Storage.SignUrlOption.Option.SERVICE_ACCOUNT_CRED);
        if (credentials == null) {
            Preconditions.checkState(this.getOptions().getCredentials() instanceof ServiceAccountSigner, "Signing key was not provided and could not be derived");
            credentials = (ServiceAccountSigner)((Object)this.getOptions().getCredentials());
        }
        Preconditions.checkArgument(!optionMap.containsKey((Object)Storage.SignUrlOption.Option.VIRTUAL_HOSTED_STYLE) || !optionMap.containsKey((Object)Storage.SignUrlOption.Option.PATH_STYLE) || !optionMap.containsKey((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME), "Only one of VIRTUAL_HOSTED_STYLE, PATH_STYLE, or BUCKET_BOUND_HOST_NAME SignUrlOptions can be specified.");
        String bucketName = this.slashlessBucketNameFromBlobInfo(blobInfo);
        boolean usePathStyle = this.shouldUsePathStyleForSignedUrl(optionMap);
        String url = usePathStyle ? this.STORAGE_XML_URI_SCHEME + "://" + this.STORAGE_XML_URI_HOST_NAME + PATH_DELIMITER + bucketName + PATH_DELIMITER : this.STORAGE_XML_URI_SCHEME + "://" + bucketName + "." + this.STORAGE_XML_URI_HOST_NAME + PATH_DELIMITER;
        if (optionMap.containsKey((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME)) {
            url = optionMap.get((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME) + PATH_DELIMITER;
        }
        SimpleDateFormat googDateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        SimpleDateFormat yearMonthDayFormat = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat expirationFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        googDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        yearMonthDayFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        expirationFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        long timestamp = this.getOptions().getClock().millisTime();
        String date = googDateFormat.format(timestamp);
        String signingCredential = credentials.getAccount() + PATH_DELIMITER + yearMonthDayFormat.format(timestamp) + "/auto/storage/goog4_request";
        HashMap<String, String> policyFields = new HashMap<String, String>();
        PostPolicyV4.PostConditionsV4.Builder conditionsBuilder = conditions.toBuilder();
        for (Map.Entry<String, String> entry : fields.getFieldsMap().entrySet()) {
            conditionsBuilder.addCustomCondition(PostPolicyV4.ConditionV4Type.MATCHES, entry.getKey(), entry.getValue());
            policyFields.put(entry.getKey(), entry.getValue());
        }
        PostPolicyV4.PostConditionsV4 v4Conditions = conditionsBuilder.addBucketCondition(PostPolicyV4.ConditionV4Type.MATCHES, blobInfo.getBucket()).addKeyCondition(PostPolicyV4.ConditionV4Type.MATCHES, blobInfo.getName()).addCustomCondition(PostPolicyV4.ConditionV4Type.MATCHES, "x-goog-date", date).addCustomCondition(PostPolicyV4.ConditionV4Type.MATCHES, "x-goog-credential", signingCredential).addCustomCondition(PostPolicyV4.ConditionV4Type.MATCHES, "x-goog-algorithm", "GOOG4-RSA-SHA256").build();
        PostPolicyV4.PostPolicyV4Document document = PostPolicyV4.PostPolicyV4Document.of(expirationFormat.format(timestamp + unit.toMillis(duration)), v4Conditions);
        String policy = BaseEncoding.base64().encode(document.toJson().getBytes());
        String signature = BaseEncoding.base16().encode(credentials.sign(policy.getBytes())).toLowerCase();
        for (PostPolicyV4.ConditionV4 condition : v4Conditions.getConditions()) {
            if (condition.type != PostPolicyV4.ConditionV4Type.MATCHES) continue;
            policyFields.put(condition.operand1, condition.operand2);
        }
        policyFields.put("key", blobInfo.getName());
        policyFields.put("x-goog-credential", signingCredential);
        policyFields.put("x-goog-algorithm", "GOOG4-RSA-SHA256");
        policyFields.put("x-goog-date", date);
        policyFields.put("x-goog-signature", signature);
        policyFields.put("policy", policy);
        policyFields.remove("bucket");
        return PostPolicyV4.of(url, policyFields);
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, PostPolicyV4.PostFieldsV4 fields, Storage.PostPolicyV4Option ... options) {
        return this.generateSignedPostPolicyV4(blobInfo, duration, unit, fields, PostPolicyV4.PostConditionsV4.newBuilder().build(), options);
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, PostPolicyV4.PostConditionsV4 conditions, Storage.PostPolicyV4Option ... options) {
        return this.generateSignedPostPolicyV4(blobInfo, duration, unit, PostPolicyV4.PostFieldsV4.newBuilder().build(), conditions, options);
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, Storage.PostPolicyV4Option ... options) {
        return this.generateSignedPostPolicyV4(blobInfo, duration, unit, PostPolicyV4.PostFieldsV4.newBuilder().build(), options);
    }

    private String constructResourceUriPath(String slashlessBucketName, String escapedBlobName, EnumMap<Storage.SignUrlOption.Option, Object> optionMap) {
        if (Strings.isNullOrEmpty(slashlessBucketName)) {
            if (Strings.isNullOrEmpty(escapedBlobName)) {
                return PATH_DELIMITER;
            }
            if (escapedBlobName.startsWith(PATH_DELIMITER)) {
                return escapedBlobName;
            }
            return PATH_DELIMITER + escapedBlobName;
        }
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append(PATH_DELIMITER).append(slashlessBucketName);
        if (Strings.isNullOrEmpty(escapedBlobName)) {
            boolean isV2 = this.getPreferredSignatureVersion(optionMap).equals((Object)Storage.SignUrlOption.SignatureVersion.V2);
            if (optionMap.containsKey((Object)Storage.SignUrlOption.Option.VIRTUAL_HOSTED_STYLE) && isV2) {
                pathBuilder.append(PATH_DELIMITER);
            }
            return pathBuilder.toString();
        }
        pathBuilder.append(PATH_DELIMITER);
        pathBuilder.append(escapedBlobName);
        return pathBuilder.toString();
    }

    private Storage.SignUrlOption.SignatureVersion getPreferredSignatureVersion(EnumMap<Storage.SignUrlOption.Option, Object> optionMap) {
        for (Storage.SignUrlOption.SignatureVersion version : Storage.SignUrlOption.SignatureVersion.values()) {
            if (!version.equals(optionMap.get((Object)Storage.SignUrlOption.Option.SIGNATURE_VERSION))) continue;
            return version;
        }
        return Storage.SignUrlOption.SignatureVersion.V2;
    }

    private boolean shouldUsePathStyleForSignedUrl(EnumMap<Storage.SignUrlOption.Option, Object> optionMap) {
        return !optionMap.containsKey((Object)Storage.SignUrlOption.Option.VIRTUAL_HOSTED_STYLE) && !optionMap.containsKey((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME);
    }

    private SignatureInfo buildSignatureInfo(Map<Storage.SignUrlOption.Option, Object> optionMap, BlobInfo blobInfo, long expiration, URI path, String accountEmail) {
        HttpMethod httpVerb = optionMap.containsKey((Object)Storage.SignUrlOption.Option.HTTP_METHOD) ? (HttpMethod)optionMap.get((Object)Storage.SignUrlOption.Option.HTTP_METHOD) : HttpMethod.GET;
        SignatureInfo.Builder signatureInfoBuilder = new SignatureInfo.Builder(httpVerb, expiration, path);
        if (MoreObjects.firstNonNull((Boolean)optionMap.get((Object)Storage.SignUrlOption.Option.MD5), false).booleanValue()) {
            Preconditions.checkArgument(blobInfo.getMd5() != null, "Blob is missing a value for md5");
            signatureInfoBuilder.setContentMd5(blobInfo.getMd5());
        }
        if (MoreObjects.firstNonNull((Boolean)optionMap.get((Object)Storage.SignUrlOption.Option.CONTENT_TYPE), false).booleanValue()) {
            Preconditions.checkArgument(blobInfo.getContentType() != null, "Blob is missing a value for content-type");
            signatureInfoBuilder.setContentType(blobInfo.getContentType());
        }
        signatureInfoBuilder.setSignatureVersion((Storage.SignUrlOption.SignatureVersion)((Object)optionMap.get((Object)Storage.SignUrlOption.Option.SIGNATURE_VERSION)));
        signatureInfoBuilder.setAccountEmail(accountEmail);
        signatureInfoBuilder.setTimestamp(this.getOptions().getClock().millisTime());
        ImmutableMap.Builder<String, String> extHeadersBuilder = new ImmutableMap.Builder<String, String>();
        boolean isV4 = Storage.SignUrlOption.SignatureVersion.V4.equals(optionMap.get((Object)Storage.SignUrlOption.Option.SIGNATURE_VERSION));
        if (isV4) {
            if (optionMap.containsKey((Object)Storage.SignUrlOption.Option.VIRTUAL_HOSTED_STYLE)) {
                extHeadersBuilder.put("host", this.slashlessBucketNameFromBlobInfo(blobInfo) + "." + this.getBaseStorageHostName(optionMap));
            } else if (optionMap.containsKey((Object)Storage.SignUrlOption.Option.HOST_NAME) || optionMap.containsKey((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME) || this.getOptions().getUniverseDomain() != null) {
                extHeadersBuilder.put("host", this.getBaseStorageHostName(optionMap));
            }
        }
        if (optionMap.containsKey((Object)Storage.SignUrlOption.Option.EXT_HEADERS)) {
            extHeadersBuilder.putAll((Map)optionMap.get((Object)Storage.SignUrlOption.Option.EXT_HEADERS));
        }
        ImmutableMap.Builder queryParamsBuilder = new ImmutableMap.Builder();
        if (optionMap.containsKey((Object)Storage.SignUrlOption.Option.QUERY_PARAMS)) {
            queryParamsBuilder.putAll((Map)optionMap.get((Object)Storage.SignUrlOption.Option.QUERY_PARAMS));
        }
        return signatureInfoBuilder.setCanonicalizedExtensionHeaders(extHeadersBuilder.build()).setCanonicalizedQueryParams(queryParamsBuilder.build()).build();
    }

    private String slashlessBucketNameFromBlobInfo(BlobInfo blobInfo) {
        return CharMatcher.anyOf(PATH_DELIMITER).trimFrom(blobInfo.getBucket());
    }

    private String getBaseStorageHostName(Map<Storage.SignUrlOption.Option, Object> optionMap) {
        String specifiedBaseHostName = (String)optionMap.get((Object)Storage.SignUrlOption.Option.HOST_NAME);
        String bucketBoundHostName = (String)optionMap.get((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME);
        if (!Strings.isNullOrEmpty(specifiedBaseHostName)) {
            return specifiedBaseHostName.replaceFirst("http(s)?://", "");
        }
        if (!Strings.isNullOrEmpty(bucketBoundHostName)) {
            return bucketBoundHostName.replaceFirst("http(s)?://", "");
        }
        return this.STORAGE_XML_URI_HOST_NAME;
    }

    @Override
    public List<Blob> get(BlobId ... blobIds) {
        return this.get(Arrays.asList(blobIds));
    }

    @Override
    public List<Blob> get(Iterable<BlobId> blobIds) {
        StorageBatch batch = this.batch();
        final ArrayList results = Lists.newArrayList();
        for (BlobId blob : blobIds) {
            batch.get(blob, new Storage.BlobGetOption[0]).notify(new BatchResult.Callback<Blob, StorageException>(){

                @Override
                public void success(Blob result) {
                    results.add(result);
                }

                @Override
                public void error(StorageException exception) {
                    results.add(null);
                }
            });
        }
        batch.submit();
        return Collections.unmodifiableList(results);
    }

    @Override
    public List<Blob> update(BlobInfo ... blobInfos) {
        return this.update(Arrays.asList(blobInfos));
    }

    @Override
    public List<Blob> update(Iterable<BlobInfo> blobInfos) {
        StorageBatch batch = this.batch();
        final ArrayList results = Lists.newArrayList();
        for (BlobInfo blobInfo : blobInfos) {
            batch.update(blobInfo, new Storage.BlobTargetOption[0]).notify(new BatchResult.Callback<Blob, StorageException>(){

                @Override
                public void success(Blob result) {
                    results.add(result);
                }

                @Override
                public void error(StorageException exception) {
                    results.add(null);
                }
            });
        }
        batch.submit();
        return Collections.unmodifiableList(results);
    }

    @Override
    public List<Boolean> delete(BlobId ... blobIds) {
        return this.delete(Arrays.asList(blobIds));
    }

    @Override
    public List<Boolean> delete(Iterable<BlobId> blobIds) {
        StorageBatch batch = this.batch();
        final ArrayList results = Lists.newArrayList();
        for (BlobId blob : blobIds) {
            batch.delete(blob, new Storage.BlobSourceOption[0]).notify(new BatchResult.Callback<Boolean, StorageException>(){

                @Override
                public void success(Boolean result) {
                    results.add(result);
                }

                @Override
                public void error(StorageException exception) {
                    results.add(Boolean.FALSE);
                }
            });
        }
        batch.submit();
        return Collections.unmodifiableList(results);
    }

    @Override
    public Acl getAcl(String bucket, Acl.Entity entity, Storage.BucketSourceOption ... options) {
        String pb = (String)codecs.entity().encode(entity);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketAclGet(pb, optionsMap);
        return (Acl)((Object)this.run(algorithm, () -> this.storageRpc.getAcl(bucket, pb, optionsMap), codecs.bucketAcl()));
    }

    @Override
    public Acl getAcl(String bucket, Acl.Entity entity) {
        return this.getAcl(bucket, entity, new Storage.BucketSourceOption[0]);
    }

    @Override
    public boolean deleteAcl(String bucket, Acl.Entity entity, Storage.BucketSourceOption ... options) {
        String pb = (String)codecs.entity().encode(entity);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketAclDelete(pb, optionsMap);
        return (Boolean)this.run(algorithm, () -> this.storageRpc.deleteAcl(bucket, pb, optionsMap), Conversions.Decoder.identity());
    }

    @Override
    public boolean deleteAcl(String bucket, Acl.Entity entity) {
        return this.deleteAcl(bucket, entity, new Storage.BucketSourceOption[0]);
    }

    @Override
    public Acl createAcl(String bucket, Acl acl, Storage.BucketSourceOption ... options) {
        BucketAccessControl aclPb = ((BucketAccessControl)codecs.bucketAcl().encode(acl)).setBucket(bucket);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketAclCreate(aclPb, optionsMap);
        return (Acl)((Object)this.run(algorithm, () -> this.storageRpc.createAcl(aclPb, optionsMap), codecs.bucketAcl()));
    }

    @Override
    public Acl createAcl(String bucket, Acl acl) {
        return this.createAcl(bucket, acl, new Storage.BucketSourceOption[0]);
    }

    @Override
    public Acl updateAcl(String bucket, Acl acl, Storage.BucketSourceOption ... options) {
        BucketAccessControl aclPb = ((BucketAccessControl)codecs.bucketAcl().encode(acl)).setBucket(bucket);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketAclUpdate(aclPb, optionsMap);
        return (Acl)((Object)this.run(algorithm, () -> this.storageRpc.patchAcl(aclPb, optionsMap), codecs.bucketAcl()));
    }

    @Override
    public Acl updateAcl(String bucket, Acl acl) {
        return this.updateAcl(bucket, acl, new Storage.BucketSourceOption[0]);
    }

    @Override
    public List<Acl> listAcls(String bucket, Storage.BucketSourceOption ... options) {
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketAclList(bucket, optionsMap);
        return this.run(algorithm, () -> this.storageRpc.listAcls(bucket, optionsMap), answer -> answer.stream().map(codecs.bucketAcl()::decode).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public List<Acl> listAcls(String bucket) {
        return this.listAcls(bucket, new Storage.BucketSourceOption[0]);
    }

    @Override
    public Acl getDefaultAcl(String bucket, Acl.Entity entity) {
        String pb = (String)codecs.entity().encode(entity);
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForDefaultObjectAclGet(pb);
        return (Acl)((Object)this.run(algorithm, () -> this.storageRpc.getDefaultAcl(bucket, pb), codecs.objectAcl()));
    }

    @Override
    public boolean deleteDefaultAcl(String bucket, Acl.Entity entity) {
        String pb = (String)codecs.entity().encode(entity);
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForDefaultObjectAclDelete(pb);
        return (Boolean)this.run(algorithm, () -> this.storageRpc.deleteDefaultAcl(bucket, pb), Conversions.Decoder.identity());
    }

    @Override
    public Acl createDefaultAcl(String bucket, Acl acl) {
        ObjectAccessControl aclPb = ((ObjectAccessControl)codecs.objectAcl().encode(acl)).setBucket(bucket);
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForDefaultObjectAclCreate(aclPb);
        return (Acl)((Object)this.run(algorithm, () -> this.storageRpc.createDefaultAcl(aclPb), codecs.objectAcl()));
    }

    @Override
    public Acl updateDefaultAcl(String bucket, Acl acl) {
        ObjectAccessControl aclPb = ((ObjectAccessControl)codecs.objectAcl().encode(acl)).setBucket(bucket);
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForDefaultObjectAclUpdate(aclPb);
        return (Acl)((Object)this.run(algorithm, () -> this.storageRpc.patchDefaultAcl(aclPb), codecs.objectAcl()));
    }

    @Override
    public List<Acl> listDefaultAcls(String bucket) {
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForDefaultObjectAclList(bucket);
        return this.run(algorithm, () -> this.storageRpc.listDefaultAcls(bucket), answer -> answer.stream().map(codecs.objectAcl()::decode).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public Acl getAcl(BlobId blob, Acl.Entity entity) {
        String bucket = blob.getBucket();
        String name = blob.getName();
        Long generation = blob.getGeneration();
        String pb = (String)codecs.entity().encode(entity);
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectAclGet(bucket, name, generation, pb);
        return (Acl)((Object)this.run(algorithm, () -> this.storageRpc.getAcl(bucket, name, generation, pb), codecs.objectAcl()));
    }

    @Override
    public boolean deleteAcl(BlobId blob, Acl.Entity entity) {
        String bucket = blob.getBucket();
        String name = blob.getName();
        Long generation = blob.getGeneration();
        String pb = (String)codecs.entity().encode(entity);
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectAclDelete(bucket, name, generation, pb);
        return (Boolean)this.run(algorithm, () -> this.storageRpc.deleteAcl(bucket, name, generation, pb), Conversions.Decoder.identity());
    }

    @Override
    public Acl createAcl(BlobId blob, Acl acl) {
        ObjectAccessControl aclPb = ((ObjectAccessControl)codecs.objectAcl().encode(acl)).setBucket(blob.getBucket()).setObject(blob.getName()).setGeneration(blob.getGeneration());
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectAclCreate(aclPb);
        return (Acl)((Object)this.run(algorithm, () -> this.storageRpc.createAcl(aclPb), codecs.objectAcl()));
    }

    @Override
    public Acl updateAcl(BlobId blob, Acl acl) {
        ObjectAccessControl aclPb = ((ObjectAccessControl)codecs.objectAcl().encode(acl)).setBucket(blob.getBucket()).setObject(blob.getName()).setGeneration(blob.getGeneration());
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectAclUpdate(aclPb);
        return (Acl)((Object)this.run(algorithm, () -> this.storageRpc.patchAcl(aclPb), codecs.objectAcl()));
    }

    @Override
    public List<Acl> listAcls(BlobId blob) {
        String bucket = blob.getBucket();
        String name = blob.getName();
        Long generation = blob.getGeneration();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectAclList(bucket, name, generation);
        return this.run(algorithm, () -> this.storageRpc.listAcls(bucket, name, generation), answer -> answer.stream().map(codecs.objectAcl()::decode).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public HmacKey createHmacKey(ServiceAccount serviceAccount, Storage.CreateHmacKeyOption ... options) {
        String pb = serviceAccount.getEmail();
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForHmacKeyCreate(pb, optionsMap);
        return (HmacKey)((Object)this.run(algorithm, () -> this.storageRpc.createHmacKey(pb, optionsMap), codecs.hmacKey()));
    }

    @Override
    public Page<HmacKey.HmacKeyMetadata> listHmacKeys(Storage.ListHmacKeysOption ... options) {
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        return StorageImpl.listHmacKeys(this.getOptions(), this.retryAlgorithmManager, optionsMap, this.retrier);
    }

    @Override
    public HmacKey.HmacKeyMetadata getHmacKey(String accessId, Storage.GetHmacKeyOption ... options) {
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForHmacKeyGet(accessId, optionsMap);
        return (HmacKey.HmacKeyMetadata)((Object)this.run(algorithm, () -> this.storageRpc.getHmacKey(accessId, optionsMap), codecs.hmacKeyMetadata()));
    }

    private HmacKey.HmacKeyMetadata updateHmacKey(HmacKey.HmacKeyMetadata hmacKeyMetadata, Storage.UpdateHmacKeyOption ... options) {
        HmacKeyMetadata pb = (HmacKeyMetadata)codecs.hmacKeyMetadata().encode(hmacKeyMetadata);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForHmacKeyUpdate(pb, optionsMap);
        return (HmacKey.HmacKeyMetadata)((Object)this.run(algorithm, () -> this.storageRpc.updateHmacKey(pb, optionsMap), codecs.hmacKeyMetadata()));
    }

    @Override
    public HmacKey.HmacKeyMetadata updateHmacKeyState(HmacKey.HmacKeyMetadata hmacKeyMetadata, HmacKey.HmacKeyState state, Storage.UpdateHmacKeyOption ... options) {
        HmacKey.HmacKeyMetadata updatedMetadata = HmacKey.HmacKeyMetadata.newBuilder(hmacKeyMetadata.getServiceAccount()).setProjectId(hmacKeyMetadata.getProjectId()).setAccessId(hmacKeyMetadata.getAccessId()).setState(state).build();
        return this.updateHmacKey(updatedMetadata, options);
    }

    @Override
    public void deleteHmacKey(HmacKey.HmacKeyMetadata metadata, Storage.DeleteHmacKeyOption ... options) {
        HmacKeyMetadata pb = (HmacKeyMetadata)codecs.hmacKeyMetadata().encode(metadata);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForHmacKeyDelete(pb, optionsMap);
        this.run(algorithm, () -> {
            this.storageRpc.deleteHmacKey(pb, optionsMap);
            return null;
        }, Conversions.Decoder.identity());
    }

    private static Page<HmacKey.HmacKeyMetadata> listHmacKeys(HttpStorageOptions serviceOptions, HttpRetryAlgorithmManager retryAlgorithmManager, Map<StorageRpc.Option, ?> options, Retrying.Retrier retrier) {
        ResultRetryAlgorithm<?> algorithm = retryAlgorithmManager.getForHmacKeyList(options);
        return retrier.run(algorithm, () -> serviceOptions.getStorageRpcV1().listHmacKeys(options), (Response result) -> {
            String cursor = (String)result.x();
            ImmutableList metadata = result.y() == null ? ImmutableList.of() : Iterables.transform((Iterable)result.y(), codecs.hmacKeyMetadata()::decode);
            return new PageImpl<HmacKey.HmacKeyMetadata>(new HmacKeyMetadataPageFetcher(serviceOptions, retryAlgorithmManager, options, retrier), cursor, metadata);
        });
    }

    @Override
    public Policy getIamPolicy(String bucket, Storage.BucketSourceOption ... options) {
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketsGetIamPolicy(bucket, optionsMap);
        return this.run(algorithm, () -> this.storageRpc.getIamPolicy(bucket, optionsMap), apiPolicy -> (Policy)Conversions.json().policyCodec().decode(apiPolicy));
    }

    @Override
    public Policy setIamPolicy(String bucket, Policy policy, Storage.BucketSourceOption ... options) {
        com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.services.storage.model.Policy pb = (com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.services.storage.model.Policy)Conversions.json().policyCodec().encode(policy);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketsSetIamPolicy(bucket, pb, optionsMap);
        return this.run(algorithm, () -> this.storageRpc.setIamPolicy(bucket, pb, optionsMap), apiPolicy -> (Policy)Conversions.json().policyCodec().decode(apiPolicy));
    }

    @Override
    public List<Boolean> testIamPermissions(String bucket, List<String> permissions, Storage.BucketSourceOption ... options) {
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketsTestIamPermissions(bucket, permissions, optionsMap);
        return this.run(algorithm, () -> this.storageRpc.testIamPermissions(bucket, permissions, optionsMap), response -> {
            ImmutableSet heldPermissions = response.getPermissions() != null ? ImmutableSet.copyOf(response.getPermissions()) : ImmutableSet.of();
            return permissions.stream().map(heldPermissions::contains).collect(ImmutableList.toImmutableList());
        });
    }

    @Override
    public Bucket lockRetentionPolicy(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.services.storage.model.Bucket bucketPb = (com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.services.storage.model.Bucket)codecs.bucketInfo().encode(bucketInfo);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(bucketInfo).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketsLockRetentionPolicy(bucketPb, optionsMap);
        return this.run(algorithm, () -> this.storageRpc.lockRetentionPolicy(bucketPb, optionsMap), x -> ((BucketInfo)Conversions.json().bucketInfo().decode(x)).asBucket(this));
    }

    @Override
    public ServiceAccount getServiceAccount(String projectId) {
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForServiceAccountGet(projectId);
        return (ServiceAccount)((Object)this.run(algorithm, () -> this.storageRpc.getServiceAccount(projectId), codecs.serviceAccount()));
    }

    private <T, U> U run(ResultRetryAlgorithm<?> algorithm, Callable<T> c, Conversions.Decoder<T, U> f) {
        return this.retrier.run(algorithm, c, f);
    }

    @Override
    public Notification createNotification(String bucket, NotificationInfo notificationInfo) {
        com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.services.storage.model.Notification notificationPb = (com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.services.storage.model.Notification)codecs.notificationInfo().encode(notificationInfo);
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForNotificationCreate(bucket, notificationPb);
        return this.run(algorithm, () -> this.storageRpc.createNotification(bucket, notificationPb), n -> ((NotificationInfo)codecs.notificationInfo().decode(n)).asNotification(this));
    }

    @Override
    public Notification getNotification(String bucket, String notificationId) {
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForNotificationGet(bucket, notificationId);
        return this.run(algorithm, () -> this.storageRpc.getNotification(bucket, notificationId), n -> ((NotificationInfo)codecs.notificationInfo().decode(n)).asNotification(this));
    }

    @Override
    public List<Notification> listNotifications(String bucket) {
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForNotificationList(bucket);
        List result = this.run(algorithm, () -> this.storageRpc.listNotifications(bucket), answer -> answer.stream().map(n -> ((NotificationInfo)codecs.notificationInfo().decode(n)).asNotification(this)).collect(ImmutableList.toImmutableList()));
        return result == null ? ImmutableList.of() : result;
    }

    @Override
    public boolean deleteNotification(String bucket, String notificationId) {
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForNotificationDelete(bucket, notificationId);
        return (Boolean)this.run(algorithm, () -> this.storageRpc.deleteNotification(bucket, notificationId), Conversions.Decoder.identity());
    }

    @Override
    public HttpStorageOptions getOptions() {
        return (HttpStorageOptions)super.getOptions();
    }

    private Blob internalGetBlob(BlobId blob, Map<StorageRpc.Option, ?> optionsMap) {
        StorageObject storedObject = (StorageObject)codecs.blobId().encode(blob);
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectsGet(storedObject, optionsMap);
        return this.run(algorithm, () -> this.storageRpc.get(storedObject, optionsMap), x -> {
            BlobInfo info = (BlobInfo)Conversions.json().blobInfo().decode(x);
            return info.asBlob(this);
        });
    }

    private Bucket internalBucketGet(String bucket, Map<StorageRpc.Option, ?> optionsMap) {
        com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.services.storage.model.Bucket bucketPb = (com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.services.storage.model.Bucket)codecs.bucketInfo().encode(BucketInfo.of(bucket));
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketsGet(bucketPb, optionsMap);
        return this.run(algorithm, () -> this.storageRpc.get(bucketPb, optionsMap), b -> ((BucketInfo)Conversions.json().bucketInfo().decode(b)).asBucket(this));
    }

    @Override
    public BlobWriteSession blobWriteSession(BlobInfo blobInfo, Storage.BlobWriteOption ... options) {
        UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(blobInfo);
        WritableByteChannelSession<?, BlobInfo> writableByteChannelSession = this.writerFactory.writeSession(this, blobInfo, opts);
        return BlobWriteSessions.of(writableByteChannelSession);
    }

    @Override
    public Blob moveBlob(Storage.MoveBlobRequest request) {
        UnifiedOpts.Opts srcOpts = UnifiedOpts.Opts.unwrap(request.getSourceOptions()).resolveFrom(request.getSource()).projectAsSource();
        UnifiedOpts.Opts dstOpts = UnifiedOpts.Opts.unwrap(request.getTargetOptions()).resolveFrom(request.getTarget());
        ImmutableMap<StorageRpc.Option, ?> sourceOptions = srcOpts.getRpcOptions();
        ImmutableMap<StorageRpc.Option, ?> targetOptions = dstOpts.getRpcOptions();
        return this.run(this.retryAlgorithmManager.getForObjectsMove(sourceOptions, targetOptions), () -> this.storageRpc.moveObject(request.getSource().getBucket(), request.getSource().getName(), request.getTarget().getName(), sourceOptions, targetOptions), o -> ((BlobInfo)codecs.blobInfo().decode(o)).asBlob(this));
    }

    @Override
    public BlobInfo internalCreateFrom(Path path, BlobInfo info, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new StorageException(0, path + " is a directory");
        }
        long size = Files.size(path);
        if (size == 0L) {
            return this.internalCreate(info, EMPTY_BYTE_ARRAY, 0, 0, opts);
        }
        ImmutableMap<StorageRpc.Option, ?> optionsMap = opts.getRpcOptions();
        BlobInfo.Builder builder = info.toBuilder().setMd5(null).setCrc32c(null);
        BlobInfo updated = opts.blobInfoMapper().apply(builder).build();
        StorageObject encode = (StorageObject)codecs.blobInfo().encode(updated);
        Supplier<String> uploadIdSupplier = ResumableMedia.startUploadForBlobInfo(this.getOptions(), updated, optionsMap, this.retrier.withAlg(this.retryAlgorithmManager.getForResumableUploadSessionCreate(optionsMap)));
        JsonResumableWrite jsonResumableWrite = JsonResumableWrite.of(encode, optionsMap, uploadIdSupplier.get(), 0L);
        JsonResumableSession session = ResumableSession.json(HttpClientContext.from(this.storageRpc), this.retrier.withAlg(this.retryAlgorithmManager.idempotent()), jsonResumableWrite);
        HttpContentRange.Total contentRange = HttpContentRange.of(ByteRangeSpec.explicit(0L, size), size);
        ResumableOperationResult<StorageObject> put = session.put(RewindableContent.of(path), contentRange);
        StorageObject object = put.getObject();
        if (object == null) {
            ResumableOperationResult<StorageObject> query = session.query();
            object = query.getObject();
        }
        return (BlobInfo)codecs.blobInfo().decode(object);
    }

    @Override
    public BlobInfo internalDirectUpload(BlobInfo info, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts, ByteBuffer buf) {
        BlobInfo.Builder builder = info.toBuilder().setMd5(BaseEncoding.base64().encode(Hashing.md5().hashBytes(buf.duplicate()).asBytes())).setCrc32c(BaseEncoding.base64().encode(Ints.toByteArray(Hashing.crc32c().hashBytes(buf.duplicate()).asInt())));
        ImmutableMap<StorageRpc.Option, ?> optionsMap = opts.getRpcOptions();
        BlobInfo updated = opts.blobInfoMapper().apply(builder).build();
        StorageObject encoded = (StorageObject)codecs.blobInfo().encode(updated);
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectsCreate(encoded, optionsMap);
        RewindableContent content = RewindableContent.of(buf);
        return (BlobInfo)((Object)this.run(algorithm, () -> {
            content.rewindTo(0L);
            return this.storageRpc.create(encoded, new RewindableContentInputStream(content), optionsMap);
        }, Conversions.json().blobInfo()));
    }

    @Override
    public Void internalObjectDelete(BlobId id, UnifiedOpts.Opts<UnifiedOpts.ObjectSourceOpt> opts) {
        StorageObject storageObject = (StorageObject)codecs.blobId().encode(id);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = opts.getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectsDelete(storageObject, optionsMap);
        return (Void)this.run(algorithm, () -> {
            boolean deleted = this.storageRpc.delete(storageObject, optionsMap);
            if (!deleted) {
                throw new StorageException(404, "NOT_FOUND", null, null);
            }
            return null;
        }, Conversions.Decoder.identity());
    }

    @Override
    public BlobInfo internalObjectGet(BlobId blobId, UnifiedOpts.Opts<UnifiedOpts.ObjectSourceOpt> opts) {
        StorageObject storedObject = (StorageObject)codecs.blobId().encode(blobId);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = opts.getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectsGet(storedObject, optionsMap);
        return (BlobInfo)((Object)this.run(algorithm, () -> {
            StorageObject storageObject = this.storageRpc.get(storedObject, optionsMap);
            if (storageObject == null) {
                throw new StorageException(404, "NOT_FOUND", null, null);
            }
            return storageObject;
        }, codecs.blobInfo()));
    }

    private static class HmacKeyMetadataPageFetcher
    implements PageImpl.NextPageFetcher<HmacKey.HmacKeyMetadata> {
        private static final long serialVersionUID = -8637392485924772927L;
        private final HttpStorageOptions serviceOptions;
        private final HttpRetryAlgorithmManager retryAlgorithmManager;
        private final Map<StorageRpc.Option, ?> options;
        private final Retrying.Retrier retrier;

        HmacKeyMetadataPageFetcher(HttpStorageOptions serviceOptions, HttpRetryAlgorithmManager retryAlgorithmManager, Map<StorageRpc.Option, ?> options, Retrying.Retrier retrier) {
            this.serviceOptions = serviceOptions;
            this.retryAlgorithmManager = retryAlgorithmManager;
            this.options = options;
            this.retrier = retrier;
        }

        @Override
        public Page<HmacKey.HmacKeyMetadata> getNextPage() {
            return StorageImpl.listHmacKeys(this.serviceOptions, this.retryAlgorithmManager, this.options, this.retrier);
        }
    }

    private static class BlobPageFetcher
    implements PageImpl.NextPageFetcher<Blob> {
        private static final long serialVersionUID = -4308415167471093443L;
        private final Map<StorageRpc.Option, ?> requestOptions;
        private final HttpStorageOptions serviceOptions;
        private final String bucket;
        private final Retrying.Retrier retrier;

        BlobPageFetcher(String bucket, HttpStorageOptions serviceOptions, String cursor, Map<StorageRpc.Option, ?> optionMap, Retrying.Retrier retrier) {
            this.retrier = retrier;
            this.requestOptions = PageImpl.nextRequestOptions(StorageRpc.Option.PAGE_TOKEN, cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.bucket = bucket;
        }

        @Override
        public Page<Blob> getNextPage() {
            return StorageImpl.listBlobs(this.bucket, this.serviceOptions, this.requestOptions, this.retrier);
        }
    }

    private static class BucketPageFetcher
    implements PageImpl.NextPageFetcher<Bucket> {
        private static final long serialVersionUID = 8534413447247364038L;
        private final Map<StorageRpc.Option, ?> requestOptions;
        private final HttpStorageOptions serviceOptions;
        private final Retrying.Retrier retrier;

        BucketPageFetcher(HttpStorageOptions serviceOptions, String cursor, Map<StorageRpc.Option, ?> optionMap, Retrying.Retrier retrier) {
            this.requestOptions = PageImpl.nextRequestOptions(StorageRpc.Option.PAGE_TOKEN, cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.retrier = retrier;
        }

        @Override
        public Page<Bucket> getNextPage() {
            return StorageImpl.listBuckets(this.serviceOptions, this.requestOptions, this.retrier);
        }
    }
}

