/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BufferedReadableByteChannelSession;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BufferedWritableByteChannelSession;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.UnbufferedReadableByteChannelSession;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.UnbufferedWritableByteChannelSession;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.concurrent.locks.ReentrantLock;

final class StorageByteChannels {
    StorageByteChannels() {
    }

    static Readable readable() {
        return Readable.INSTANCE;
    }

    static Writable writable() {
        return Writable.INSTANCE;
    }

    public static SeekableByteChannel seekable(SeekableByteChannel delegate) {
        return new SynchronizedSeekableByteChannel(delegate);
    }

    static final class Readable {
        private static final Readable INSTANCE = new Readable();

        private Readable() {
        }

        public BufferedReadableByteChannelSession.BufferedReadableByteChannel createSynchronized(BufferedReadableByteChannelSession.BufferedReadableByteChannel delegate) {
            return new SynchronizedBufferedReadableByteChannel(delegate);
        }

        public UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel createSynchronized(UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel delegate) {
            return new SynchronizedUnbufferedReadableByteChannel(delegate);
        }

        public ScatteringByteChannel asScatteringByteChannel(ReadableByteChannel c) {
            return new ScatteringByteChannelFacade(c);
        }
    }

    static final class Writable {
        private static final Writable INSTANCE = new Writable();

        private Writable() {
        }

        public BufferedWritableByteChannelSession.BufferedWritableByteChannel createSynchronized(BufferedWritableByteChannelSession.BufferedWritableByteChannel delegate) {
            return new SynchronizedBufferedWritableByteChannel(delegate);
        }

        public UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel createSynchronized(UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel delegate) {
            return new SynchronizedUnbufferedWritableByteChannel(delegate);
        }
    }

    private static final class SynchronizedSeekableByteChannel
    implements SeekableByteChannel {
        private final SeekableByteChannel delegate;
        private final ReentrantLock lock;

        private SynchronizedSeekableByteChannel(SeekableByteChannel delegate) {
            this.delegate = delegate;
            this.lock = new ReentrantLock();
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            this.lock.lock();
            try {
                int n = this.delegate.read(dst);
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            this.lock.lock();
            try {
                int n = this.delegate.write(src);
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public long position() throws IOException {
            this.lock.lock();
            try {
                long l = this.delegate.position();
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SeekableByteChannel position(long newPosition) throws IOException {
            this.lock.lock();
            try {
                SeekableByteChannel seekableByteChannel = this.delegate.position(newPosition);
                return seekableByteChannel;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public long size() throws IOException {
            this.lock.lock();
            try {
                long l = this.delegate.size();
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SeekableByteChannel truncate(long size) throws IOException {
            this.lock.lock();
            try {
                SeekableByteChannel seekableByteChannel = this.delegate.truncate(size);
                return seekableByteChannel;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public boolean isOpen() {
            this.lock.lock();
            try {
                boolean bl = this.delegate.isOpen();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void close() throws IOException {
            this.lock.lock();
            try {
                this.delegate.close();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static final class ScatteringByteChannelFacade
    implements ScatteringByteChannel {
        private final ReadableByteChannel c;

        private ScatteringByteChannelFacade(ReadableByteChannel c) {
            this.c = c;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return Math.toIntExact(this.read(new ByteBuffer[]{dst}, 0, 1));
        }

        @Override
        public long read(ByteBuffer[] dsts) throws IOException {
            return this.read(dsts, 0, dsts.length);
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            if (!this.c.isOpen()) {
                throw new ClosedChannelException();
            }
            long totalBytesRead = 0L;
            for (int i = offset; i < length; ++i) {
                ByteBuffer dst = dsts[i];
                int goal = dst.remaining();
                if (!dst.hasRemaining()) continue;
                int read = this.c.read(dst);
                if (read == -1) {
                    if (totalBytesRead != 0L) break;
                    this.c.close();
                    return -1L;
                }
                if (read != goal) {
                    return totalBytesRead + (long)read;
                }
                totalBytesRead += (long)read;
            }
            return totalBytesRead;
        }

        @Override
        public boolean isOpen() {
            return this.c.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.c.close();
        }
    }

    private static final class SynchronizedUnbufferedWritableByteChannel
    implements UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel {
        private final UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel delegate;
        private final ReentrantLock lock;

        private SynchronizedUnbufferedWritableByteChannel(UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel delegate) {
            this.delegate = delegate;
            this.lock = new ReentrantLock();
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            this.lock.lock();
            try {
                int n = this.delegate.write(src);
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long write(ByteBuffer[] srcs) throws IOException {
            this.lock.lock();
            try {
                long l = this.delegate.write(srcs);
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            this.lock.lock();
            try {
                long l = this.delegate.write(srcs, offset, length);
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public int writeAndClose(ByteBuffer src) throws IOException {
            this.lock.lock();
            try {
                int n = this.delegate.writeAndClose(src);
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long writeAndClose(ByteBuffer[] srcs) throws IOException {
            this.lock.lock();
            try {
                long l = this.delegate.writeAndClose(srcs);
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long writeAndClose(ByteBuffer[] srcs, int offset, int length) throws IOException {
            this.lock.lock();
            try {
                long l = this.delegate.writeAndClose(srcs, offset, length);
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public boolean isOpen() {
            this.lock.lock();
            try {
                boolean bl = this.delegate.isOpen();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void close() throws IOException {
            this.lock.lock();
            try {
                this.delegate.close();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static final class SynchronizedUnbufferedReadableByteChannel
    implements UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel {
        private final UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel delegate;
        private final ReentrantLock lock;

        private SynchronizedUnbufferedReadableByteChannel(UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel delegate) {
            this.delegate = delegate;
            this.lock = new ReentrantLock();
        }

        @Override
        public int read(ByteBuffer src) throws IOException {
            this.lock.lock();
            try {
                int n = this.delegate.read(src);
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long read(ByteBuffer[] dsts) throws IOException {
            this.lock.lock();
            try {
                long l = this.delegate.read(dsts);
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            this.lock.lock();
            try {
                long l = this.delegate.read(dsts, offset, length);
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public boolean isOpen() {
            this.lock.lock();
            try {
                boolean bl = this.delegate.isOpen();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void close() throws IOException {
            this.lock.lock();
            try {
                this.delegate.close();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static final class SynchronizedBufferedWritableByteChannel
    implements BufferedWritableByteChannelSession.BufferedWritableByteChannel {
        private final BufferedWritableByteChannelSession.BufferedWritableByteChannel delegate;
        private final ReentrantLock lock;

        public SynchronizedBufferedWritableByteChannel(BufferedWritableByteChannelSession.BufferedWritableByteChannel delegate) {
            this.delegate = delegate;
            this.lock = new ReentrantLock();
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            this.lock.lock();
            try {
                int n = this.delegate.write(src);
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public boolean isOpen() {
            this.lock.lock();
            try {
                boolean bl = this.delegate.isOpen();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void close() throws IOException {
            this.lock.lock();
            try {
                this.delegate.close();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void flush() throws IOException {
            this.lock.lock();
            try {
                this.delegate.flush();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static final class SynchronizedBufferedReadableByteChannel
    implements BufferedReadableByteChannelSession.BufferedReadableByteChannel {
        private final BufferedReadableByteChannelSession.BufferedReadableByteChannel delegate;
        private final ReentrantLock lock;

        public SynchronizedBufferedReadableByteChannel(BufferedReadableByteChannelSession.BufferedReadableByteChannel delegate) {
            this.delegate = delegate;
            this.lock = new ReentrantLock();
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            this.lock.lock();
            try {
                int n = this.delegate.read(dst);
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public boolean isOpen() {
            this.lock.lock();
            try {
                boolean bl = this.delegate.isOpen();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void close() throws IOException {
            this.lock.lock();
            try {
                this.delegate.close();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

