/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BlobInfo;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Conversions;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.GapicDownloadSessionBuilder;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.GapicUploadSessionBuilder;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.HttpDownloadSessionBuilder;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.HttpStorageOptions;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.HttpUploadSessionBuilder;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Retrying;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.StorageException;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.spi.v1.StorageRpc;
import java.net.URL;
import java.util.Map;
import java.util.function.Supplier;

final class ResumableMedia {
    ResumableMedia() {
    }

    static Supplier<String> startUploadForBlobInfo(HttpStorageOptions storageOptions, BlobInfo blob, Map<StorageRpc.Option, ?> optionsMap, Retrying.RetrierWithAlg retrier) {
        return () -> (String)retrier.run(() -> storageOptions.getStorageRpcV1().open((StorageObject)Conversions.json().blobInfo().encode(blob), optionsMap), Conversions.Decoder.identity());
    }

    static Supplier<String> startUploadForSignedUrl(HttpStorageOptions storageOptions, URL signedURL, Retrying.RetrierWithAlg retrier) {
        if (!ResumableMedia.isValidSignedURL(signedURL.getQuery())) {
            throw new StorageException(2, "invalid signedURL");
        }
        return () -> (String)retrier.run(() -> storageOptions.getStorageRpcV1().open(signedURL.toString()), Conversions.Decoder.identity());
    }

    static GapicMediaSession gapic() {
        return GapicMediaSession.INSTANCE;
    }

    static HttpMediaSession http() {
        return HttpMediaSession.INSTANCE;
    }

    private static boolean isValidSignedURL(String signedURLQuery) {
        boolean isValid = true;
        if (signedURLQuery.startsWith("X-Goog-Algorithm=")) {
            if (!(signedURLQuery.contains("&X-Goog-Credential=") && signedURLQuery.contains("&X-Goog-Date=") && signedURLQuery.contains("&X-Goog-Expires=") && signedURLQuery.contains("&X-Goog-SignedHeaders=") && signedURLQuery.contains("&X-Goog-Signature="))) {
                isValid = false;
            }
        } else if (signedURLQuery.startsWith("GoogleAccessId=")) {
            if (!signedURLQuery.contains("&Expires=") || !signedURLQuery.contains("&Signature=")) {
                isValid = false;
            }
        } else {
            isValid = false;
        }
        return isValid;
    }

    static final class GapicMediaSession {
        private static final GapicMediaSession INSTANCE = new GapicMediaSession();

        private GapicMediaSession() {
        }

        GapicUploadSessionBuilder write() {
            return GapicUploadSessionBuilder.create();
        }

        GapicDownloadSessionBuilder read() {
            return GapicDownloadSessionBuilder.create();
        }
    }

    static final class HttpMediaSession {
        private static final HttpMediaSession INSTANCE = new HttpMediaSession();

        private HttpMediaSession() {
        }

        HttpUploadSessionBuilder write() {
            return HttpUploadSessionBuilder.create();
        }

        HttpDownloadSessionBuilder read() {
            return HttpDownloadSessionBuilder.create();
        }
    }
}

