/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.core.BetaApi;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.OptionalLong;
import javax.annotation.concurrent.Immutable;
import org.checkerframework.checker.nullness.qual.NonNull;

@BetaApi
@Immutable
public abstract class RangeSpec {
    private RangeSpec() {
    }

    @BetaApi
    public abstract long begin();

    @BetaApi
    public abstract OptionalLong maxLength();

    @BetaApi
    public abstract @NonNull RangeSpec withMaxLength(long var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    @BetaApi
    public static @NonNull RangeSpec beginAt(long begin) {
        Preconditions.checkArgument(begin >= 0L, "range being must be >= 0 (range begin = %s)", begin);
        return new RangeSpecWithoutLimit(begin);
    }

    @BetaApi
    public static @NonNull RangeSpec of(long begin, long maxLength) {
        Preconditions.checkArgument(begin >= 0L, "range being must be >= 0 (range begin = %s)", begin);
        Preconditions.checkArgument(maxLength >= 0L, "range maxLength must be >= 0 (range maxLength = %s)", maxLength);
        if (maxLength == 0L) {
            return new RangeSpecWithoutLimit(begin);
        }
        return new RangeSpecWithMaxLength(begin, maxLength);
    }

    @BetaApi
    public static @NonNull RangeSpec all() {
        return RangeSpecWithoutLimit.ALL;
    }

    static final class RangeSpecWithoutLimit
    extends RangeSpec {
        private static final RangeSpecWithoutLimit ALL = new RangeSpecWithoutLimit(0L);
        private final long begin;

        private RangeSpecWithoutLimit(long begin) {
            this.begin = begin;
        }

        @Override
        public long begin() {
            return this.begin;
        }

        @Override
        public OptionalLong maxLength() {
            return OptionalLong.empty();
        }

        @Override
        public @NonNull RangeSpec withMaxLength(long maxLength) {
            Preconditions.checkArgument(maxLength >= 0L, "range maxLength must be >= 0 (range limit = %s)", maxLength);
            return new RangeSpecWithMaxLength(this.begin, maxLength);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RangeSpecWithoutLimit)) {
                return false;
            }
            RangeSpecWithoutLimit that = (RangeSpecWithoutLimit)o;
            return this.begin == that.begin;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.begin);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this).add("begin", this.begin).toString();
        }
    }

    static final class RangeSpecWithMaxLength
    extends RangeSpec {
        private final long begin;
        private final long maxLength;

        private RangeSpecWithMaxLength(long begin, long maxLength) {
            this.begin = begin;
            this.maxLength = maxLength;
        }

        @Override
        public long begin() {
            return this.begin;
        }

        @Override
        public OptionalLong maxLength() {
            return OptionalLong.of(this.maxLength);
        }

        @Override
        public @NonNull RangeSpec withMaxLength(long maxLength) {
            Preconditions.checkArgument(maxLength >= 0L, "range maxLength must be >= 0 (range limit = %s)", maxLength);
            return new RangeSpecWithMaxLength(this.begin, maxLength);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RangeSpecWithMaxLength)) {
                return false;
            }
            RangeSpecWithMaxLength that = (RangeSpecWithMaxLength)o;
            return this.begin == that.begin && this.maxLength == that.maxLength;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.begin, this.maxLength);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(RangeSpec.class).add("begin", this.begin).add("maxLength", this.maxLength).toString();
        }
    }
}

