/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.core.ApiFuture;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.grpc.GrpcStatusCode;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.rpc.ApiException;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.rpc.ErrorDetails;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.rpc.StatusCode;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BlobId;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.StorageException;
import com.google.cloud.hadoop.repackaged.ossgcs.io.grpc.Status;
import java.util.List;

public final class ParallelCompositeUploadException
extends ApiException {
    private final ApiFuture<List<BlobId>> createdObjects;

    private ParallelCompositeUploadException(Throwable cause, StatusCode statusCode, ErrorDetails errorDetails, ApiFuture<List<BlobId>> createdObjects) {
        super(cause, statusCode, false, errorDetails);
        this.createdObjects = createdObjects;
    }

    public ApiFuture<List<BlobId>> getCreatedObjects() {
        return this.createdObjects;
    }

    static ParallelCompositeUploadException of(Throwable t, ApiFuture<List<BlobId>> createdObjects) {
        ErrorDetails errorDetails;
        StatusCode statusCode;
        Throwable cause = t;
        if (t instanceof StorageException && t.getCause() != null) {
            cause = t.getCause();
        }
        if (cause instanceof ApiException) {
            ApiException apiException = (ApiException)cause;
            statusCode = apiException.getStatusCode();
            errorDetails = apiException.getErrorDetails();
        } else {
            statusCode = GrpcStatusCode.of(Status.Code.UNKNOWN);
            errorDetails = ErrorDetails.builder().build();
        }
        return new ParallelCompositeUploadException(cause, statusCode, errorDetails, createdObjects);
    }
}

