/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.core.ApiFutures;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.core.SettableApiFuture;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.ApiaryUnbufferedReadableByteChannel;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BlobReadChannelV2;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BufferHandle;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BufferedReadableByteChannelSession;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.ChannelSession;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.DefaultBufferedReadableByteChannel;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.GzipReadableByteChannel;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.StorageByteChannels;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.UnbufferedReadableByteChannelSession;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.util.concurrent.MoreExecutors;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.concurrent.Immutable;

@Immutable
final class HttpDownloadSessionBuilder {
    private static final HttpDownloadSessionBuilder INSTANCE = new HttpDownloadSessionBuilder();
    private static final int DEFAULT_BUFFER_CAPACITY = 0x200000;

    private HttpDownloadSessionBuilder() {
    }

    static HttpDownloadSessionBuilder create() {
        return INSTANCE;
    }

    public ReadableByteChannelSessionBuilder byteChannel(BlobReadChannelV2.BlobReadChannelContext blobReadChannelContext) {
        return new ReadableByteChannelSessionBuilder(blobReadChannelContext);
    }

    public static final class ReadableByteChannelSessionBuilder {
        private final BlobReadChannelV2.BlobReadChannelContext blobReadChannelContext;
        private boolean autoGzipDecompression;

        private ReadableByteChannelSessionBuilder(BlobReadChannelV2.BlobReadChannelContext blobReadChannelContext) {
            this.blobReadChannelContext = blobReadChannelContext;
            this.autoGzipDecompression = false;
        }

        public ReadableByteChannelSessionBuilder setAutoGzipDecompression(boolean autoGzipDecompression) {
            this.autoGzipDecompression = autoGzipDecompression;
            return this;
        }

        public BufferedReadableByteChannelSessionBuilder buffered() {
            return this.buffered(BufferHandle.allocate(0x200000));
        }

        public BufferedReadableByteChannelSessionBuilder buffered(BufferHandle bufferHandle) {
            return new BufferedReadableByteChannelSessionBuilder(bufferHandle, this.bindFunction());
        }

        public BufferedReadableByteChannelSessionBuilder buffered(ByteBuffer buffer) {
            return this.buffered(BufferHandle.handleOf(buffer));
        }

        public UnbufferedReadableByteChannelSessionBuilder unbuffered() {
            return new UnbufferedReadableByteChannelSessionBuilder(this.bindFunction());
        }

        private BiFunction<ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest, SettableApiFuture<StorageObject>, UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel> bindFunction() {
            boolean autoGzipDecompression = this.autoGzipDecompression;
            return (request, resultFuture) -> {
                if (autoGzipDecompression) {
                    return new GzipReadableByteChannel(new ApiaryUnbufferedReadableByteChannel((ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest)request, this.blobReadChannelContext.getApiaryClient(), (SettableApiFuture<StorageObject>)resultFuture, this.blobReadChannelContext.getRetrier(), this.blobReadChannelContext.getRetryAlgorithmManager().idempotent()), ApiFutures.transform(resultFuture, StorageObject::getContentEncoding, MoreExecutors.directExecutor()));
                }
                return new ApiaryUnbufferedReadableByteChannel((ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest)request, this.blobReadChannelContext.getApiaryClient(), (SettableApiFuture<StorageObject>)resultFuture, this.blobReadChannelContext.getRetrier(), this.blobReadChannelContext.getRetryAlgorithmManager().idempotent());
            };
        }

        public static final class BufferedReadableByteChannelSessionBuilder {
            private final BiFunction<ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest, SettableApiFuture<StorageObject>, BufferedReadableByteChannelSession.BufferedReadableByteChannel> f;
            private ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest request;

            private BufferedReadableByteChannelSessionBuilder(BufferHandle buffer, BiFunction<ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest, SettableApiFuture<StorageObject>, UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel> f) {
                this.f = f.andThen(c -> new DefaultBufferedReadableByteChannel(buffer, (UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel)c));
            }

            public BufferedReadableByteChannelSessionBuilder setApiaryReadRequest(ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest request) {
                this.request = Objects.requireNonNull(request, "request must be non null");
                return this;
            }

            public BufferedReadableByteChannelSession<StorageObject> build() {
                return new ChannelSession.BufferedReadSession<ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest, StorageObject>(ApiFutures.immediateFuture(this.request), this.f.andThen(StorageByteChannels.readable()::createSynchronized));
            }
        }

        public static final class UnbufferedReadableByteChannelSessionBuilder {
            private final BiFunction<ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest, SettableApiFuture<StorageObject>, UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel> f;
            private ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest request;

            private UnbufferedReadableByteChannelSessionBuilder(BiFunction<ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest, SettableApiFuture<StorageObject>, UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel> f) {
                this.f = f;
            }

            public UnbufferedReadableByteChannelSessionBuilder setApiaryReadRequest(ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest request) {
                this.request = Objects.requireNonNull(request, "request must be non null");
                return this;
            }

            public UnbufferedReadableByteChannelSession<StorageObject> build() {
                return new ChannelSession.UnbufferedReadSession<ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest, StorageObject>(ApiFutures.immediateFuture(this.request), this.f.andThen(StorageByteChannels.readable()::createSynchronized));
            }
        }
    }
}

