/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.core.ApiFuture;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Buffers;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.StorageByteChannels;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.UnbufferedReadableByteChannelSession;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.concurrent.ExecutionException;
import java.util.zip.GZIPInputStream;

final class GzipReadableByteChannel
implements UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel {
    private final UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel source;
    private final ApiFuture<String> contentEncoding;
    private boolean retEOF = false;
    private ScatteringByteChannel delegate;
    private ByteBuffer leftovers;

    GzipReadableByteChannel(UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel source, ApiFuture<String> contentEncoding) {
        this.source = source;
        this.contentEncoding = contentEncoding;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long read;
        if (this.retEOF) {
            return -1L;
        }
        long bytesRead = 0L;
        if (this.delegate == null) {
            byte[] firstByte = new byte[1];
            ByteBuffer wrap = ByteBuffer.wrap(firstByte);
            this.source.read(wrap);
            try {
                String contentEncoding = (String)this.contentEncoding.get();
                if ("gzip".equals(contentEncoding) || "x-gzip".equals(contentEncoding)) {
                    ByteArrayInputStream firstByteAgain = new ByteArrayInputStream(firstByte);
                    InputStream sourceInputStream = Channels.newInputStream(this.source);
                    SequenceInputStream first4AndSource = new SequenceInputStream(firstByteAgain, sourceInputStream);
                    GZIPInputStream decompress = new GZIPInputStream(new OptimisticAvailabilityInputStream(first4AndSource));
                    ReadableByteChannel decompressedChannel = Channels.newChannel(decompress);
                    this.delegate = StorageByteChannels.readable().asScatteringByteChannel(decompressedChannel);
                }
                wrap.flip();
                bytesRead += Buffers.copy(wrap, dsts, offset, length);
                if (wrap.hasRemaining()) {
                    this.leftovers = wrap;
                }
                this.delegate = this.source;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException(e);
            }
        } else if (this.leftovers != null && this.leftovers.hasRemaining()) {
            bytesRead += Buffers.copy(this.leftovers, dsts, offset, length);
            if (!this.leftovers.hasRemaining()) {
                this.leftovers = null;
            }
        }
        if ((read = this.delegate.read(dsts, offset, length)) == -1L && bytesRead == 0L) {
            return -1L;
        }
        if (read == -1L) {
            this.retEOF = true;
        } else {
            bytesRead += read;
        }
        return bytesRead;
    }

    @Override
    public boolean isOpen() {
        return !this.retEOF && this.source.isOpen();
    }

    @Override
    public void close() throws IOException {
        try (UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel ignored1 = this.source;
             ScatteringByteChannel ignored2 = this.delegate;){
            this.delegate = null;
        }
        catch (Exception e) {
            throw new IOException("Error while attempting to close channel.", e);
        }
    }

    private static final class OptimisticAvailabilityInputStream
    extends FilterInputStream {
        private int lastRead = 0;

        OptimisticAvailabilityInputStream(InputStream delegate) {
            super(delegate);
        }

        @Override
        public int available() throws IOException {
            return this.lastRead > -1 ? Integer.MAX_VALUE : 0;
        }

        @Override
        public int read() throws IOException {
            this.lastRead = super.read();
            return this.lastRead;
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.lastRead = super.read(b);
            return this.lastRead;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.lastRead = super.read(b, off, len);
            return this.lastRead;
        }
    }
}

