/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.core.ApiFuture;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.RestorableState;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.WriteChannel;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BaseStorageWriteChannel;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.ByteStringStrategy;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Conversions;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.CrossTransportUtils;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Hasher;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.LazyWriteChannel;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.ResumableMedia;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.ResumableWrite;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Retrying;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.storage.v2.WriteObjectRequest;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.storage.v2.WriteObjectResponse;
import java.util.function.Supplier;

final class GrpcBlobWriteChannel
extends BaseStorageWriteChannel<WriteObjectResponse> {
    private final ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write;
    private final Retrying.RetrierWithAlg retrier;
    private final Supplier<ApiFuture<ResumableWrite>> start;
    private final Hasher hasher;

    GrpcBlobWriteChannel(ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write, Retrying.RetrierWithAlg retrier, Supplier<ApiFuture<ResumableWrite>> start, Hasher hasher) {
        super(Conversions.grpc().blobInfo().compose(WriteObjectResponse::getResource));
        this.write = write;
        this.retrier = retrier;
        this.start = start;
        this.hasher = hasher;
    }

    @Override
    public RestorableState<WriteChannel> capture() {
        return (RestorableState)CrossTransportUtils.throwHttpJsonOnly(WriteChannel.class, "capture");
    }

    @Override
    protected LazyWriteChannel<WriteObjectResponse> newLazyWriteChannel() {
        return new LazyWriteChannel<WriteObjectResponse>(() -> ResumableMedia.gapic().write().byteChannel(this.write).setHasher(this.hasher).setByteStringStrategy(ByteStringStrategy.copy()).resumable().withRetryConfig(this.retrier).buffered(this.getBufferHandle()).setStartAsync(this.start.get()).build());
    }
}

