/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.grpc.GrpcCallContext;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.RestorableState;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Blob;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BlobInfo;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Conversions;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.CopyWriter;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.CrossTransportUtils;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.GrpcStorageImpl;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Retrying;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.storage.v2.RewriteObjectRequest;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.storage.v2.RewriteResponse;

final class GapicCopyWriter
extends CopyWriter {
    private final transient GrpcStorageImpl storage;
    private final UnaryCallable<RewriteObjectRequest, RewriteResponse> callable;
    private final Retrying.RetrierWithAlg retrier;
    private final RewriteObjectRequest originalRequest;
    private final RewriteResponse initialResponse;
    private RewriteResponse mostRecentResponse;

    GapicCopyWriter(GrpcStorageImpl storage, UnaryCallable<RewriteObjectRequest, RewriteResponse> callable, Retrying.RetrierWithAlg retrier, RewriteObjectRequest originalRequest, RewriteResponse initialResponse) {
        this.storage = storage;
        this.callable = callable;
        this.retrier = retrier;
        this.initialResponse = initialResponse;
        this.mostRecentResponse = initialResponse;
        this.originalRequest = originalRequest;
    }

    @Override
    public Blob getResult() {
        while (!this.isDone()) {
            this.copyChunk();
        }
        BlobInfo info = (BlobInfo)Conversions.grpc().blobInfo().decode(this.mostRecentResponse.getResource());
        return info.asBlob(this.storage);
    }

    @Override
    public long getBlobSize() {
        return this.initialResponse.getObjectSize();
    }

    @Override
    public boolean isDone() {
        return this.mostRecentResponse.getDone();
    }

    @Override
    public long getTotalBytesCopied() {
        return this.mostRecentResponse.getTotalBytesRewritten();
    }

    @Override
    public void copyChunk() {
        if (!this.isDone()) {
            RewriteObjectRequest req = this.originalRequest.toBuilder().setRewriteToken(this.mostRecentResponse.getRewriteToken()).build();
            GrpcCallContext retryContext = Retrying.newCallContext();
            this.mostRecentResponse = (RewriteResponse)this.retrier.run(() -> this.callable.call(req, retryContext), Conversions.Decoder.identity());
        }
    }

    @Override
    public RestorableState<CopyWriter> capture() {
        return (RestorableState)CrossTransportUtils.throwHttpJsonOnly(CopyWriter.class, "capture");
    }
}

