/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.core.ApiFuture;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.core.SettableApiFuture;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BidiAppendableWrite;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BidiResumableWrite;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BidiWriteCtx;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BlobAppendableUploadImpl;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BufferHandle;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.BufferedWritableByteChannelSession;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.ByteStringStrategy;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.ChannelSession;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.ChunkSegmenter;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.DefaultBufferedWritableByteChannel;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.FlushPolicy;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.GapicBidiUnbufferedAppendableWritableByteChannel;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.GapicBidiUnbufferedWritableByteChannel;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Hasher;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Retrying;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.StorageByteChannels;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.UnbufferedWritableByteChannelSession;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.WritableByteChannelSession;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.storage.v2.BidiWriteObjectRequest;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.storage.v2.BidiWriteObjectResponse;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.storage.v2.GetObjectRequest;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.BiFunction;

final class GapicBidiWritableByteChannelSessionBuilder {
    private final BidiStreamingCallable<BidiWriteObjectRequest, BidiWriteObjectResponse> write;
    private Hasher hasher;
    private ByteStringStrategy byteStringStrategy;

    GapicBidiWritableByteChannelSessionBuilder(BidiStreamingCallable<BidiWriteObjectRequest, BidiWriteObjectResponse> write) {
        this.write = write;
        this.hasher = Hasher.noop();
        this.byteStringStrategy = ByteStringStrategy.copy();
    }

    GapicBidiWritableByteChannelSessionBuilder setHasher(Hasher hasher) {
        this.hasher = Objects.requireNonNull(hasher, "hasher must be non null");
        return this;
    }

    GapicBidiWritableByteChannelSessionBuilder setByteStringStrategy(ByteStringStrategy byteStringStrategy) {
        this.byteStringStrategy = Objects.requireNonNull(byteStringStrategy, "byteStringStrategy must be non null");
        return this;
    }

    ResumableUploadBuilder resumable() {
        return new ResumableUploadBuilder();
    }

    AppendableUploadBuilder appendable() {
        return new AppendableUploadBuilder();
    }

    final class ResumableUploadBuilder {
        private Retrying.RetrierWithAlg retrier = Retrying.RetrierWithAlg.attemptOnce();

        ResumableUploadBuilder() {
        }

        ResumableUploadBuilder withRetryConfig(Retrying.RetrierWithAlg retrier) {
            this.retrier = Objects.requireNonNull(retrier, "retrier must be non null");
            return this;
        }

        BufferedResumableUploadBuilder buffered(ByteBuffer byteBuffer) {
            return this.buffered(BufferHandle.handleOf(byteBuffer));
        }

        BufferedResumableUploadBuilder buffered(BufferHandle bufferHandle) {
            return new BufferedResumableUploadBuilder(bufferHandle);
        }

        final class BufferedResumableUploadBuilder {
            private final BufferHandle bufferHandle;
            private ApiFuture<BidiResumableWrite> start;

            BufferedResumableUploadBuilder(BufferHandle bufferHandle) {
                this.bufferHandle = bufferHandle;
            }

            BufferedResumableUploadBuilder setStartAsync(ApiFuture<BidiResumableWrite> start) {
                this.start = Objects.requireNonNull(start, "start must be non null");
                return this;
            }

            BufferedWritableByteChannelSession<BidiWriteObjectResponse> build() {
                ByteStringStrategy boundStrategy = GapicBidiWritableByteChannelSessionBuilder.this.byteStringStrategy;
                Hasher boundHasher = GapicBidiWritableByteChannelSessionBuilder.this.hasher;
                Retrying.RetrierWithAlg boundRetrier = ResumableUploadBuilder.this.retrier;
                return new ChannelSession.BufferedWriteSession(Objects.requireNonNull(this.start, "start must be non null"), ((BiFunction<BidiResumableWrite, SettableApiFuture, UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel>)(start, resultFuture) -> new GapicBidiUnbufferedWritableByteChannel(GapicBidiWritableByteChannelSessionBuilder.this.write, boundRetrier, (SettableApiFuture<BidiWriteObjectResponse>)resultFuture, new ChunkSegmenter(boundHasher, boundStrategy, 0x200000), new BidiWriteCtx<BidiResumableWrite>((BidiResumableWrite)start), Retrying::newCallContext)).andThen(c -> new DefaultBufferedWritableByteChannel(this.bufferHandle, (UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel)c)).andThen(StorageByteChannels.writable()::createSynchronized));
            }
        }
    }

    final class AppendableUploadBuilder {
        private Retrying.RetrierWithAlg retrier = Retrying.RetrierWithAlg.attemptOnce();

        AppendableUploadBuilder() {
        }

        AppendableUploadBuilder withRetryConfig(Retrying.RetrierWithAlg retrier) {
            this.retrier = Objects.requireNonNull(retrier, "retrier must be non null");
            return this;
        }

        BufferedAppendableUploadBuilder buffered(FlushPolicy flushPolicy) {
            return new BufferedAppendableUploadBuilder(flushPolicy);
        }

        final class BufferedAppendableUploadBuilder {
            private final FlushPolicy flushPolicy;
            private boolean finalizeOnClose;
            private ApiFuture<BidiAppendableWrite> start;
            private UnaryCallable<GetObjectRequest, com.google.cloud.hadoop.repackaged.ossgcs.com.google.storage.v2.Object> get;

            BufferedAppendableUploadBuilder(FlushPolicy flushPolicy) {
                this.flushPolicy = flushPolicy;
            }

            BufferedAppendableUploadBuilder setFinalizeOnClose(boolean finalizeOnClose) {
                this.finalizeOnClose = finalizeOnClose;
                return this;
            }

            BufferedAppendableUploadBuilder setStartAsync(ApiFuture<BidiAppendableWrite> start) {
                this.start = Objects.requireNonNull(start, "start must be non null");
                return this;
            }

            public BufferedAppendableUploadBuilder setGetCallable(UnaryCallable<GetObjectRequest, com.google.cloud.hadoop.repackaged.ossgcs.com.google.storage.v2.Object> get) {
                this.get = get;
                return this;
            }

            WritableByteChannelSession<BlobAppendableUploadImpl.AppendableObjectBufferedWritableByteChannel, BidiWriteObjectResponse> build() {
                ByteStringStrategy boundStrategy = GapicBidiWritableByteChannelSessionBuilder.this.byteStringStrategy;
                Hasher boundHasher = GapicBidiWritableByteChannelSessionBuilder.this.hasher;
                Retrying.RetrierWithAlg boundRetrier = AppendableUploadBuilder.this.retrier;
                UnaryCallable<GetObjectRequest, com.google.cloud.hadoop.repackaged.ossgcs.com.google.storage.v2.Object> boundGet = Objects.requireNonNull(this.get, "get must be non null");
                boolean boundFinalizeOnClose = this.finalizeOnClose;
                return new AppendableSession(Objects.requireNonNull(this.start, "start must be non null"), ((BiFunction<BidiAppendableWrite, SettableApiFuture, GapicBidiUnbufferedAppendableWritableByteChannel>)(start, resultFuture) -> new GapicBidiUnbufferedAppendableWritableByteChannel(GapicBidiWritableByteChannelSessionBuilder.this.write, boundGet, boundRetrier, (SettableApiFuture<BidiWriteObjectResponse>)resultFuture, new ChunkSegmenter(boundHasher, boundStrategy, 0x200000), new BidiWriteCtx<BidiAppendableWrite>((BidiAppendableWrite)start), Retrying::newCallContext)).andThen(c -> {
                    boolean takeOver = c.getWriteCtx().getRequestFactory().getReq().hasAppendObjectSpec();
                    if (takeOver) {
                        c.startAppendableTakeoverStream();
                    }
                    return new BlobAppendableUploadImpl.AppendableObjectBufferedWritableByteChannel(this.flushPolicy.createBufferedChannel((UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel)c), (GapicBidiUnbufferedAppendableWritableByteChannel)c, boundFinalizeOnClose);
                }));
            }
        }
    }

    private static final class AppendableSession
    extends ChannelSession<BidiAppendableWrite, BidiWriteObjectResponse, BlobAppendableUploadImpl.AppendableObjectBufferedWritableByteChannel>
    implements WritableByteChannelSession<BlobAppendableUploadImpl.AppendableObjectBufferedWritableByteChannel, BidiWriteObjectResponse> {
        private AppendableSession(ApiFuture<BidiAppendableWrite> startFuture, BiFunction<BidiAppendableWrite, SettableApiFuture<BidiWriteObjectResponse>, BlobAppendableUploadImpl.AppendableObjectBufferedWritableByteChannel> f) {
            super(startFuture, f);
        }
    }
}

