/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Backoff;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Durations;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.RetryContext;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Retrying;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.checkerframework.checker.nullness.qual.Nullable;

final class DefaultRetryContext
implements RetryContext {
    private final ScheduledExecutorService scheduledExecutorService;
    private final Retrying.RetryingDependencies retryingDependencies;
    private final ResultRetryAlgorithm<?> algorithm;
    private final Backoff backoff;
    private final ReentrantLock lock;
    private List<Throwable> failures;
    private long lastReset;
    private long lastRecordedErrorNs;
    private @Nullable Backoff.BackoffResult lastBackoffResult;
    private @Nullable ScheduledFuture<?> pendingBackoff;

    DefaultRetryContext(ScheduledExecutorService scheduledExecutorService, Retrying.RetryingDependencies retryingDependencies, ResultRetryAlgorithm<?> algorithm, Backoff.Jitterer jitterer) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.retryingDependencies = retryingDependencies;
        this.algorithm = algorithm;
        this.backoff = Backoff.from(retryingDependencies.getRetrySettings()).setJitterer(jitterer).build();
        this.lock = new ReentrantLock();
        this.failures = new LinkedList<Throwable>();
        this.lastRecordedErrorNs = this.lastReset = retryingDependencies.getClock().nanoTime();
        this.lastBackoffResult = null;
        this.pendingBackoff = null;
    }

    @Override
    public boolean inBackoff() {
        this.lock.lock();
        boolean b = this.pendingBackoff != null;
        try {
            boolean bl = b;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void reset() {
        this.lock.lock();
        try {
            long now;
            if (this.failures.size() > 0) {
                this.failures = new LinkedList<Throwable>();
            }
            this.lastReset = now = this.retryingDependencies.getClock().nanoTime();
            this.lastRecordedErrorNs = now;
            this.clearPendingBackoff();
            this.backoff.reset();
        }
        finally {
            this.lock.unlock();
        }
    }

    @VisibleForTesting
    void awaitBackoffComplete() {
        while (this.inBackoff()) {
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Throwable> void recordError(T t, RetryContext.OnSuccess onSuccess, RetryContext.OnFailure<T> onFailure) {
        this.lock.lock();
        try {
            long now = this.retryingDependencies.getClock().nanoTime();
            Duration elapsed = Duration.ofNanos(now - this.lastReset);
            Duration elapsedSinceLastRecordError = Duration.ofNanos(now - this.lastRecordedErrorNs);
            if (this.pendingBackoff != null && this.pendingBackoff.isDone()) {
                this.pendingBackoff = null;
                this.lastBackoffResult = null;
            } else if (this.pendingBackoff != null) {
                this.pendingBackoff.cancel(true);
                String message = String.format("Previous backoff interrupted by this error (previousBackoff: %s, elapsed: %s)", this.lastBackoffResult != null ? this.lastBackoffResult.errorString() : null, elapsed);
                t.addSuppressed(RetryContext.BackoffComment.of(message));
            }
            int failureCount = this.failures.size() + 1;
            int maxAttempts = this.retryingDependencies.getRetrySettings().getMaxAttempts();
            if (maxAttempts <= 0) {
                maxAttempts = Integer.MAX_VALUE;
            }
            boolean shouldRetry = this.algorithm.shouldRetry(t, null);
            Backoff.BackoffResult nextBackoff = this.backoff.nextBackoff(elapsedSinceLastRecordError);
            String msgPrefix = null;
            if (shouldRetry && failureCount >= maxAttempts) {
                msgPrefix = "Operation failed to complete within attempt budget";
            } else if (nextBackoff == Backoff.BackoffResults.EXHAUSTED) {
                msgPrefix = "Operation failed to complete within backoff budget";
            } else if (!shouldRetry) {
                msgPrefix = "Unretryable error";
            }
            this.lastRecordedErrorNs = now;
            if (msgPrefix == null) {
                t.addSuppressed(RetryContext.BackoffComment.fromResult(nextBackoff));
                this.failures.add(t);
                Backoff.BackoffDuration backoffDuration = (Backoff.BackoffDuration)nextBackoff;
                this.lastBackoffResult = nextBackoff;
                this.pendingBackoff = this.scheduledExecutorService.schedule(() -> {
                    try {
                        onSuccess.onSuccess();
                    }
                    finally {
                        this.clearPendingBackoff();
                    }
                }, backoffDuration.getDuration().toNanos(), TimeUnit.NANOSECONDS);
            } else {
                String msg = String.format(Locale.US, "%s (attempts: %d%s, elapsed: %s, nextBackoff: %s%s)%s", msgPrefix, failureCount, maxAttempts == Integer.MAX_VALUE ? "" : String.format(", maxAttempts: %d", maxAttempts), elapsed, nextBackoff.errorString(), Durations.eq(this.backoff.getTimeout(), Durations.EFFECTIVE_INFINITY) ? "" : ", timeout: " + this.backoff.getTimeout(), this.failures.isEmpty() ? "" : " previous failures follow in order of occurrence");
                t.addSuppressed(new RetryContext.RetryBudgetExhaustedComment(msg));
                for (Throwable failure : this.failures) {
                    t.addSuppressed(failure);
                }
                onFailure.onFailure(t);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void clearPendingBackoff() {
        this.lock.lock();
        try {
            if (this.pendingBackoff != null) {
                if (!this.pendingBackoff.isDone()) {
                    this.pendingBackoff.cancel(true);
                }
                this.pendingBackoff = null;
            }
            if (this.lastBackoffResult != null) {
                this.lastBackoffResult = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

