/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.Storage;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.cloud.storage.TransportCompatibility;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;

final class CrossTransportUtils {
    CrossTransportUtils() {
    }

    static <T> T throwHttpJsonOnly(String methodName) {
        return CrossTransportUtils.throwHttpJsonOnly(Storage.class, methodName);
    }

    static <T> T throwHttpJsonOnly(Class<?> clazz, String methodName) {
        return CrossTransportUtils.throwTransportOnly(clazz, methodName, TransportCompatibility.Transport.HTTP);
    }

    static <T> T throwGrpcOnly(String methodName) {
        return CrossTransportUtils.throwGrpcOnly(Storage.class, methodName);
    }

    static <T> T throwGrpcOnly(Class<?> clazz, String methodName) {
        return CrossTransportUtils.throwTransportOnly(clazz, methodName, TransportCompatibility.Transport.GRPC);
    }

    static <T> T throwTransportOnly(Class<?> clazz, String methodName, TransportCompatibility.Transport transport) {
        String builder;
        switch (transport) {
            case HTTP: {
                builder = "StorageOptions.http()";
                break;
            }
            case GRPC: {
                builder = "StorageOptions.grpc()";
                break;
            }
            default: {
                throw new IllegalStateException(String.format(Locale.US, "Broken Java Enum: %s received value: '%s'", new Object[]{TransportCompatibility.Transport.class, transport}));
            }
        }
        String message = String.format(Locale.US, "%s#%s is only supported for %s transport. Please use %s to construct a compatible instance.", new Object[]{clazz.getName(), methodName, transport, builder});
        throw new UnsupportedOperationException(message);
    }

    static String fmtMethodName(String name, Class<?> ... args) {
        return name + "(" + Arrays.stream(args).map(Class::getName).collect(Collectors.joining(", ")) + ")";
    }
}

