/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.com.google.auth.oauth2;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.client.http.HttpRequest;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.client.http.HttpResponse;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.client.http.UrlEncodedContent;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.client.http.json.JsonHttpContent;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.client.util.GenericData;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.auth.oauth2.LoggerProvider;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.auth.oauth2.Slf4jUtils;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.gson.Gson;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.slf4j.Logger;

class Slf4jLoggingHelpers {
    private static final Gson gson = new Gson();
    private static final Set<String> SENSITIVE_KEYS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);

    static void logRequest(HttpRequest request, LoggerProvider loggerProvider, String message) {
        try {
            Logger logger = loggerProvider.getLogger();
            if (logger.isInfoEnabled()) {
                HashMap<String, Object> loggingDataMap = new HashMap<String, Object>();
                loggingDataMap.put("request.method", request.getRequestMethod());
                loggingDataMap.put("request.url", request.getUrl().toString());
                HashMap headers = new HashMap();
                request.getHeaders().forEach((key, val) -> {
                    if (SENSITIVE_KEYS.contains(key)) {
                        String hashedVal = Slf4jLoggingHelpers.calculateSHA256Hash(String.valueOf(val));
                        headers.put(key, hashedVal);
                    } else {
                        headers.put(key, val);
                    }
                });
                loggingDataMap.put("request.headers", gson.toJson(headers));
                if (request.getContent() != null && logger.isDebugEnabled()) {
                    if (request.getContent() instanceof UrlEncodedContent) {
                        GenericData data = (GenericData)((UrlEncodedContent)request.getContent()).getData();
                        Map<String, Object> contextMap = Slf4jLoggingHelpers.parseGenericData(data);
                        loggingDataMap.put("request.payload", gson.toJson(contextMap));
                    } else if (request.getContent() instanceof JsonHttpContent) {
                        String jsonData = gson.toJson(((JsonHttpContent)request.getContent()).getData());
                        loggingDataMap.put("request.payload", jsonData);
                    }
                    Slf4jUtils.log(logger, org.slf4j.event.Level.DEBUG, loggingDataMap, message);
                } else {
                    Slf4jUtils.log(logger, org.slf4j.event.Level.INFO, loggingDataMap, message);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void logResponse(HttpResponse response, LoggerProvider loggerProvider, String message) {
        try {
            Logger logger = loggerProvider.getLogger();
            if (logger.isInfoEnabled()) {
                HashMap<String, Object> responseLogDataMap = new HashMap<String, Object>();
                responseLogDataMap.put("response.status", String.valueOf(response.getStatusCode()));
                responseLogDataMap.put("response.status.message", response.getStatusMessage());
                HashMap<String, Object> headers = new HashMap<String, Object>(response.getHeaders());
                responseLogDataMap.put("response.headers", ((Object)headers).toString());
                Slf4jUtils.log(logger, org.slf4j.event.Level.INFO, responseLogDataMap, message);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void logResponsePayload(GenericData genericData, LoggerProvider loggerProvider, String message) {
        try {
            Logger logger = loggerProvider.getLogger();
            if (logger.isDebugEnabled()) {
                Map<String, Object> contextMap = Slf4jLoggingHelpers.parseGenericData(genericData);
                Slf4jUtils.log(logger, org.slf4j.event.Level.DEBUG, contextMap, message);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void log(LoggerProvider loggerProvider, Level level, Map<String, Object> contextMap, String message) {
        try {
            Logger logger = loggerProvider.getLogger();
            org.slf4j.event.Level slf4jLevel = Slf4jLoggingHelpers.matchUtilLevelToSLF4JLevel(level);
            Slf4jUtils.log(logger, slf4jLevel, contextMap, message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static org.slf4j.event.Level matchUtilLevelToSLF4JLevel(Level level) {
        if (level == Level.SEVERE) {
            return org.slf4j.event.Level.ERROR;
        }
        if (level == Level.WARNING) {
            return org.slf4j.event.Level.WARN;
        }
        if (level == Level.INFO) {
            return org.slf4j.event.Level.INFO;
        }
        if (level == Level.FINE) {
            return org.slf4j.event.Level.DEBUG;
        }
        return org.slf4j.event.Level.TRACE;
    }

    private static Map<String, Object> parseGenericData(GenericData genericData) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        genericData.forEach((key, val) -> {
            if (SENSITIVE_KEYS.contains(key)) {
                String secretString = String.valueOf(val);
                String hashedVal = Slf4jLoggingHelpers.calculateSHA256Hash(secretString);
                contextMap.put((String)key, hashedVal);
            } else {
                contextMap.put((String)key, val.toString());
            }
        });
        return contextMap;
    }

    private static String calculateSHA256Hash(String data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] inputBytes = data.getBytes(StandardCharsets.UTF_8);
            byte[] hashBytes = digest.digest(inputBytes);
            return Slf4jLoggingHelpers.bytesToHex(hashBytes);
        }
        catch (NoSuchAlgorithmException e) {
            return "Error calculating SHA-256 hash.";
        }
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    private Slf4jLoggingHelpers() {
    }

    static {
        SENSITIVE_KEYS.addAll(Arrays.asList("token", "assertion", "access_token", "client_secret", "refresh_token", "signedBlob", "authorization"));
    }
}

