/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.com.google.auth.oauth2;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.auth.oauth2.ExternalAccountCredentials;
import java.math.BigDecimal;
import java.util.Map;
import javax.annotation.Nullable;

public class PluggableAuthCredentialSource
extends ExternalAccountCredentials.CredentialSource {
    static final int DEFAULT_EXECUTABLE_TIMEOUT_MS = 30000;
    static final int MINIMUM_EXECUTABLE_TIMEOUT_MS = 5000;
    static final int MAXIMUM_EXECUTABLE_TIMEOUT_MS = 120000;
    static final String COMMAND_KEY = "command";
    static final String TIMEOUT_MILLIS_KEY = "timeout_millis";
    static final String OUTPUT_FILE_KEY = "output_file";
    final String executableCommand;
    final int executableTimeoutMs;
    @Nullable
    final String outputFilePath;

    public PluggableAuthCredentialSource(Map<String, Object> credentialSourceMap) {
        super(credentialSourceMap);
        Object timeout;
        if (!credentialSourceMap.containsKey("executable")) {
            throw new IllegalArgumentException("Invalid credential source for PluggableAuth credentials.");
        }
        Map executable = (Map)credentialSourceMap.get("executable");
        if (!executable.containsKey(COMMAND_KEY)) {
            throw new IllegalArgumentException("The PluggableAuthCredentialSource is missing the required 'command' field.");
        }
        this.executableTimeoutMs = executable.containsKey(TIMEOUT_MILLIS_KEY) ? ((timeout = executable.get(TIMEOUT_MILLIS_KEY)) instanceof BigDecimal ? ((BigDecimal)timeout).intValue() : (executable.get(TIMEOUT_MILLIS_KEY) instanceof Integer ? (Integer)timeout : Integer.parseInt((String)timeout))) : 30000;
        if (this.executableTimeoutMs < 5000 || this.executableTimeoutMs > 120000) {
            throw new IllegalArgumentException(String.format("The executable timeout must be between %s and %s milliseconds.", 5000, 120000));
        }
        this.executableCommand = (String)executable.get(COMMAND_KEY);
        this.outputFilePath = (String)executable.get(OUTPUT_FILE_KEY);
    }

    String getCommand() {
        return this.executableCommand;
    }

    int getTimeoutMs() {
        return this.executableTimeoutMs;
    }

    @Nullable
    String getOutputFilePath() {
        return this.outputFilePath;
    }
}

