/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.rpc;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.core.ApiFunction;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.core.ApiFuture;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.longrunning.OperationFutureImpl;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.longrunning.OperationSnapshot;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.retrying.RetryingExecutorWithContext;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.retrying.RetryingFuture;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.rpc.ApiCallContext;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.rpc.LongRunningClient;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.rpc.OperationCallSettings;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.rpc.OperationCallable;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.rpc.OperationCheckingCallable;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.rpc.RecheckingCallable;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.base.Preconditions;

class OperationCallableImpl<RequestT, ResponseT, MetadataT>
extends OperationCallable<RequestT, ResponseT, MetadataT> {
    private final UnaryCallable<RequestT, OperationSnapshot> initialCallable;
    private final RetryingExecutorWithContext<OperationSnapshot> executor;
    private final LongRunningClient longRunningClient;
    private final ApiFunction<OperationSnapshot, ResponseT> responseTransformer;
    private final ApiFunction<OperationSnapshot, MetadataT> metadataTransformer;

    OperationCallableImpl(UnaryCallable<RequestT, OperationSnapshot> initialCallable, RetryingExecutorWithContext<OperationSnapshot> executor, LongRunningClient longRunningClient, OperationCallSettings<RequestT, ResponseT, MetadataT> operationCallSettings) {
        this.initialCallable = Preconditions.checkNotNull(initialCallable);
        this.executor = Preconditions.checkNotNull(executor);
        this.longRunningClient = Preconditions.checkNotNull(longRunningClient);
        this.responseTransformer = operationCallSettings.getResponseTransformer();
        this.metadataTransformer = operationCallSettings.getMetadataTransformer();
    }

    @Override
    public OperationFuture<ResponseT, MetadataT> futureCall(RequestT request, ApiCallContext callContext) {
        ApiFuture<OperationSnapshot> initialFuture = this.initialCallable.futureCall(request, callContext);
        return this.futureCall(initialFuture, callContext);
    }

    @Override
    OperationFutureImpl<ResponseT, MetadataT> futureCall(ApiFuture<OperationSnapshot> initialFuture, ApiCallContext callContext) {
        RecheckingCallable callable = new RecheckingCallable(new OperationCheckingCallable(this.longRunningClient, initialFuture), this.executor);
        ApiFuture pollingFuture = callable.futureCall((Object)null, callContext);
        return new OperationFutureImpl<ResponseT, MetadataT>((RetryingFuture<OperationSnapshot>)pollingFuture, initialFuture, this.responseTransformer, this.metadataTransformer);
    }

    @Override
    public OperationFuture<ResponseT, MetadataT> resumeFutureCall(String operationName, ApiCallContext callContext) {
        ApiFuture<OperationSnapshot> firstAttempt = this.longRunningClient.getOperationCallable().futureCall(operationName, callContext);
        return this.futureCall(firstAttempt, callContext);
    }

    @Override
    public ApiFuture<Void> cancel(String operationName, ApiCallContext callContext) {
        return this.longRunningClient.cancelOperationCallable().futureCall(operationName, callContext);
    }
}

