/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.logging;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.core.InternalApi;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.logging.LogData;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.logging.LoggerProvider;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.logging.Slf4jLoggingHelpers;
import java.util.Map;

@InternalApi
public class LoggingUtils {
    private static boolean loggingEnabled = LoggingUtils.isLoggingEnabled();
    static final String GOOGLE_SDK_JAVA_LOGGING = "GOOGLE_SDK_JAVA_LOGGING";

    static boolean isLoggingEnabled() {
        String enableLogging = System.getenv(GOOGLE_SDK_JAVA_LOGGING);
        return "true".equalsIgnoreCase(enableLogging);
    }

    public static void recordServiceRpcAndRequestHeaders(String serviceName, String rpcName, String endpoint, Map<String, String> requestHeaders, LogData.Builder logDataBuilder, LoggerProvider loggerProvider) {
        if (loggingEnabled) {
            Slf4jLoggingHelpers.recordServiceRpcAndRequestHeaders(serviceName, rpcName, endpoint, requestHeaders, logDataBuilder, loggerProvider);
        }
    }

    public static void recordResponseHeaders(Map<String, String> headers, LogData.Builder logDataBuilder, LoggerProvider loggerProvider) {
        if (loggingEnabled) {
            Slf4jLoggingHelpers.recordResponseHeaders(headers, logDataBuilder, loggerProvider);
        }
    }

    public static <RespT> void recordResponsePayload(RespT message, LogData.Builder logDataBuilder, LoggerProvider loggerProvider) {
        if (loggingEnabled) {
            Slf4jLoggingHelpers.recordResponsePayload(message, logDataBuilder, loggerProvider);
        }
    }

    public static void logResponse(String status, LogData.Builder logDataBuilder, LoggerProvider loggerProvider) {
        if (loggingEnabled) {
            Slf4jLoggingHelpers.logResponse(status, logDataBuilder, loggerProvider);
        }
    }

    public static <RespT> void logRequest(RespT message, LogData.Builder logDataBuilder, LoggerProvider loggerProvider) {
        if (loggingEnabled) {
            Slf4jLoggingHelpers.logRequest(message, logDataBuilder, loggerProvider);
        }
    }

    public static void executeWithTryCatch(ThrowingRunnable action) {
        try {
            action.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @FunctionalInterface
    public static interface ThrowingRunnable {
        public void run() throws Throwable;
    }
}

