/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.batching;

import com.google.cloud.hadoop.repackaged.ossgcs.com.google.api.gax.batching.Semaphore64;
import com.google.cloud.hadoop.repackaged.ossgcs.com.google.common.base.Preconditions;

class BlockingSemaphore
implements Semaphore64 {
    private long availablePermits;
    private long limit;

    private static void checkNotNegative(long l) {
        Preconditions.checkArgument(l >= 0L, "negative permits not allowed: %s", l);
    }

    BlockingSemaphore(long permits) {
        BlockingSemaphore.checkNotNegative(permits);
        this.availablePermits = permits;
        this.limit = permits;
    }

    @Override
    public synchronized void release(long permits) {
        BlockingSemaphore.checkNotNegative(permits);
        this.availablePermits = Math.min(this.availablePermits + permits, this.limit);
        this.notifyAll();
    }

    @Override
    public synchronized boolean acquire(long permits) {
        BlockingSemaphore.checkNotNegative(permits);
        boolean interrupted = false;
        while (this.availablePermits < permits) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        this.availablePermits -= permits;
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return true;
    }

    @Override
    public synchronized boolean acquirePartial(long permits) {
        BlockingSemaphore.checkNotNegative(permits);
        boolean interrupted = false;
        while (this.availablePermits < Math.min(this.limit, permits)) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        this.availablePermits -= permits;
        return true;
    }

    @Override
    public synchronized void increasePermitLimit(long permits) {
        BlockingSemaphore.checkNotNegative(permits);
        this.availablePermits += permits;
        this.limit += permits;
        this.notifyAll();
    }

    @Override
    public synchronized void reducePermitLimit(long reduction) {
        BlockingSemaphore.checkNotNegative(reduction);
        Preconditions.checkState(this.limit - reduction > 0L, "permit limit underflow");
        this.availablePermits -= reduction;
        this.limit -= reduction;
    }

    @Override
    public synchronized long getPermitLimit() {
        return this.limit;
    }
}

