/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.fedbalance.procedure;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.tools.fedbalance.procedure.BalanceJob;
import org.apache.hadoop.tools.fedbalance.procedure.BalanceJournal;
import org.apache.hadoop.util.SequentialNumber;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalanceJournalInfoHDFS
implements BalanceJournal {
    public static final Logger LOG = LoggerFactory.getLogger(BalanceJournalInfoHDFS.class);
    private URI workUri;
    private Configuration conf;
    private IdGenerator generator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveJob(BalanceJob job) throws IOException {
        Path jobFile = this.getNewStateJobPath(job);
        Path tmpJobFile = new Path(jobFile + ".tmp");
        FSDataOutputStream out = null;
        try {
            FileSystem fs = FileSystem.get((URI)this.workUri, (Configuration)this.conf);
            out = fs.create(tmpJobFile);
            job.write(new DataOutputStream((OutputStream)out));
            out.close();
            out = null;
            fs.rename(tmpJobFile, jobFile);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(out);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)out);
        LOG.debug("Save journal of job={}", (Object)job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverJob(BalanceJob job) throws IOException {
        try (FSDataInputStream in = null;){
            Path logPath = this.getLatestStateJobPath(job);
            FileSystem fs = FileSystem.get((URI)this.workUri, (Configuration)this.conf);
            in = fs.open(logPath);
            job.readFields((DataInput)in);
            LOG.debug("Recover job={} from journal.", (Object)job);
        }
    }

    @Override
    public BalanceJob[] listAllJobs() throws IOException {
        FileStatus[] statuses;
        FileSystem fs = FileSystem.get((URI)this.workUri, (Configuration)this.conf);
        Path workPath = new Path(this.workUri.getPath());
        try {
            statuses = fs.listStatus(workPath);
        }
        catch (FileNotFoundException e) {
            LOG.debug("Create work path {}", (Object)workPath);
            fs.mkdirs(workPath);
            return new BalanceJob[0];
        }
        BalanceJob[] jobs = new BalanceJob[statuses.length];
        StringBuilder builder = new StringBuilder();
        builder.append("List all jobs from journal [");
        for (int i = 0; i < statuses.length; ++i) {
            if (!statuses[i].isDirectory()) continue;
            jobs[i] = new BalanceJob.Builder().build();
            jobs[i].setId(statuses[i].getPath().getName());
            builder.append(jobs[i]);
            if (i >= statuses.length - 1) continue;
            builder.append(", ");
        }
        builder.append("]");
        LOG.debug(builder.toString());
        return jobs;
    }

    @Override
    public void clear(BalanceJob job) throws IOException {
        Path jobBase = this.getJobBaseDir(job);
        FileSystem fs = FileSystem.get((URI)this.workUri, (Configuration)this.conf);
        if (fs.exists(jobBase)) {
            fs.delete(jobBase, true);
        }
        LOG.debug("Clear journal of job=" + job);
    }

    public void setConf(Configuration conf) {
        try {
            this.workUri = new URI(conf.get("hdfs.fedbalance.procedure.scheduler.journal.uri"));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("URI resolution failed.", e);
        }
        this.conf = conf;
        this.generator = new IdGenerator(Time.monotonicNow());
    }

    public Configuration getConf() {
        return this.conf;
    }

    private Path getJobBaseDir(BalanceJob job) {
        String jobId = job.getId();
        return new Path(this.workUri.getPath(), jobId);
    }

    private Path getNewStateJobPath(BalanceJob job) {
        Path basePath = this.getJobBaseDir(job);
        Path logPath = new Path(basePath, "JOB-" + this.generator.nextValue());
        return logPath;
    }

    private Path getLatestStateJobPath(BalanceJob job) throws IOException {
        Path latestFile = null;
        Path basePath = this.getJobBaseDir(job);
        FileSystem fs = FileSystem.get((URI)this.workUri, (Configuration)this.conf);
        RemoteIterator iterator = fs.listFiles(basePath, false);
        while (iterator.hasNext()) {
            FileStatus status = (FileStatus)iterator.next();
            String fileName = status.getPath().getName();
            if (!fileName.startsWith("JOB-") || fileName.contains(".tmp")) continue;
            if (latestFile == null) {
                latestFile = status.getPath();
                continue;
            }
            if (latestFile.getName().compareTo(fileName) > 0) continue;
            latestFile = status.getPath();
        }
        return latestFile;
    }

    public static class IdGenerator
    extends SequentialNumber {
        protected IdGenerator(long initialValue) {
            super(initialValue);
        }
    }
}

