/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.fedbalance;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.tools.fedbalance.FedBalanceConfigs;
import org.apache.hadoop.tools.fedbalance.FedBalanceContext;
import org.apache.hadoop.tools.fedbalance.TrashProcedure;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestTrashProcedure {
    private static Configuration conf;
    private static MiniDFSCluster cluster;
    private static String nnUri;

    @BeforeAll
    public static void beforeClass() throws IOException {
        conf = new Configuration();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        cluster.waitActive();
        nnUri = FileSystem.getDefaultUri((Configuration)conf).toString();
    }

    @AfterAll
    public static void afterClass() {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    public void testTrashProcedure() throws Exception {
        Path src = new Path("/" + GenericTestUtils.getMethodName() + "-src");
        Path dst = new Path("/" + GenericTestUtils.getMethodName() + "-dst");
        DistributedFileSystem fs = cluster.getFileSystem();
        fs.mkdirs(src);
        fs.mkdirs(new Path(src, "dir"));
        Assertions.assertTrue((boolean)fs.exists(src));
        FedBalanceContext context = new FedBalanceContext.Builder(src, dst, "mock_mount_point", conf).setMapNum(10).setBandwidthLimit(1).setTrash(FedBalanceConfigs.TrashOption.TRASH).build();
        TrashProcedure trashProcedure = new TrashProcedure("trash-procedure", null, 1000L, context);
        trashProcedure.moveToTrash();
        Assertions.assertFalse((boolean)fs.exists(src));
    }

    @Test
    public void testSeDeserialize() throws Exception {
        Path src = new Path("/" + GenericTestUtils.getMethodName() + "-src");
        Path dst = new Path("/" + GenericTestUtils.getMethodName() + "-dst");
        FedBalanceContext context = new FedBalanceContext.Builder(src, dst, "mock_mount_point", conf).setMapNum(10).setBandwidthLimit(1).setTrash(FedBalanceConfigs.TrashOption.TRASH).build();
        TrashProcedure trashProcedure = new TrashProcedure("trash-procedure", null, 1000L, context);
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bao);
        trashProcedure.write((DataOutput)dataOut);
        trashProcedure = new TrashProcedure();
        trashProcedure.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bao.toByteArray())));
        Assertions.assertEquals((Object)context, (Object)trashProcedure.getContext());
    }
}

