/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.fedbalance.procedure;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.tools.fedbalance.procedure.BalanceProcedure;
import org.apache.hadoop.util.Time;

public class WaitProcedure
extends BalanceProcedure {
    private long waitTime;
    private boolean executed = false;

    public WaitProcedure() {
    }

    public WaitProcedure(String name, long delay, long waitTime) {
        super(name, delay);
        this.waitTime = waitTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws IOException {
        long startTime = Time.monotonicNow();
        long timeLeft = this.waitTime;
        while (timeLeft > 0L) {
            try {
                Thread.sleep(timeLeft);
            }
            catch (InterruptedException e) {
                if (!this.isSchedulerShutdown()) continue;
                boolean bl = false;
                return bl;
            }
            finally {
                timeLeft = this.waitTime - (Time.monotonicNow() - startTime);
            }
        }
        this.executed = true;
        return true;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeLong(this.waitTime);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.waitTime = in.readLong();
    }

    public boolean getExecuted() {
        return this.executed;
    }
}

