/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.dynamometer.workloadgenerator.audit;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuditReplayCommand
implements Delayed {
    private static final Logger LOG = LoggerFactory.getLogger(AuditReplayCommand.class);
    private static final Pattern SIMPLE_UGI_PATTERN = Pattern.compile("([^/@ ]*).*?");
    private Long sequence;
    private long absoluteTimestamp;
    private String ugi;
    private String command;
    private String src;
    private String dest;
    private String sourceIP;

    AuditReplayCommand(Long sequence, long absoluteTimestamp, String ugi, String command, String src, String dest, String sourceIP) {
        this.sequence = sequence;
        this.absoluteTimestamp = absoluteTimestamp;
        this.ugi = ugi;
        this.command = command;
        this.src = src;
        this.dest = dest;
        this.sourceIP = sourceIP;
    }

    Long getSequence() {
        return this.sequence;
    }

    long getAbsoluteTimestamp() {
        return this.absoluteTimestamp;
    }

    String getSimpleUgi() {
        Matcher m = SIMPLE_UGI_PATTERN.matcher(this.ugi);
        if (m.matches()) {
            return m.group(1);
        }
        LOG.error("Error parsing simple UGI <{}>; falling back to current user", (Object)this.ugi);
        try {
            return UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (IOException ioe) {
            return "";
        }
    }

    String getCommand() {
        return this.command;
    }

    String getSrc() {
        return this.src;
    }

    String getDest() {
        return this.dest;
    }

    String getSourceIP() {
        return this.sourceIP;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.absoluteTimestamp - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        int result = Long.compare(this.absoluteTimestamp, ((AuditReplayCommand)o).absoluteTimestamp);
        if (result != 0) {
            return result;
        }
        return Long.compare(this.sequence, ((AuditReplayCommand)o).sequence);
    }

    boolean isPoison() {
        return false;
    }

    static AuditReplayCommand getPoisonPill(long relativeTimestamp) {
        return new PoisonPillCommand(relativeTimestamp);
    }

    public boolean equals(Object other) {
        if (!(other instanceof AuditReplayCommand)) {
            return false;
        }
        AuditReplayCommand o = (AuditReplayCommand)other;
        return this.sequence.equals(o.sequence) && this.absoluteTimestamp == o.absoluteTimestamp && this.ugi.equals(o.ugi) && this.command.equals(o.command) && this.src.equals(o.src) && this.dest.equals(o.dest) && this.sourceIP.equals(o.sourceIP);
    }

    public int hashCode() {
        return Objects.hash(this.absoluteTimestamp, this.ugi, this.command, this.src, this.dest, this.sourceIP);
    }

    public String toString() {
        return String.format("AuditReplayCommand(sequence=%d, absoluteTimestamp=%d, ugi=%s, command=%s, src=%s, dest=%s, sourceIP=%s", this.sequence, this.absoluteTimestamp, this.ugi, this.command, this.src, this.dest, this.sourceIP);
    }

    private static final class PoisonPillCommand
    extends AuditReplayCommand {
        private static final Long DEFAULT_SEQUENCE = -1L;

        private PoisonPillCommand(long absoluteTimestamp) {
            super(DEFAULT_SEQUENCE, absoluteTimestamp, null, null, null, null, null);
        }

        @Override
        boolean isPoison() {
            return true;
        }
    }
}

