/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.dynamometer.workloadgenerator.audit;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.thirdparty.com.google.common.base.Splitter;
import org.apache.hadoop.tools.dynamometer.workloadgenerator.audit.AuditCommandParser;
import org.apache.hadoop.tools.dynamometer.workloadgenerator.audit.AuditReplayCommand;

public class AuditLogDirectParser
implements AuditCommandParser {
    public static final String AUDIT_START_TIMESTAMP_KEY = "auditreplay.log-start-time.ms";
    public static final String AUDIT_LOG_DATE_FORMAT_KEY = "auditreplay.log-date.format";
    public static final String AUDIT_LOG_DATE_FORMAT_DEFAULT = "yyyy-MM-dd HH:mm:ss,SSS";
    public static final String AUDIT_LOG_DATE_TIME_ZONE_KEY = "auditreplay.log-date.time-zone";
    public static final String AUDIT_LOG_DATE_TIME_ZONE_DEFAULT = "UTC";
    public static final String AUDIT_LOG_PARSE_REGEX_KEY = "auditreplay.log-parse-regex";
    public static final String AUDIT_LOG_PARSE_REGEX_DEFAULT = "^(?<timestamp>.+?) INFO [^:]+: (?<message>.+)$";
    private static final Splitter SPACE_SPLITTER = Splitter.on((String)" ").trimResults().omitEmptyStrings();
    private long startTimestamp;
    private DateFormat dateFormat;
    private Pattern logLineParseRegex;

    @Override
    public void initialize(Configuration conf) throws IOException {
        this.startTimestamp = conf.getLong(AUDIT_START_TIMESTAMP_KEY, -1L);
        if (this.startTimestamp < 0L) {
            throw new IOException("Invalid or missing audit start timestamp: " + this.startTimestamp);
        }
        this.dateFormat = new SimpleDateFormat(conf.get(AUDIT_LOG_DATE_FORMAT_KEY, AUDIT_LOG_DATE_FORMAT_DEFAULT));
        String timeZoneString = conf.get(AUDIT_LOG_DATE_TIME_ZONE_KEY, AUDIT_LOG_DATE_TIME_ZONE_DEFAULT);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone(timeZoneString));
        String logLineParseRegexString = conf.get(AUDIT_LOG_PARSE_REGEX_KEY, AUDIT_LOG_PARSE_REGEX_DEFAULT);
        if (!logLineParseRegexString.contains("(?<timestamp>") && logLineParseRegexString.contains("(?<message>")) {
            throw new IllegalArgumentException("Must configure regex with named capture groups 'timestamp' and 'message'");
        }
        this.logLineParseRegex = Pattern.compile(logLineParseRegexString);
    }

    @Override
    public AuditReplayCommand parse(Long sequence, Text inputLine, Function<Long, Long> relativeToAbsolute) throws IOException {
        String[] auditMessageSanitizedList;
        long relativeTimestamp;
        Matcher m = this.logLineParseRegex.matcher(inputLine.toString());
        if (!m.find()) {
            throw new IOException("Unable to find valid message pattern from audit log line: `" + inputLine + "` using regex `" + this.logLineParseRegex + "`");
        }
        try {
            relativeTimestamp = this.dateFormat.parse(m.group("timestamp")).getTime() - this.startTimestamp;
        }
        catch (ParseException p) {
            throw new IOException("Exception while parsing timestamp from audit log line: `" + inputLine + "`", p);
        }
        String auditMessageSanitized = m.group("message").replace("(options=", "(options:");
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        for (String auditMessage : auditMessageSanitizedList = auditMessageSanitized.split("\t")) {
            String[] splitMessage = auditMessage.split("=", 2);
            try {
                parameterMap.put(splitMessage[0], splitMessage[1]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("Exception while parsing a message from audit log line: `" + inputLine + "`", e);
            }
        }
        return new AuditReplayCommand(sequence, relativeToAbsolute.apply(relativeTimestamp), (String)SPACE_SPLITTER.split((CharSequence)parameterMap.get("ugi")).iterator().next(), ((String)parameterMap.get("cmd")).replace("(options:", "(options="), (String)parameterMap.get("src"), (String)parameterMap.get("dst"), (String)parameterMap.get("ip"));
    }
}

