/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.dynamometer.workloadgenerator.audit;

import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.tools.dynamometer.workloadgenerator.audit.AuditLogDirectParser;
import org.apache.hadoop.tools.dynamometer.workloadgenerator.audit.AuditReplayCommand;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestAuditLogDirectParser {
    private static final long START_TIMESTAMP = 10000L;
    private AuditLogDirectParser parser;
    private Long sequence = 1L;

    @BeforeEach
    public void setup() throws Exception {
        this.parser = new AuditLogDirectParser();
        Configuration conf = new Configuration();
        conf.setLong("auditreplay.log-start-time.ms", 10000L);
        this.parser.initialize(conf);
    }

    private Text getAuditString(String timestamp, String ugi, String cmd, String src, String dst) {
        return new Text(String.format("%s INFO FSNamesystem.audit: allowed=true\tugi=%s\tip=0.0.0.0\tcmd=%s\tsrc=%s\tdst=%s\tperm=null\tproto=rpc", timestamp, ugi, cmd, src, dst));
    }

    @Test
    public void testSimpleInput() throws Exception {
        Text in = this.getAuditString("1970-01-01 00:00:11,000", "fakeUser", "listStatus", "sourcePath", "null");
        AuditReplayCommand expected = new AuditReplayCommand(this.sequence, 1000L, "fakeUser", "listStatus", "sourcePath", "null", "0.0.0.0");
        Assertions.assertEquals((Object)expected, (Object)this.parser.parse(this.sequence, in, Function.identity()));
    }

    @Test
    public void testInputWithEquals() throws Exception {
        Text in = this.getAuditString("1970-01-01 00:00:11,000", "fakeUser", "listStatus", "day=1970", "null");
        AuditReplayCommand expected = new AuditReplayCommand(this.sequence, 1000L, "fakeUser", "listStatus", "day=1970", "null", "0.0.0.0");
        Assertions.assertEquals((Object)expected, (Object)this.parser.parse(this.sequence, in, Function.identity()));
    }

    @Test
    public void testInputWithRenameOptions() throws Exception {
        Text in = this.getAuditString("1970-01-01 00:00:11,000", "fakeUser", "rename (options=[TO_TRASH])", "sourcePath", "destPath");
        AuditReplayCommand expected = new AuditReplayCommand(this.sequence, 1000L, "fakeUser", "rename (options=[TO_TRASH])", "sourcePath", "destPath", "0.0.0.0");
        Assertions.assertEquals((Object)expected, (Object)this.parser.parse(this.sequence, in, Function.identity()));
    }

    @Test
    public void testInputWithTokenAuth() throws Exception {
        Text in = this.getAuditString("1970-01-01 00:00:11,000", "fakeUser (auth:TOKEN)", "create", "sourcePath", "null");
        AuditReplayCommand expected = new AuditReplayCommand(this.sequence, 1000L, "fakeUser", "create", "sourcePath", "null", "0.0.0.0");
        Assertions.assertEquals((Object)expected, (Object)this.parser.parse(this.sequence, in, Function.identity()));
    }

    @Test
    public void testInputWithProxyUser() throws Exception {
        Text in = this.getAuditString("1970-01-01 00:00:11,000", "proxyUser (auth:TOKEN) via fakeUser", "create", "sourcePath", "null");
        AuditReplayCommand expected = new AuditReplayCommand(this.sequence, 1000L, "proxyUser", "create", "sourcePath", "null", "0.0.0.0");
        Assertions.assertEquals((Object)expected, (Object)this.parser.parse(this.sequence, in, Function.identity()));
    }

    @Test
    public void testParseDefaultDateFormat() throws Exception {
        Text in = this.getAuditString("1970-01-01 13:00:00,000", "ignored", "ignored", "ignored", "ignored");
        AuditReplayCommand expected = new AuditReplayCommand(this.sequence, 46790000L, "ignored", "ignored", "ignored", "ignored", "0.0.0.0");
        Assertions.assertEquals((Object)expected, (Object)this.parser.parse(this.sequence, in, Function.identity()));
    }

    @Test
    public void testParseCustomDateFormat() throws Exception {
        this.parser = new AuditLogDirectParser();
        Configuration conf = new Configuration();
        conf.setLong("auditreplay.log-start-time.ms", 0L);
        conf.set("auditreplay.log-date.format", "yyyy-MM-dd hh:mm:ss,SSS a");
        this.parser.initialize(conf);
        Text in = this.getAuditString("1970-01-01 01:00:00,000 PM", "ignored", "ignored", "ignored", "ignored");
        AuditReplayCommand expected = new AuditReplayCommand(this.sequence, 46800000L, "ignored", "ignored", "ignored", "ignored", "0.0.0.0");
        Assertions.assertEquals((Object)expected, (Object)this.parser.parse(this.sequence, in, Function.identity()));
    }

    @Test
    public void testParseCustomTimeZone() throws Exception {
        this.parser = new AuditLogDirectParser();
        Configuration conf = new Configuration();
        conf.setLong("auditreplay.log-start-time.ms", 0L);
        conf.set("auditreplay.log-date.time-zone", "Etc/GMT-1");
        this.parser.initialize(conf);
        Text in = this.getAuditString("1970-01-01 01:00:00,000", "ignored", "ignored", "ignored", "ignored");
        AuditReplayCommand expected = new AuditReplayCommand(this.sequence, 0L, "ignored", "ignored", "ignored", "ignored", "0.0.0.0");
        Assertions.assertEquals((Object)expected, (Object)this.parser.parse(this.sequence, in, Function.identity()));
    }

    @Test
    public void testParseCustomAuditLineFormat() throws Exception {
        Text auditLine = new Text("CUSTOM FORMAT (1970-01-01 00:00:00,000) allowed=true\tugi=fakeUser\tip=0.0.0.0\tcmd=fakeCommand\tsrc=src\tdst=null\tperm=null\tproto=rpc");
        this.parser = new AuditLogDirectParser();
        Configuration conf = new Configuration();
        conf.setLong("auditreplay.log-start-time.ms", 0L);
        conf.set("auditreplay.log-parse-regex", "CUSTOM FORMAT \\((?<timestamp>.+?)\\) (?<message>.+)");
        this.parser.initialize(conf);
        AuditReplayCommand expected = new AuditReplayCommand(this.sequence, 0L, "fakeUser", "fakeCommand", "src", "null", "0.0.0.0");
        Assertions.assertEquals((Object)expected, (Object)this.parser.parse(this.sequence, auditLine, Function.identity()));
    }
}

