/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.dynamometer.workloadgenerator;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ImpersonationProvider;
import org.apache.hadoop.tools.dynamometer.workloadgenerator.WorkloadDriver;
import org.apache.hadoop.tools.dynamometer.workloadgenerator.audit.AuditCommandParser;
import org.apache.hadoop.tools.dynamometer.workloadgenerator.audit.AuditLogHiveTableParser;
import org.apache.hadoop.tools.dynamometer.workloadgenerator.audit.AuditReplayMapper;
import org.jline.utils.Log;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestWorkloadGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(TestWorkloadGenerator.class);
    private Configuration conf;
    private MiniDFSCluster miniCluster;
    private FileSystem dfs;

    @BeforeEach
    public void setup() throws Exception {
        this.conf = new Configuration();
        this.conf.setClass("hadoop.security.impersonation.provider.class", AllowUserImpersonationProvider.class, ImpersonationProvider.class);
        this.miniCluster = new MiniDFSCluster.Builder(this.conf).build();
        this.miniCluster.waitClusterUp();
        this.dfs = this.miniCluster.getFileSystem();
        this.dfs.mkdirs(new Path("/tmp"), new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
        this.dfs.setOwner(new Path("/tmp"), "hdfs", "hdfs");
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.miniCluster != null) {
            this.miniCluster.shutdown();
            this.miniCluster = null;
        }
    }

    @Test
    public void testAuditWorkloadDirectParserWithOutput() throws Exception {
        String workloadInputPath = TestWorkloadGenerator.class.getClassLoader().getResource("audit_trace_direct").toString();
        String auditOutputPath = "/tmp/trace_output_direct";
        this.conf.set("auditreplay.input-path", workloadInputPath);
        this.conf.set("auditreplay.output-path", auditOutputPath);
        this.conf.setLong("auditreplay.log-start-time.ms", 60000L);
        this.testAuditWorkloadWithOutput(auditOutputPath);
    }

    @Test
    public void testAuditWorkloadHiveParserWithOutput() throws Exception {
        String workloadInputPath = TestWorkloadGenerator.class.getClassLoader().getResource("audit_trace_hive").toString();
        String auditOutputPath = "/tmp/trace_output_hive";
        this.conf.set("auditreplay.input-path", workloadInputPath);
        this.conf.set("auditreplay.output-path", auditOutputPath);
        this.conf.setClass("auditreplay.command-parser.class", AuditLogHiveTableParser.class, AuditCommandParser.class);
        this.testAuditWorkloadWithOutput(auditOutputPath);
    }

    private void testAuditWorkloadWithOutput(String auditOutputPath) throws Exception {
        long workloadStartTime = System.currentTimeMillis() + 10000L;
        Job workloadJob = WorkloadDriver.getJobForSubmission((Configuration)this.conf, (String)this.dfs.getUri().toString(), (long)workloadStartTime, AuditReplayMapper.class);
        boolean success = workloadJob.waitForCompletion(true);
        Assertions.assertTrue((boolean)success, (String)"workload job should succeed");
        Counters counters = workloadJob.getCounters();
        Assertions.assertEquals((long)6L, (long)counters.findCounter((Enum)AuditReplayMapper.REPLAYCOUNTERS.TOTALCOMMANDS).getValue());
        Assertions.assertEquals((long)1L, (long)counters.findCounter((Enum)AuditReplayMapper.REPLAYCOUNTERS.TOTALINVALIDCOMMANDS).getValue());
        Assertions.assertTrue((boolean)this.dfs.getFileStatus(new Path("/tmp/test1")).isFile());
        Assertions.assertTrue((boolean)this.dfs.getFileStatus(new Path("/tmp/testDirRenamed")).isDirectory());
        Assertions.assertFalse((boolean)this.dfs.exists(new Path("/denied")));
        Assertions.assertTrue((boolean)this.dfs.exists(new Path(auditOutputPath)));
        try (FSDataInputStream auditOutputFile = this.dfs.open(new Path(auditOutputPath, "part-r-00000"));){
            String auditOutput = IOUtils.toString((InputStream)auditOutputFile, (Charset)StandardCharsets.UTF_8);
            Log.info((Object[])new Object[]{auditOutput});
            Assertions.assertTrue((boolean)auditOutput.matches(".*(hdfs,WRITE,[A-Z]+,[13]+,[0-9]+\\n){3}.*"));
        }
    }

    private static class AllowUserImpersonationProvider
    extends Configured
    implements ImpersonationProvider {
        private AllowUserImpersonationProvider() {
        }

        public void init(String configurationPrefix) {
        }

        public void authorize(UserGroupInformation user, InetAddress remoteAddress) throws AuthorizationException {
            try {
                if (!user.getRealUser().getShortUserName().equals(UserGroupInformation.getCurrentUser().getShortUserName())) {
                    throw new AuthorizationException();
                }
            }
            catch (IOException ioe) {
                throw new AuthorizationException((Throwable)ioe);
            }
        }
    }
}

