/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.dynamometer;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.thirdparty.com.google.common.primitives.Ints;
import org.apache.hadoop.tools.dynamometer.AMOptions;
import org.apache.hadoop.tools.dynamometer.DynoConstants;
import org.apache.hadoop.tools.dynamometer.DynoInfraUtils;
import org.apache.hadoop.tools.dynamometer.DynoResource;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.UpdatedContainer;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.client.api.async.NMClientAsync;
import org.apache.hadoop.yarn.client.api.async.impl.NMClientAsyncImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.util.Records;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ApplicationMaster {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationMaster.class);
    private static final Random RAND = new Random();
    private Configuration conf;
    private AMRMClientAsync<AMRMClient.ContainerRequest> amRMClient;
    private NMClientAsync nmClientAsync;
    private NMCallbackHandler containerListener;
    private AMOptions amOptions;
    private List<LocalResource> blockListFiles;
    private int numTotalDataNodes;
    private int numTotalDataNodeContainers;
    private AtomicInteger numCompletedDataNodeContainers = new AtomicInteger();
    private AtomicInteger numAllocatedDataNodeContainers = new AtomicInteger();
    private AtomicInteger numFailedDataNodeContainers = new AtomicInteger();
    private boolean completed = false;
    private final Object completionLock = new Object();
    private ByteBuffer allTokens;
    private List<Thread> launchThreads = new ArrayList<Thread>();
    private boolean launchNameNode;
    private String namenodeServiceRpcAddress = "";
    private Path remoteStoragePath;
    private Map<ApplicationAccessType, String> applicationAcls;
    private volatile Container namenodeContainer;
    private ConcurrentMap<ContainerId, Container> datanodeContainers = new ConcurrentHashMap<ContainerId, Container>();
    private String launchingUser;

    public static void main(String[] args) {
        boolean result = false;
        try {
            ApplicationMaster appMaster = new ApplicationMaster();
            LOG.info("Initializing ApplicationMaster");
            boolean doRun = appMaster.init(args);
            if (!doRun) {
                System.exit(0);
            }
            result = appMaster.run();
        }
        catch (Throwable t) {
            LOG.error("Error running ApplicationMaster", t);
            System.exit(1);
        }
        if (result) {
            LOG.info("Application Master completed successfully. exiting");
            System.exit(0);
        } else {
            LOG.info("Application Master failed. exiting");
            System.exit(2);
        }
    }

    public ApplicationMaster() {
        this.conf = new YarnConfiguration();
    }

    public boolean init(String[] args) throws ParseException {
        Options opts = new Options();
        AMOptions.setOptions(opts);
        CommandLine cliParser = new GnuParser().parse(opts, args);
        if (args.length == 0) {
            this.printUsage(opts);
            throw new IllegalArgumentException("No args specified for application master to initialize");
        }
        if (cliParser.hasOption("help")) {
            this.printUsage(opts);
            return false;
        }
        Map<String, String> envs = System.getenv();
        this.remoteStoragePath = new Path(envs.get("REMOTE_STORAGE_PATH"));
        this.applicationAcls = new HashMap<ApplicationAccessType, String>();
        this.applicationAcls.put(ApplicationAccessType.VIEW_APP, envs.get("JOB_ACL_VIEW"));
        this.launchingUser = envs.get(ApplicationConstants.Environment.USER.name());
        if (envs.containsKey("REMOTE_NN_RPC_ADDR")) {
            this.launchNameNode = false;
            this.namenodeServiceRpcAddress = envs.get("REMOTE_NN_RPC_ADDR");
        } else {
            this.launchNameNode = true;
        }
        ContainerId containerId = ContainerId.fromString((String)envs.get(ApplicationConstants.Environment.CONTAINER_ID.name()));
        ApplicationAttemptId appAttemptID = containerId.getApplicationAttemptId();
        LOG.info("Application master for app: appId={}, clusterTimestamp={}, attemptId={}", new Object[]{appAttemptID.getApplicationId().getId(), appAttemptID.getApplicationId().getClusterTimestamp(), appAttemptID.getAttemptId()});
        this.amOptions = AMOptions.initFromParser(cliParser);
        return true;
    }

    private void printUsage(Options opts) {
        new HelpFormatter().printHelp("ApplicationMaster", opts);
    }

    public boolean run() throws YarnException, IOException, InterruptedException {
        LOG.info("Starting ApplicationMaster");
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        credentials.getAllTokens().removeIf(token -> token.getKind().equals((Object)AMRMTokenIdentifier.KIND_NAME));
        this.allTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        RMCallbackHandler allocListener = new RMCallbackHandler();
        this.amRMClient = AMRMClientAsync.createAMRMClientAsync((int)1000, (AMRMClientAsync.AbstractCallbackHandler)allocListener);
        this.amRMClient.init(this.conf);
        this.amRMClient.start();
        this.containerListener = this.createNMCallbackHandler();
        this.nmClientAsync = new NMClientAsyncImpl((NMClientAsync.AbstractCallbackHandler)this.containerListener);
        this.nmClientAsync.init(this.conf);
        this.nmClientAsync.start();
        String appMasterHostname = NetUtils.getHostname();
        this.amRMClient.registerApplicationMaster(appMasterHostname, -1, "");
        Supplier<Boolean> exitCritera = this::isComplete;
        Optional<Object> namenodeProperties = Optional.empty();
        if (this.launchNameNode) {
            AMRMClient.ContainerRequest nnContainerRequest = this.setupContainerAskForRM(this.amOptions.getNameNodeMemoryMB(), this.amOptions.getNameNodeVirtualCores(), 0, this.amOptions.getNameNodeNodeLabelExpression());
            LOG.info("Requested NameNode ask: " + nnContainerRequest.toString());
            this.amRMClient.addContainerRequest(nnContainerRequest);
            Path namenodeInfoPath = new Path(this.remoteStoragePath, "nn_info.prop");
            LOG.info("Waiting on availability of NameNode information at " + namenodeInfoPath);
            namenodeProperties = DynoInfraUtils.waitForAndGetNameNodeProperties(exitCritera, this.conf, namenodeInfoPath, LOG);
            if (!namenodeProperties.isPresent()) {
                this.cleanup();
                return false;
            }
            this.namenodeServiceRpcAddress = DynoInfraUtils.getNameNodeServiceRpcAddr((Properties)namenodeProperties.get()).toString();
            LOG.info("NameNode information: " + namenodeProperties.get());
            LOG.info("NameNode can be reached at: " + DynoInfraUtils.getNameNodeHdfsUri((Properties)namenodeProperties.get()).toString());
            DynoInfraUtils.waitForNameNodeStartup((Properties)namenodeProperties.get(), exitCritera, LOG);
        } else {
            LOG.info("Using remote NameNode with RPC address: " + this.namenodeServiceRpcAddress);
        }
        this.blockListFiles = Collections.synchronizedList(this.getDataNodeBlockListingFiles());
        this.numTotalDataNodes = this.blockListFiles.size();
        if (this.numTotalDataNodes == 0) {
            LOG.error("No block listing files were found! Cannot run with 0 DataNodes.");
            this.markCompleted();
            return false;
        }
        this.numTotalDataNodeContainers = (int)Math.ceil((double)this.numTotalDataNodes / (double)Math.max(1, this.amOptions.getDataNodesPerCluster()));
        LOG.info("Requesting {} DataNode containers with {} MB memory, {} vcores", new Object[]{this.numTotalDataNodeContainers, this.amOptions.getDataNodeMemoryMB(), this.amOptions.getDataNodeVirtualCores()});
        for (int i = 0; i < this.numTotalDataNodeContainers; ++i) {
            AMRMClient.ContainerRequest datanodeAsk = this.setupContainerAskForRM(this.amOptions.getDataNodeMemoryMB(), this.amOptions.getDataNodeVirtualCores(), 1, this.amOptions.getDataNodeNodeLabelExpression());
            this.amRMClient.addContainerRequest(datanodeAsk);
            LOG.debug("Requested datanode ask: " + datanodeAsk.toString());
        }
        LOG.info("Finished requesting datanode containers");
        if (this.launchNameNode) {
            DynoInfraUtils.waitForNameNodeReadiness((Properties)namenodeProperties.get(), this.numTotalDataNodes, true, exitCritera, this.conf, LOG);
        }
        this.waitForCompletion();
        return this.cleanup();
    }

    private NMCallbackHandler createNMCallbackHandler() {
        return new NMCallbackHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCompletion() throws InterruptedException {
        Object object = this.completionLock;
        synchronized (object) {
            while (!this.completed) {
                this.completionLock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isComplete() {
        Object object = this.completionLock;
        synchronized (object) {
            return this.completed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markCompleted() {
        Object object = this.completionLock;
        synchronized (object) {
            this.completed = true;
            this.completionLock.notify();
        }
    }

    private boolean cleanup() {
        boolean success;
        FinalApplicationStatus appStatus;
        for (Thread launchThread : this.launchThreads) {
            try {
                launchThread.join(10000L);
            }
            catch (InterruptedException e) {
                LOG.info("Exception thrown in thread join: " + e.getMessage());
                e.printStackTrace();
            }
        }
        LOG.info("Application completed. Stopping running containers");
        this.nmClientAsync.stop();
        LOG.info("Application completed. Signalling finish to RM");
        String appMessage = null;
        if (this.numFailedDataNodeContainers.get() == 0 && this.numCompletedDataNodeContainers.get() == this.numTotalDataNodes) {
            appStatus = FinalApplicationStatus.SUCCEEDED;
            success = true;
        } else {
            appStatus = FinalApplicationStatus.FAILED;
            appMessage = "Diagnostics: total=" + this.numTotalDataNodeContainers + ", completed=" + this.numCompletedDataNodeContainers.get() + ", allocated=" + this.numAllocatedDataNodeContainers.get() + ", failed=" + this.numFailedDataNodeContainers.get();
            success = false;
        }
        try {
            this.amRMClient.unregisterApplicationMaster(appStatus, appMessage, null);
        }
        catch (IOException | YarnException ex) {
            LOG.error("Failed to unregister application", ex);
        }
        this.amRMClient.stop();
        return success;
    }

    private List<LocalResource> getDataNodeBlockListingFiles() throws IOException {
        Path blockListDirPath = new Path(System.getenv().get("BLOCK_ZIP_PATH"));
        LOG.info("Looking for block listing files in " + blockListDirPath);
        FileSystem blockZipFS = blockListDirPath.getFileSystem(this.conf);
        LinkedList<LocalResource> files = new LinkedList<LocalResource>();
        for (FileStatus stat : blockZipFS.listStatus(blockListDirPath, DynoConstants.BLOCK_LIST_FILE_FILTER)) {
            LocalResource blockListResource = LocalResource.newInstance((URL)URL.fromPath((Path)stat.getPath()), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)stat.getLen(), (long)stat.getModificationTime());
            files.add(blockListResource);
        }
        return files;
    }

    private boolean isNameNode(ContainerId containerId) {
        return this.namenodeContainer != null && this.namenodeContainer.getId().equals((Object)containerId);
    }

    private boolean isDataNode(ContainerId containerId) {
        return this.datanodeContainers.containsKey(containerId);
    }

    private AMRMClient.ContainerRequest setupContainerAskForRM(int memory, int vcores, int priority, String nodeLabel) {
        Priority pri = (Priority)Records.newRecord(Priority.class);
        pri.setPriority(priority);
        Resource capability = (Resource)Records.newRecord(Resource.class);
        capability.setMemorySize((long)memory);
        capability.setVirtualCores(vcores);
        return new AMRMClient.ContainerRequest(capability, null, null, pri, true, nodeLabel);
    }

    private class RMCallbackHandler
    extends AMRMClientAsync.AbstractCallbackHandler {
        private RMCallbackHandler() {
        }

        public void onContainersCompleted(List<ContainerStatus> completedContainers) {
            LOG.info("Got response from RM for container ask, completedCnt=" + completedContainers.size());
            for (ContainerStatus containerStatus : completedContainers) {
                String component;
                String containerInfo = "containerID=" + containerStatus.getContainerId() + ", state=" + containerStatus.getState() + ", exitStatus=" + containerStatus.getExitStatus() + ", diagnostics=" + StringUtils.abbreviate((String)containerStatus.getDiagnostics(), (int)1000);
                if (ApplicationMaster.this.isNameNode(containerStatus.getContainerId())) {
                    component = "NAMENODE";
                } else if (ApplicationMaster.this.isDataNode(containerStatus.getContainerId())) {
                    component = "DATANODE";
                } else {
                    LOG.error("Received container status for unknown container: " + containerInfo);
                    continue;
                }
                LOG.info("Got container status for " + component + ": " + containerInfo);
                assert (containerStatus.getState() == ContainerState.COMPLETE);
                if (component.equals("NAMENODE")) {
                    LOG.info("NameNode container completed; marking application as done");
                    ApplicationMaster.this.markCompleted();
                }
                int exitStatus = containerStatus.getExitStatus();
                int completedIdx = ApplicationMaster.this.numCompletedDataNodeContainers.incrementAndGet();
                if (0 != exitStatus) {
                    ApplicationMaster.this.numFailedDataNodeContainers.incrementAndGet();
                    continue;
                }
                LOG.info("DataNode {} completed successfully, containerId={}", (Object)completedIdx, (Object)containerStatus.getContainerId());
            }
            if (ApplicationMaster.this.numCompletedDataNodeContainers.get() == ApplicationMaster.this.numTotalDataNodeContainers) {
                LOG.info("All datanode containers completed; marking application as done");
                ApplicationMaster.this.markCompleted();
            }
        }

        public void onContainersAllocated(List<Container> allocatedContainers) {
            LOG.info("Got response from RM for container ask, allocatedCnt=" + allocatedContainers.size());
            for (Container container : allocatedContainers) {
                LaunchContainerRunnable containerLauncher;
                String componentType;
                Resource rsrc = container.getResource();
                if (ApplicationMaster.this.launchNameNode && rsrc.getMemorySize() >= (long)ApplicationMaster.this.amOptions.getNameNodeMemoryMB() && rsrc.getVirtualCores() >= ApplicationMaster.this.amOptions.getNameNodeVirtualCores() && ApplicationMaster.this.namenodeContainer == null) {
                    ApplicationMaster.this.namenodeContainer = container;
                    componentType = "NAMENODE";
                    containerLauncher = new LaunchContainerRunnable(container, true);
                } else if (rsrc.getMemorySize() >= (long)ApplicationMaster.this.amOptions.getDataNodeMemoryMB() && rsrc.getVirtualCores() >= ApplicationMaster.this.amOptions.getDataNodeVirtualCores() && ApplicationMaster.this.numAllocatedDataNodeContainers.get() < ApplicationMaster.this.numTotalDataNodes) {
                    if (ApplicationMaster.this.launchNameNode && ApplicationMaster.this.namenodeContainer == null) {
                        LOG.error("Received a container with following resources suited for a DataNode but no NameNode container exists: containerMem=" + rsrc.getMemorySize() + ", containerVcores=" + rsrc.getVirtualCores());
                        continue;
                    }
                    ApplicationMaster.this.numAllocatedDataNodeContainers.getAndIncrement();
                    ApplicationMaster.this.datanodeContainers.put(container.getId(), container);
                    componentType = "DATANODE";
                    containerLauncher = new LaunchContainerRunnable(container, false);
                } else {
                    LOG.warn("Received unwanted container allocation: " + container);
                    ApplicationMaster.this.nmClientAsync.stopContainerAsync(container.getId(), container.getNodeId());
                    continue;
                }
                LOG.info("Launching " + componentType + " on a new container., containerId=" + container.getId() + ", containerNode=" + container.getNodeId().getHost() + ":" + container.getNodeId().getPort() + ", containerNodeURI=" + container.getNodeHttpAddress() + ", containerResourceMemory=" + rsrc.getMemorySize() + ", containerResourceVirtualCores=" + rsrc.getVirtualCores());
                Thread launchThread = new Thread(containerLauncher);
                ApplicationMaster.this.launchThreads.add(launchThread);
                launchThread.start();
            }
        }

        public void onShutdownRequest() {
            ApplicationMaster.this.markCompleted();
        }

        public void onNodesUpdated(List<NodeReport> updatedNodes) {
            LOG.info("onNodesUpdated: " + Joiner.on((String)",").join(updatedNodes));
        }

        public float getProgress() {
            return 0.0f;
        }

        public void onError(Throwable e) {
            ApplicationMaster.this.markCompleted();
            ApplicationMaster.this.amRMClient.stop();
        }

        public void onContainersUpdated(List<UpdatedContainer> containers) {
            LOG.info("onContainersUpdated: " + Joiner.on((String)",").join(containers));
        }
    }

    private class NMCallbackHandler
    extends NMClientAsync.AbstractCallbackHandler {
        private NMCallbackHandler() {
        }

        public void onContainerStopped(ContainerId containerId) {
            if (ApplicationMaster.this.isNameNode(containerId)) {
                LOG.info("NameNode container stopped: " + containerId);
                ApplicationMaster.this.namenodeContainer = null;
                ApplicationMaster.this.markCompleted();
            } else if (ApplicationMaster.this.isDataNode(containerId)) {
                LOG.debug("DataNode container stopped: " + containerId);
                ApplicationMaster.this.datanodeContainers.remove(containerId);
            } else {
                LOG.error("onContainerStopped received unknown container ID: " + containerId);
            }
        }

        public void onContainerStatusReceived(ContainerId containerId, ContainerStatus containerStatus) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Container Status: id=" + containerId + ", status=" + containerStatus);
            }
        }

        public void onContainerStarted(ContainerId containerId, Map<String, ByteBuffer> allServiceResponse) {
            if (ApplicationMaster.this.isNameNode(containerId)) {
                LOG.info("NameNode container started at ID " + containerId);
            } else if (ApplicationMaster.this.isDataNode(containerId)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Succeeded to start DataNode Container " + containerId);
                }
                ApplicationMaster.this.nmClientAsync.getContainerStatusAsync(containerId, ((Container)ApplicationMaster.this.datanodeContainers.get(containerId)).getNodeId());
            } else {
                LOG.error("onContainerStarted received unknown container ID: " + containerId);
            }
        }

        public void onStartContainerError(ContainerId containerId, Throwable t) {
            if (ApplicationMaster.this.isNameNode(containerId)) {
                LOG.error("Failed to start namenode container ID " + containerId, t);
                ApplicationMaster.this.namenodeContainer = null;
                ApplicationMaster.this.markCompleted();
            } else if (ApplicationMaster.this.isDataNode(containerId)) {
                LOG.error("Failed to start DataNode Container " + containerId);
                ApplicationMaster.this.datanodeContainers.remove(containerId);
                ApplicationMaster.this.numCompletedDataNodeContainers.incrementAndGet();
                ApplicationMaster.this.numFailedDataNodeContainers.incrementAndGet();
            } else {
                LOG.error("onStartContainerError received unknown container ID: " + containerId);
            }
        }

        public void onGetContainerStatusError(ContainerId containerId, Throwable t) {
            LOG.error("Failed to query the status of Container " + containerId);
        }

        public void onStopContainerError(ContainerId containerId, Throwable t) {
            if (ApplicationMaster.this.isNameNode(containerId)) {
                LOG.error("Failed to stop NameNode container ID " + containerId);
                ApplicationMaster.this.namenodeContainer = null;
            } else if (ApplicationMaster.this.isDataNode(containerId)) {
                LOG.error("Failed to stop DataNode Container " + containerId);
                ApplicationMaster.this.datanodeContainers.remove(containerId);
            } else {
                LOG.error("onStopContainerError received unknown containerID: " + containerId);
            }
        }

        @Deprecated
        public void onContainerResourceIncreased(ContainerId containerId, Resource resource) {
            LOG.info("onContainerResourceIncreased: {}, {}", (Object)containerId, (Object)resource);
        }

        public void onContainerResourceUpdated(ContainerId containerId, Resource resource) {
            LOG.info("onContainerResourceUpdated: {}, {}", (Object)containerId, (Object)resource);
        }

        @Deprecated
        public void onIncreaseContainerResourceError(ContainerId containerId, Throwable t) {
            LOG.info("onIncreaseContainerResourceError: {}", (Object)containerId, (Object)t);
        }

        public void onUpdateContainerResourceError(ContainerId containerId, Throwable t) {
            LOG.info("onUpdateContainerResourceError: {}", (Object)containerId, (Object)t);
        }
    }

    private class LaunchContainerRunnable
    implements Runnable {
        private Container container;
        private boolean isNameNodeLauncher;

        LaunchContainerRunnable(Container lcontainer, boolean isNameNode) {
            this.container = lcontainer;
            this.isNameNodeLauncher = isNameNode;
        }

        private Map<String, LocalResource> getLocalResources() {
            HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
            Map<String, String> envs = System.getenv();
            this.addAsLocalResourceFromEnv(DynoConstants.CONF_ZIP, localResources, envs);
            this.addAsLocalResourceFromEnv(DynoConstants.START_SCRIPT, localResources, envs);
            this.addAsLocalResourceFromEnv(DynoConstants.HADOOP_BINARY, localResources, envs);
            this.addAsLocalResourceFromEnv(DynoConstants.VERSION, localResources, envs);
            this.addAsLocalResourceFromEnv(DynoConstants.DYNO_DEPENDENCIES, localResources, envs);
            if (this.isNameNodeLauncher) {
                this.addAsLocalResourceFromEnv(DynoConstants.FS_IMAGE, localResources, envs);
                this.addAsLocalResourceFromEnv(DynoConstants.FS_IMAGE_MD5, localResources, envs);
            } else {
                int blockFilesToLocalize = Math.max(1, ApplicationMaster.this.amOptions.getDataNodesPerCluster());
                for (int i = 0; i < blockFilesToLocalize; ++i) {
                    try {
                        localResources.put("blocks/block" + i, ApplicationMaster.this.blockListFiles.remove(0));
                        continue;
                    }
                    catch (IndexOutOfBoundsException e) {
                        break;
                    }
                }
            }
            return localResources;
        }

        @Override
        public void run() {
            LOG.info("Setting up container launch context for containerid=" + this.container.getId() + ", isNameNode=" + this.isNameNodeLauncher);
            ContainerLaunchContext ctx = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
            ctx.setEnvironment(ApplicationMaster.this.amOptions.getShellEnv());
            ctx.setApplicationACLs(ApplicationMaster.this.applicationAcls);
            try {
                ctx.setLocalResources(this.getLocalResources());
                ctx.setCommands(this.getContainerStartCommand());
            }
            catch (IOException e) {
                LOG.error("Error while configuring container!", (Throwable)e);
                return;
            }
            ctx.setTokens(ApplicationMaster.this.allTokens.duplicate());
            ApplicationMaster.this.nmClientAsync.startContainerAsync(this.container, ctx);
            LOG.info("Starting {}; track at: http://{}/node/containerlogs/{}/{}/", new Object[]{this.isNameNodeLauncher ? "NAMENODE" : "DATANODE", this.container.getNodeHttpAddress(), this.container.getId(), ApplicationMaster.this.launchingUser});
        }

        private List<String> getContainerStartCommand() throws IOException {
            ArrayList<Object> vargs = new ArrayList<Object>();
            vargs.add("./" + DynoConstants.START_SCRIPT.getResourcePath());
            String component = this.isNameNodeLauncher ? "namenode" : "datanode";
            vargs.add(component);
            if (this.isNameNodeLauncher) {
                vargs.add(ApplicationMaster.this.remoteStoragePath.getFileSystem(ApplicationMaster.this.conf).makeQualified(ApplicationMaster.this.remoteStoragePath).toString());
            } else {
                vargs.add(ApplicationMaster.this.namenodeServiceRpcAddress);
                vargs.add(String.valueOf(ApplicationMaster.this.amOptions.getDataNodeLaunchDelaySec() < 1L ? 0 : RAND.nextInt(Ints.checkedCast((long)ApplicationMaster.this.amOptions.getDataNodeLaunchDelaySec()))));
            }
            vargs.add("1><LOG_DIR>/stdout");
            vargs.add("2><LOG_DIR>/stderr");
            LOG.info("Completed setting up command for " + component + ": " + vargs);
            return Lists.newArrayList((Object[])new String[]{Joiner.on((String)" ").join(vargs)});
        }

        public void addAsLocalResourceFromEnv(DynoResource resource, Map<String, LocalResource> localResources, Map<String, String> env) {
            LOG.debug("Adding resource to localResources: " + resource);
            String resourcePath = resource.getResourcePath();
            if (resourcePath == null) {
                resourcePath = resource.getPath(env).getName();
            }
            localResources.put(resourcePath, LocalResource.newInstance((URL)URL.fromPath((Path)resource.getPath(env)), (LocalResourceType)resource.getType(), (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)resource.getLength(env), (long)resource.getTimestamp(env)));
        }
    }
}

