/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.dynamometer.blockgenerator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.tools.dynamometer.blockgenerator.BlockInfo;

class XMLParser {
    private static final Pattern BLOCK_PATTERN = Pattern.compile("<block><id>(\\d+)</id><genstamp>(\\d+)</genstamp><numBytes>(\\d+)</numBytes></block>");
    private State currentState = State.DEFAULT;
    private short currentReplication;

    XMLParser() {
    }

    List<BlockInfo> parseLine(String line) throws IOException {
        List<String> replicationStrings;
        if (this.currentState == State.DEFAULT) {
            if (line.contains("<INodeSection>")) {
                this.transitionTo(State.INODE_SECTION);
            } else {
                return Collections.emptyList();
            }
        }
        if (line.contains("<inode>")) {
            this.transitionTo(State.INODE);
        }
        if (line.contains("<type>FILE</type>")) {
            this.transitionTo(State.FILE);
        }
        if (!(replicationStrings = XMLParser.valuesFromXMLString(line, "replication")).isEmpty()) {
            if (replicationStrings.size() > 1) {
                throw new IOException(String.format("Found %s replication strings", replicationStrings.size()));
            }
            this.transitionTo(State.FILE_WITH_REPLICATION);
            this.currentReplication = Short.parseShort(replicationStrings.get(0));
        }
        Matcher blockMatcher = BLOCK_PATTERN.matcher(line);
        ArrayList<BlockInfo> blockInfos = new ArrayList<BlockInfo>();
        while (blockMatcher.find()) {
            if (this.currentState != State.FILE_WITH_REPLICATION) {
                throw new IOException("Found a block string when in state: " + this.currentState);
            }
            long id = Long.parseLong(blockMatcher.group(1));
            long gs = Long.parseLong(blockMatcher.group(2));
            long size = Long.parseLong(blockMatcher.group(3));
            blockInfos.add(new BlockInfo(id, gs, size, this.currentReplication));
        }
        if (line.contains("</inode>")) {
            this.transitionTo(State.INODE_SECTION);
        }
        if (line.contains("</INodeSection>")) {
            this.transitionTo(State.DEFAULT);
        }
        return blockInfos;
    }

    private void transitionTo(State nextState) throws IOException {
        if (!this.currentState.transitionAllowed(nextState)) {
            throw new IOException("State transition not allowed; from " + this.currentState + " to " + nextState);
        }
        this.currentState = nextState;
    }

    private static List<String> valuesFromXMLString(String xml, String field) {
        Matcher m = Pattern.compile("<" + field + ">(.+?)</" + field + ">").matcher(xml);
        ArrayList<String> found = new ArrayList<String>();
        while (m.find()) {
            found.add(m.group(1));
        }
        return found;
    }

    private static enum State {
        DEFAULT,
        INODE_SECTION,
        INODE,
        FILE,
        FILE_WITH_REPLICATION;

        private final Set<State> allowedTransitions = new HashSet<State>();

        private void addTransitions(State ... nextState) {
            this.allowedTransitions.addAll(Arrays.asList(nextState));
        }

        boolean transitionAllowed(State nextState) {
            return this.allowedTransitions.contains((Object)nextState);
        }

        static {
            DEFAULT.addTransitions(DEFAULT, INODE_SECTION);
            INODE_SECTION.addTransitions(DEFAULT, INODE);
            INODE.addTransitions(INODE_SECTION, FILE);
            FILE.addTransitions(INODE_SECTION, FILE_WITH_REPLICATION);
            FILE_WITH_REPLICATION.addTransitions(INODE_SECTION);
        }
    }
}

