/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.tools.CopyFilter;
import org.apache.hadoop.tools.RegexCopyFilter;
import org.apache.hadoop.tools.RegexpInConfigurationFilter;
import org.apache.hadoop.tools.TrueCopyFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCopyFilter {
    @Test
    public void testGetCopyFilterTrueCopyFilter() {
        Configuration configuration = new Configuration(false);
        CopyFilter copyFilter = CopyFilter.getCopyFilter((Configuration)configuration);
        Assertions.assertTrue((boolean)(copyFilter instanceof TrueCopyFilter), (String)"copyFilter should be instance of TrueCopyFilter");
    }

    @Test
    public void testGetCopyFilterRegexCopyFilter() {
        Configuration configuration = new Configuration(false);
        configuration.set("distcp.filters.file", "random");
        CopyFilter copyFilter = CopyFilter.getCopyFilter((Configuration)configuration);
        Assertions.assertTrue((boolean)(copyFilter instanceof RegexCopyFilter), (String)"copyFilter should be instance of RegexCopyFilter");
    }

    @Test
    public void testGetCopyFilterRegexpInConfigurationFilter() {
        String filterName = "org.apache.hadoop.tools.RegexpInConfigurationFilter";
        Configuration configuration = new Configuration(false);
        configuration.set("distcp.filters.class", "org.apache.hadoop.tools.RegexpInConfigurationFilter");
        CopyFilter copyFilter = CopyFilter.getCopyFilter((Configuration)configuration);
        Assertions.assertTrue((boolean)(copyFilter instanceof RegexpInConfigurationFilter), (String)"copyFilter should be instance of RegexpInConfigurationFilter");
    }

    @Test
    public void testGetCopyFilterNonExistingClass() throws Exception {
        String filterName = "org.apache.hadoop.tools.RegexpInConfigurationWrongFilter";
        Configuration configuration = new Configuration(false);
        configuration.set("distcp.filters.class", "org.apache.hadoop.tools.RegexpInConfigurationWrongFilter");
        LambdaTestUtils.intercept(RuntimeException.class, (String)"Unable to instantiate org.apache.hadoop.tools.RegexpInConfigurationWrongFilter", () -> CopyFilter.getCopyFilter((Configuration)configuration));
    }

    @Test
    public void testGetCopyFilterWrongClassType() throws Exception {
        String filterName = "org.apache.hadoop.tools.TestCopyFilter.FilterNotExtendingCopyFilter";
        Configuration configuration = new Configuration(false);
        configuration.set("distcp.filters.class", "org.apache.hadoop.tools.TestCopyFilter.FilterNotExtendingCopyFilter");
        LambdaTestUtils.intercept(RuntimeException.class, (String)"Unable to instantiate org.apache.hadoop.tools.TestCopyFilter.FilterNotExtendingCopyFilter", () -> CopyFilter.getCopyFilter((Configuration)configuration));
    }

    @Test
    public void testGetCopyFilterEmptyString() throws Exception {
        String filterName = "";
        Configuration configuration = new Configuration(false);
        configuration.set("distcp.filters.class", "");
        LambdaTestUtils.intercept(RuntimeException.class, (String)"Unable to instantiate ", () -> CopyFilter.getCopyFilter((Configuration)configuration));
    }

    private class FilterNotExtendingCopyFilter {
        private FilterNotExtendingCopyFilter() {
        }
    }
}

