/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.util;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class DistCpTestUtils {
    public static void assertXAttrs(Path path, FileSystem fs, Map<String, byte[]> expectedXAttrs) throws Exception {
        Map xAttrs = fs.getXAttrs(path);
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedXAttrs.size(), (int)xAttrs.size(), (String)path.toString());
        for (Map.Entry<String, byte[]> e : expectedXAttrs.entrySet()) {
            String name = e.getKey();
            byte[] value = e.getValue();
            if (value == null) {
                org.junit.jupiter.api.Assertions.assertTrue((xAttrs.containsKey(name) && xAttrs.get(name) == null ? 1 : 0) != 0);
                continue;
            }
            org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])value, (byte[])((byte[])xAttrs.get(name)));
        }
    }

    public static void assertRunDistCp(int exitCode, String src, String dst, String options, Configuration conf) throws Exception {
        DistCpTestUtils.assertRunDistCp(exitCode, src, dst, options == null ? new String[]{} : options.trim().split(" "), conf);
    }

    private static void assertRunDistCp(int exitCode, String src, String dst, String[] options, Configuration conf) throws Exception {
        DistCp distCp = new DistCp(conf, null);
        String[] optsArr = new String[options.length + 2];
        System.arraycopy(options, 0, optsArr, 0, options.length);
        optsArr[optsArr.length - 2] = src;
        optsArr[optsArr.length - 1] = dst;
        ((AbstractIntegerAssert)Assertions.assertThat((int)ToolRunner.run((Configuration)conf, (Tool)distCp, (String[])optsArr)).describedAs("Exit code of distcp %s", new Object[]{Arrays.stream(optsArr).collect(Collectors.joining(" "))})).isEqualTo(exitCode);
    }
}

