/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.tools.mapred.CopyCommitter;
import org.apache.hadoop.tools.mapred.CopyOutputFormat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCopyOutputFormat {
    private static final Logger LOG = LoggerFactory.getLogger(TestCopyOutputFormat.class);

    @Test
    public void testSetCommitDirectory() {
        try {
            Job job = Job.getInstance((Configuration)new Configuration());
            Assertions.assertEquals(null, (Object)CopyOutputFormat.getCommitDirectory((Job)job));
            job.getConfiguration().set("distcp.target.final.path", "");
            Assertions.assertEquals(null, (Object)CopyOutputFormat.getCommitDirectory((Job)job));
            Path directory = new Path("/tmp/test");
            CopyOutputFormat.setCommitDirectory((Job)job, (Path)directory);
            Assertions.assertEquals((Object)directory, (Object)CopyOutputFormat.getCommitDirectory((Job)job));
            Assertions.assertEquals((Object)directory.toString(), (Object)job.getConfiguration().get("distcp.target.final.path"));
        }
        catch (IOException e) {
            LOG.error("Exception encountered while running test", (Throwable)e);
            Assertions.fail((String)"Failed while testing for set Commit Directory");
        }
    }

    @Test
    public void testSetWorkingDirectory() {
        try {
            Job job = Job.getInstance((Configuration)new Configuration());
            Assertions.assertEquals(null, (Object)CopyOutputFormat.getWorkingDirectory((Job)job));
            job.getConfiguration().set("distcp.target.work.path", "");
            Assertions.assertEquals(null, (Object)CopyOutputFormat.getWorkingDirectory((Job)job));
            Path directory = new Path("/tmp/test");
            CopyOutputFormat.setWorkingDirectory((Job)job, (Path)directory);
            Assertions.assertEquals((Object)directory, (Object)CopyOutputFormat.getWorkingDirectory((Job)job));
            Assertions.assertEquals((Object)directory.toString(), (Object)job.getConfiguration().get("distcp.target.work.path"));
        }
        catch (IOException e) {
            LOG.error("Exception encountered while running test", (Throwable)e);
            Assertions.fail((String)"Failed while testing for set Working Directory");
        }
    }

    @Test
    public void testGetOutputCommitter() {
        try {
            TaskAttemptContextImpl context = new TaskAttemptContextImpl(new Configuration(), new TaskAttemptID("200707121733", 1, TaskType.MAP, 1, 1));
            context.getConfiguration().set("mapred.output.dir", "/out");
            Assertions.assertTrue((boolean)(new CopyOutputFormat().getOutputCommitter((TaskAttemptContext)context) instanceof CopyCommitter));
        }
        catch (IOException e) {
            LOG.error("Exception encountered ", (Throwable)e);
            Assertions.fail((String)"Unable to get output committer");
        }
    }

    @Test
    public void testCheckOutputSpecs() {
        try {
            JobContextImpl context2;
            CopyOutputFormat outputFormat = new CopyOutputFormat();
            Job job = Job.getInstance((Configuration)new Configuration());
            JobID jobID = new JobID("200707121733", 1);
            try {
                context2 = new JobContextImpl(job.getConfiguration(), jobID);
                outputFormat.checkOutputSpecs((JobContext)context2);
                Assertions.fail((String)"No checking for invalid work/commit path");
            }
            catch (IllegalStateException context2) {
                // empty catch block
            }
            CopyOutputFormat.setWorkingDirectory((Job)job, (Path)new Path("/tmp/work"));
            try {
                context2 = new JobContextImpl(job.getConfiguration(), jobID);
                outputFormat.checkOutputSpecs((JobContext)context2);
                Assertions.fail((String)"No checking for invalid commit path");
            }
            catch (IllegalStateException context3) {
                // empty catch block
            }
            job.getConfiguration().set("distcp.target.work.path", "");
            CopyOutputFormat.setCommitDirectory((Job)job, (Path)new Path("/tmp/commit"));
            try {
                context2 = new JobContextImpl(job.getConfiguration(), jobID);
                outputFormat.checkOutputSpecs((JobContext)context2);
                Assertions.fail((String)"No checking for invalid work path");
            }
            catch (IllegalStateException context4) {
                // empty catch block
            }
            CopyOutputFormat.setWorkingDirectory((Job)job, (Path)new Path("/tmp/work"));
            CopyOutputFormat.setCommitDirectory((Job)job, (Path)new Path("/tmp/commit"));
            try {
                context2 = new JobContextImpl(job.getConfiguration(), jobID);
                outputFormat.checkOutputSpecs((JobContext)context2);
            }
            catch (IllegalStateException ignore) {
                Assertions.fail((String)"Output spec check failed.");
            }
        }
        catch (IOException e) {
            LOG.error("Exception encountered while testing checkoutput specs", (Throwable)e);
            Assertions.fail((String)"Checkoutput Spec failure");
        }
        catch (InterruptedException e) {
            LOG.error("Exception encountered while testing checkoutput specs", (Throwable)e);
            Assertions.fail((String)"Checkoutput Spec failure");
        }
    }
}

