/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.RegexpInConfigurationFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRegexpInConfigurationFilter {
    @Test
    public void testShouldCopy() {
        Configuration configuration = new Configuration(false);
        configuration.set("distcp.exclude-file-regex", "\\/.*_COPYING_$|\\/.*_COPYING$|^.*\\/\\.[^\\/]*$|\\/_temporary$|\\/\\_temporary\\/|.*\\/\\.Trash\\/.*");
        RegexpInConfigurationFilter defaultCopyFilter = new RegexpInConfigurationFilter(configuration);
        Path shouldCopyPath = new Path("/user/bar");
        Assertions.assertTrue((boolean)defaultCopyFilter.shouldCopy(shouldCopyPath), (String)(shouldCopyPath.toString() + " should be copied"));
        shouldCopyPath = new Path("/user/bar/_COPYING");
        Assertions.assertFalse((boolean)defaultCopyFilter.shouldCopy(shouldCopyPath), (String)(shouldCopyPath.toString() + " shouldn't be copied"));
        shouldCopyPath = new Path("/user/bar/_COPYING_");
        Assertions.assertFalse((boolean)defaultCopyFilter.shouldCopy(shouldCopyPath), (String)(shouldCopyPath.toString() + " shouldn't be copied"));
        shouldCopyPath = new Path("/temp/");
        Assertions.assertTrue((boolean)defaultCopyFilter.shouldCopy(shouldCopyPath), (String)(shouldCopyPath.toString() + " should be copied"));
    }
}

