/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.tools.util.TestDistCpUtils;
import org.apache.hadoop.util.ExitUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestExternalCall {
    private static final Logger LOG = LoggerFactory.getLogger(TestExternalCall.class);
    private static FileSystem fs;
    private static String root;

    private static Configuration getConf() {
        Configuration conf = new Configuration();
        conf.set("fs.default.name", "file:///");
        conf.set("mapred.job.tracker", "local");
        return conf;
    }

    @BeforeEach
    public void setup() {
        ExitUtil.disableSystemExit();
        ExitUtil.disableSystemHalt();
        ExitUtil.resetFirstExitException();
        ExitUtil.resetFirstHaltException();
        try {
            fs = FileSystem.get((Configuration)TestExternalCall.getConf());
            root = new Path("target/tmp").makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString();
            TestDistCpUtils.delete(fs, root);
        }
        catch (IOException e) {
            LOG.error("Exception encountered ", (Throwable)e);
        }
    }

    @AfterEach
    public void tearDown() {
        ExitUtil.resetFirstExitException();
        ExitUtil.resetFirstHaltException();
    }

    @Test
    public void testCleanup() throws Exception {
        Configuration conf = TestExternalCall.getConf();
        Path stagingDir = JobSubmissionFiles.getStagingDir((Cluster)new Cluster(conf), (Configuration)conf);
        stagingDir.getFileSystem(conf).mkdirs(stagingDir);
        Path soure = this.createFile("tmp.txt");
        Path target = this.createFile("target.txt");
        DistCp distcp = new DistCp(conf, null);
        String[] arg = new String[]{soure.toString(), target.toString()};
        distcp.run(arg);
        Assertions.assertTrue((boolean)fs.exists(target));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path createFile(String fname) throws IOException {
        Path result = new Path(root + "/" + fname);
        try (FSDataOutputStream out = fs.create(result);){
            out.write((root + "/" + fname).getBytes());
            out.write("\n".getBytes());
        }
        return result;
    }

    @Test
    public void testCleanupTestViaToolRunner() throws IOException, InterruptedException {
        Configuration conf = TestExternalCall.getConf();
        Path stagingDir = JobSubmissionFiles.getStagingDir((Cluster)new Cluster(conf), (Configuration)conf);
        stagingDir.getFileSystem(conf).mkdirs(stagingDir);
        Path soure = this.createFile("tmp.txt");
        Path target = this.createFile("target.txt");
        try {
            String[] arg = new String[]{target.toString(), soure.toString()};
            DistCp.main((String[])arg);
            Assertions.fail();
        }
        catch (ExitUtil.ExitException t) {
            Assertions.assertTrue((boolean)fs.exists(target));
            Assertions.assertEquals((int)t.status, (int)0);
            Assertions.assertEquals((int)stagingDir.getFileSystem(conf).listStatus(stagingDir).length, (int)0);
        }
    }

    @Test
    public void testCleanupOfJob() throws Exception {
        Configuration conf = TestExternalCall.getConf();
        Path stagingDir = JobSubmissionFiles.getStagingDir((Cluster)new Cluster(conf), (Configuration)conf);
        stagingDir.getFileSystem(conf).mkdirs(stagingDir);
        Path soure = this.createFile("tmp.txt");
        Path target = this.createFile("target.txt");
        DistCp distcp = (DistCp)Mockito.mock(DistCp.class);
        Job job = (Job)Mockito.spy(Job.class);
        Mockito.when((Object)distcp.getConf()).thenReturn((Object)conf);
        Mockito.when((Object)distcp.createAndSubmitJob()).thenReturn((Object)job);
        Mockito.when((Object)distcp.execute()).thenCallRealMethod();
        Mockito.when((Object)distcp.execute(Mockito.anyBoolean())).thenCallRealMethod();
        ((Job)Mockito.doReturn((Object)true).when((Object)job)).waitForCompletion(Mockito.anyBoolean());
        Mockito.when((Object)distcp.run((String[])Mockito.any())).thenCallRealMethod();
        String[] arg = new String[]{soure.toString(), target.toString()};
        distcp.run(arg);
        ((Job)Mockito.verify((Object)job, (VerificationMode)Mockito.times((int)1))).close();
    }
}

