/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.tools.util.ThrottledInputStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestThrottledInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(TestThrottledInputStream.class);
    private static final int BUFF_SIZE = 1024;

    @Test
    public void testRead() {
        try {
            File tmpFile = this.createFile(1024L);
            File outFile = this.createFile();
            tmpFile.deleteOnExit();
            outFile.deleteOnExit();
            long maxBandwidth = this.copyAndAssert(tmpFile, outFile, 0L, 1.0f, -1, CB.ONE_C);
            this.copyAndAssert(tmpFile, outFile, maxBandwidth, 20.0f, 0, CB.BUFFER);
            this.copyAndAssert(tmpFile, outFile, maxBandwidth, 20.0f, 0, CB.BUFF_OFFSET);
            this.copyAndAssert(tmpFile, outFile, maxBandwidth, 20.0f, 0, CB.ONE_C);
        }
        catch (IOException e) {
            LOG.error("Exception encountered ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long copyAndAssert(File tmpFile, File outFile, long maxBandwidth, float factor, int sleepTime, CB flag) throws IOException {
        long bandwidth;
        long maxBPS = (long)((float)maxBandwidth / factor);
        ThrottledInputStream in = maxBandwidth == 0L ? new ThrottledInputStream((InputStream)new FileInputStream(tmpFile)) : new ThrottledInputStream((InputStream)new FileInputStream(tmpFile), (float)maxBPS);
        FileOutputStream out = new FileOutputStream(outFile);
        try {
            if (flag == CB.BUFFER) {
                TestThrottledInputStream.copyBytes((InputStream)in, out, 1024);
            } else if (flag == CB.BUFF_OFFSET) {
                TestThrottledInputStream.copyBytesWithOffset((InputStream)in, out, 1024);
            } else {
                TestThrottledInputStream.copyByteByByte((InputStream)in, out);
            }
            LOG.info("{}", (Object)in);
            bandwidth = in.getBytesPerSec();
            org.junit.jupiter.api.Assertions.assertEquals((long)in.getTotalBytesRead(), (long)tmpFile.length());
            org.junit.jupiter.api.Assertions.assertTrue(((double)bandwidth > (double)maxBandwidth / ((double)factor * 1.2) ? 1 : 0) != 0);
            org.junit.jupiter.api.Assertions.assertTrue((in.getTotalSleepTime() > (long)sleepTime || bandwidth <= maxBPS ? 1 : 0) != 0);
        }
        finally {
            IOUtils.closeStream((Closeable)in);
            IOUtils.closeStream((Closeable)out);
        }
        return bandwidth;
    }

    private static void copyBytesWithOffset(InputStream in, OutputStream out, int buffSize) throws IOException {
        byte[] buf = new byte[buffSize];
        int bytesRead = in.read(buf, 0, buffSize);
        while (bytesRead >= 0) {
            out.write(buf, 0, bytesRead);
            bytesRead = in.read(buf);
        }
    }

    private static void copyByteByByte(InputStream in, OutputStream out) throws IOException {
        int ch = in.read();
        while (ch >= 0) {
            out.write(ch);
            ch = in.read();
        }
    }

    private static void copyBytes(InputStream in, OutputStream out, int buffSize) throws IOException {
        byte[] buf = new byte[buffSize];
        int bytesRead = in.read(buf);
        while (bytesRead >= 0) {
            out.write(buf, 0, bytesRead);
            bytesRead = in.read(buf);
        }
    }

    private File createFile(long sizeInKB) throws IOException {
        File tmpFile = this.createFile();
        this.writeToFile(tmpFile, sizeInKB);
        return tmpFile;
    }

    private File createFile() throws IOException {
        return File.createTempFile("tmp", "dat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(File tmpFile, long sizeInKB) throws IOException {
        FileOutputStream out = new FileOutputStream(tmpFile);
        try {
            byte[] buffer = new byte[1024];
            for (long index = 0L; index < sizeInKB; ++index) {
                ((OutputStream)out).write(buffer);
            }
        }
        finally {
            IOUtils.closeStream((Closeable)out);
        }
    }

    @Test
    public void testFixThrottleInvalid() {
        int testFileCnt = 100;
        int fileSize = 19;
        int bandwidth = 20;
        File[] srcFiles = new File[testFileCnt];
        try {
            File destFile = this.createFile(testFileCnt * 100 * 1024);
            destFile.deleteOnExit();
            for (int i = 0; i < srcFiles.length; ++i) {
                srcFiles[i] = this.createFile(fileSize * 1024);
                srcFiles[i].deleteOnExit();
            }
            long begin = System.currentTimeMillis();
            LOG.info("begin: " + begin);
            for (File srcFile : srcFiles) {
                LOG.info("fileLength: " + srcFiles.length);
                this.copyAndAssert(srcFile, destFile, bandwidth * 1024 * 1024);
            }
            long end = System.currentTimeMillis();
            LOG.info("end: " + end);
            Assertions.assertThat((int)((int)(end - begin) / 1000)).isGreaterThanOrEqualTo(testFileCnt * fileSize / bandwidth);
        }
        catch (IOException e) {
            LOG.error("Exception encountered ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyAndAssert(File tmpFile, File outFile, long maxBPS) throws IOException {
        ThrottledInputStream in = new ThrottledInputStream((InputStream)new FileInputStream(tmpFile), (float)maxBPS);
        FileOutputStream out = new FileOutputStream(outFile);
        try {
            TestThrottledInputStream.copyBytes((InputStream)in, out, 1024);
            LOG.info("{}", (Object)in);
            org.junit.jupiter.api.Assertions.assertEquals((long)in.getTotalBytesRead(), (long)tmpFile.length());
            long bytesPerSec = in.getBytesPerSec();
            org.junit.jupiter.api.Assertions.assertTrue((bytesPerSec <= maxBPS ? 1 : 0) != 0);
        }
        finally {
            IOUtils.closeStream((Closeable)in);
            IOUtils.closeStream((Closeable)out);
        }
    }

    private static enum CB {
        ONE_C,
        BUFFER,
        BUFF_OFFSET;

    }
}

