/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.util;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.tools.util.RetriableCommand;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRetriableCommand {
    @Test
    public void testRetriableCommand() {
        try {
            new MyRetriableCommand(5).execute(new Object[]{0});
            Assertions.assertTrue((boolean)false);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)true);
        }
        try {
            new MyRetriableCommand(3).execute(new Object[]{0});
            Assertions.assertTrue((boolean)true);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)false);
        }
        try {
            new MyRetriableCommand(5, RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)5, (long)0L, (TimeUnit)TimeUnit.MILLISECONDS)).execute(new Object[]{0});
            Assertions.assertTrue((boolean)true);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)false);
        }
    }

    private static class MyRetriableCommand
    extends RetriableCommand {
        private int succeedAfter;
        private int retryCount = 0;

        public MyRetriableCommand(int succeedAfter) {
            super("MyRetriableCommand");
            this.succeedAfter = succeedAfter;
        }

        public MyRetriableCommand(int succeedAfter, RetryPolicy retryPolicy) {
            super("MyRetriableCommand", retryPolicy);
            this.succeedAfter = succeedAfter;
        }

        protected Object doExecute(Object ... arguments) throws Exception {
            if (++this.retryCount < this.succeedAfter) {
                throw new Exception("Transient failure#" + this.retryCount);
            }
            return 0;
        }
    }
}

