/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.RegexCopyFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRegexCopyFilter {
    @Test
    public void testShouldCopyTrue() {
        ArrayList<Pattern> filters = new ArrayList<Pattern>();
        filters.add(Pattern.compile("user"));
        RegexCopyFilter regexCopyFilter = new RegexCopyFilter("fakeFile");
        regexCopyFilter.setFilters(filters);
        Path shouldCopyPath = new Path("/user/bar");
        Assertions.assertTrue((boolean)regexCopyFilter.shouldCopy(shouldCopyPath));
    }

    @Test
    public void testShouldCopyFalse() {
        ArrayList<Pattern> filters = new ArrayList<Pattern>();
        filters.add(Pattern.compile(".*test.*"));
        RegexCopyFilter regexCopyFilter = new RegexCopyFilter("fakeFile");
        regexCopyFilter.setFilters(filters);
        Path shouldNotCopyPath = new Path("/user/testing");
        Assertions.assertFalse((boolean)regexCopyFilter.shouldCopy(shouldNotCopyPath));
    }

    @Test
    public void testShouldCopyWithMultipleFilters() {
        ArrayList<Pattern> filters = new ArrayList<Pattern>();
        filters.add(Pattern.compile(".*test.*"));
        filters.add(Pattern.compile("/user/b.*"));
        filters.add(Pattern.compile(".*_SUCCESS"));
        List<Path> toCopy = this.getTestPaths();
        int shouldCopyCount = 0;
        RegexCopyFilter regexCopyFilter = new RegexCopyFilter("fakeFile");
        regexCopyFilter.setFilters(filters);
        for (Path path : toCopy) {
            if (!regexCopyFilter.shouldCopy(path)) continue;
            ++shouldCopyCount;
        }
        Assertions.assertEquals((int)2, (int)shouldCopyCount);
    }

    @Test
    public void testShouldExcludeAll() {
        ArrayList<Pattern> filters = new ArrayList<Pattern>();
        filters.add(Pattern.compile(".*test.*"));
        filters.add(Pattern.compile("/user/b.*"));
        filters.add(Pattern.compile(".*"));
        List<Path> toCopy = this.getTestPaths();
        int shouldCopyCount = 0;
        RegexCopyFilter regexCopyFilter = new RegexCopyFilter("fakeFile");
        regexCopyFilter.setFilters(filters);
        for (Path path : toCopy) {
            if (!regexCopyFilter.shouldCopy(path)) continue;
            ++shouldCopyCount;
        }
        Assertions.assertEquals((int)0, (int)shouldCopyCount);
    }

    private List<Path> getTestPaths() {
        ArrayList<Path> toCopy = new ArrayList<Path>();
        toCopy.add(new Path("/user/bar"));
        toCopy.add(new Path("/user/foo/_SUCCESS"));
        toCopy.add(new Path("/hive/test_data"));
        toCopy.add(new Path("test"));
        toCopy.add(new Path("/user/foo/bar"));
        toCopy.add(new Path("/mapred/.staging_job"));
        return toCopy;
    }
}

