/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.tools.DistCpOptionSwitch;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.OptionsParser;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestOptionsParser {
    private static final float DELTA = 0.001f;

    @Test
    public void testParseIgnoreFailure() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldIgnoreFailures());
        options = OptionsParser.parse((String[])new String[]{"-i", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldIgnoreFailures());
    }

    @Test
    public void testParseOverwrite() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldOverwrite());
        options = OptionsParser.parse((String[])new String[]{"-overwrite", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldOverwrite());
        try {
            OptionsParser.parse((String[])new String[]{"-update", "-overwrite", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            org.junit.jupiter.api.Assertions.fail((String)"Update and overwrite aren't allowed together");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLogPath() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertNull((Object)options.getLogPath());
        options = OptionsParser.parse((String[])new String[]{"-log", "hdfs://localhost:8020/logs", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertEquals((Object)options.getLogPath(), (Object)new Path("hdfs://localhost:8020/logs"));
    }

    @Test
    public void testParseBlokcing() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldBlock());
        options = OptionsParser.parse((String[])new String[]{"-async", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldBlock());
    }

    @Test
    public void testParsebandwidth() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assertions.assertThat((float)options.getMapBandwidth()).isCloseTo(0.0f, Assertions.within((Float)Float.valueOf(0.001f)));
        options = OptionsParser.parse((String[])new String[]{"-bandwidth", "11.2", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assertions.assertThat((float)options.getMapBandwidth()).isCloseTo(11.2f, Assertions.within((Float)Float.valueOf(0.001f)));
    }

    @Test
    public void testParseNonPositiveBandwidth() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> OptionsParser.parse((String[])new String[]{"-bandwidth", "-11", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"}));
    }

    @Test
    public void testParseZeroBandwidth() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> OptionsParser.parse((String[])new String[]{"-bandwidth", "0", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"}));
    }

    @Test
    public void testParseSkipCRC() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldSkipCRC());
        options = OptionsParser.parse((String[])new String[]{"-update", "-skipcrccheck", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldSyncFolder());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldSkipCRC());
    }

    @Test
    public void testParseAtomicCommit() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldAtomicCommit());
        options = OptionsParser.parse((String[])new String[]{"-atomic", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldAtomicCommit());
        try {
            OptionsParser.parse((String[])new String[]{"-atomic", "-update", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            org.junit.jupiter.api.Assertions.fail((String)"Atomic and sync folders were allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testParseWorkPath() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertNull((Object)options.getAtomicWorkPath());
        options = OptionsParser.parse((String[])new String[]{"-atomic", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertNull((Object)options.getAtomicWorkPath());
        options = OptionsParser.parse((String[])new String[]{"-atomic", "-tmp", "hdfs://localhost:8020/work", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertEquals((Object)options.getAtomicWorkPath(), (Object)new Path("hdfs://localhost:8020/work"));
        try {
            OptionsParser.parse((String[])new String[]{"-tmp", "hdfs://localhost:8020/work", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            org.junit.jupiter.api.Assertions.fail((String)"work path was allowed without -atomic switch");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testParseSyncFolders() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldSyncFolder());
        options = OptionsParser.parse((String[])new String[]{"-update", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldSyncFolder());
    }

    @Test
    public void testParseDeleteMissing() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldDeleteMissing());
        options = OptionsParser.parse((String[])new String[]{"-update", "-delete", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldSyncFolder());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldDeleteMissing());
        options = OptionsParser.parse((String[])new String[]{"-overwrite", "-delete", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldOverwrite());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldDeleteMissing());
        try {
            OptionsParser.parse((String[])new String[]{"-atomic", "-delete", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            org.junit.jupiter.api.Assertions.fail((String)"Atomic and delete folders were allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testParseMaps() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assertions.assertThat((int)options.getMaxMaps()).isEqualTo(20);
        options = OptionsParser.parse((String[])new String[]{"-m", "1", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assertions.assertThat((int)options.getMaxMaps()).isEqualTo(1);
        options = OptionsParser.parse((String[])new String[]{"-m", "0", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assertions.assertThat((int)options.getMaxMaps()).isEqualTo(1);
        try {
            OptionsParser.parse((String[])new String[]{"-m", "hello", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            org.junit.jupiter.api.Assertions.fail((String)"Non numberic map parsed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            OptionsParser.parse((String[])new String[]{"-mapredXslConf", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            org.junit.jupiter.api.Assertions.fail((String)"Non numberic map parsed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testParseNumListstatusThreads() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)options.getNumListstatusThreads());
        options = OptionsParser.parse((String[])new String[]{"--numListstatusThreads", "12", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertEquals((int)12, (int)options.getNumListstatusThreads());
        options = OptionsParser.parse((String[])new String[]{"--numListstatusThreads", "0", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)options.getNumListstatusThreads());
        try {
            OptionsParser.parse((String[])new String[]{"--numListstatusThreads", "hello", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            org.junit.jupiter.api.Assertions.fail((String)"Non numberic numListstatusThreads parsed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        options = OptionsParser.parse((String[])new String[]{"--numListstatusThreads", "100", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertEquals((int)40, (int)options.getNumListstatusThreads());
    }

    @Test
    public void testSourceListing() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertEquals((Object)options.getSourceFileListing(), (Object)new Path("hdfs://localhost:8020/source/first"));
    }

    @Test
    public void testSourceListingAndSourcePath() {
        try {
            OptionsParser.parse((String[])new String[]{"-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            org.junit.jupiter.api.Assertions.fail((String)"Both source listing & source paths allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMissingSourceInfo() {
        try {
            OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/target/"});
            org.junit.jupiter.api.Assertions.fail((String)"Neither source listing not source paths present");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMissingTarget() {
        try {
            OptionsParser.parse((String[])new String[]{"-f", "hdfs://localhost:8020/source"});
            org.junit.jupiter.api.Assertions.fail((String)"Missing target allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidArgs() {
        try {
            OptionsParser.parse((String[])new String[]{"-m", "-f", "hdfs://localhost:8020/source"});
            org.junit.jupiter.api.Assertions.fail((String)"Missing map value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCopyStrategy() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"-strategy", "dynamic", "-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assertions.assertThat((String)options.getCopyStrategy()).isEqualTo((Object)"dynamic");
        options = OptionsParser.parse((String[])new String[]{"-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assertions.assertThat((String)options.getCopyStrategy()).isEqualTo((Object)"uniformsize");
    }

    @Test
    public void testTargetPath() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertEquals((Object)options.getTargetPath(), (Object)new Path("hdfs://localhost:8020/target/"));
    }

    @Test
    public void testPreserve() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        options = OptionsParser.parse((String[])new String[]{"-p", "-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.ACL));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.XATTR));
        options = OptionsParser.parse((String[])new String[]{"-p", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.ACL));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.XATTR));
        options = OptionsParser.parse((String[])new String[]{"-pbr", "-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.ACL));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.XATTR));
        options = OptionsParser.parse((String[])new String[]{"-pbrgup", "-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.ACL));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.XATTR));
        options = OptionsParser.parse((String[])new String[]{"-pbrgupcaxt", "-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.ACL));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.XATTR));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.TIMES));
        options = OptionsParser.parse((String[])new String[]{"-pc", "-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.ACL));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.XATTR));
        options = OptionsParser.parse((String[])new String[]{"-p", "-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertEquals((int)("-prbugpct".length() - 2), (int)options.getPreserveAttributes().size());
        try {
            OptionsParser.parse((String[])new String[]{"-pabcd", "-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target"});
            org.junit.jupiter.api.Assertions.fail((String)"Invalid preserve attribute");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        DistCpOptions.Builder builder = new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)builder.build().shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        builder.preserve(DistCpOptions.FileAttribute.PERMISSION);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.build().shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        builder.preserve(DistCpOptions.FileAttribute.PERMISSION);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.build().shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
    }

    @Test
    public void testOptionsSwitchAddToConf() {
        Configuration conf = new Configuration();
        org.junit.jupiter.api.Assertions.assertNull((Object)conf.get(DistCpOptionSwitch.ATOMIC_COMMIT.getConfigLabel()));
        DistCpOptionSwitch.addToConf((Configuration)conf, (DistCpOptionSwitch)DistCpOptionSwitch.ATOMIC_COMMIT);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)conf.getBoolean(DistCpOptionSwitch.ATOMIC_COMMIT.getConfigLabel(), false));
    }

    @Test
    public void testOptionsAppendToConf() {
        Configuration conf = new Configuration();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)conf.getBoolean(DistCpOptionSwitch.IGNORE_FAILURES.getConfigLabel(), false));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)conf.getBoolean(DistCpOptionSwitch.ATOMIC_COMMIT.getConfigLabel(), false));
        org.junit.jupiter.api.Assertions.assertEquals((Object)conf.getRaw(DistCpOptionSwitch.BANDWIDTH.getConfigLabel()), null);
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"-atomic", "-i", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        options.appendToConf(conf);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)conf.getBoolean(DistCpOptionSwitch.IGNORE_FAILURES.getConfigLabel(), false));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)conf.getBoolean(DistCpOptionSwitch.ATOMIC_COMMIT.getConfigLabel(), false));
        org.junit.jupiter.api.Assertions.assertEquals((double)conf.getFloat(DistCpOptionSwitch.BANDWIDTH.getConfigLabel(), -1.0f), (double)-1.0, (double)0.001f);
        conf = new Configuration();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)conf.getBoolean(DistCpOptionSwitch.SYNC_FOLDERS.getConfigLabel(), false));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)conf.getBoolean(DistCpOptionSwitch.DELETE_MISSING.getConfigLabel(), false));
        Assertions.assertThat((String)conf.get(DistCpOptionSwitch.PRESERVE_STATUS.getConfigLabel())).isNull();
        options = OptionsParser.parse((String[])new String[]{"-update", "-delete", "-pu", "-bandwidth", "11.2", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        options.appendToConf(conf);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)conf.getBoolean(DistCpOptionSwitch.SYNC_FOLDERS.getConfigLabel(), false));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)conf.getBoolean(DistCpOptionSwitch.DELETE_MISSING.getConfigLabel(), false));
        Assertions.assertThat((String)conf.get(DistCpOptionSwitch.PRESERVE_STATUS.getConfigLabel())).isEqualTo((Object)"U");
        Assertions.assertThat((float)conf.getFloat(DistCpOptionSwitch.BANDWIDTH.getConfigLabel(), -1.0f)).isCloseTo(11.2f, Assertions.within((Float)Float.valueOf(0.001f)));
    }

    @Test
    public void testOptionsAppendToConfDoesntOverwriteBandwidth() {
        Configuration conf = new Configuration();
        org.junit.jupiter.api.Assertions.assertEquals((Object)conf.getRaw(DistCpOptionSwitch.BANDWIDTH.getConfigLabel()), null);
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        options.appendToConf(conf);
        Assertions.assertThat((float)conf.getFloat(DistCpOptionSwitch.BANDWIDTH.getConfigLabel(), -1.0f)).isCloseTo(-1.0f, Assertions.within((Float)Float.valueOf(0.001f)));
        conf = new Configuration();
        org.junit.jupiter.api.Assertions.assertEquals((Object)conf.getRaw(DistCpOptionSwitch.BANDWIDTH.getConfigLabel()), null);
        options = OptionsParser.parse((String[])new String[]{"-update", "-delete", "-pu", "-bandwidth", "77", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        options.appendToConf(conf);
        org.junit.jupiter.api.Assertions.assertEquals((double)conf.getFloat(DistCpOptionSwitch.BANDWIDTH.getConfigLabel(), -1.0f), (double)77.0, (double)0.001f);
        conf = new Configuration();
        conf.set(DistCpOptionSwitch.BANDWIDTH.getConfigLabel(), "88");
        org.junit.jupiter.api.Assertions.assertEquals((Object)conf.getRaw(DistCpOptionSwitch.BANDWIDTH.getConfigLabel()), (Object)"88");
        options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        options.appendToConf(conf);
        org.junit.jupiter.api.Assertions.assertEquals((double)conf.getFloat(DistCpOptionSwitch.BANDWIDTH.getConfigLabel(), -1.0f), (double)88.0, (double)0.001f);
        conf = new Configuration();
        conf.set(DistCpOptionSwitch.BANDWIDTH.getConfigLabel(), "88.0");
        org.junit.jupiter.api.Assertions.assertEquals((Object)conf.getRaw(DistCpOptionSwitch.BANDWIDTH.getConfigLabel()), (Object)"88.0");
        options = OptionsParser.parse((String[])new String[]{"-bandwidth", "99", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        options.appendToConf(conf);
        org.junit.jupiter.api.Assertions.assertEquals((double)conf.getFloat(DistCpOptionSwitch.BANDWIDTH.getConfigLabel(), -1.0f), (double)99.0, (double)0.001f);
    }

    @Test
    public void testAppendOption() {
        Configuration conf = new Configuration();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)conf.getBoolean(DistCpOptionSwitch.APPEND.getConfigLabel(), false));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)conf.getBoolean(DistCpOptionSwitch.SYNC_FOLDERS.getConfigLabel(), false));
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"-update", "-append", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        options.appendToConf(conf);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)conf.getBoolean(DistCpOptionSwitch.APPEND.getConfigLabel(), false));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)conf.getBoolean(DistCpOptionSwitch.SYNC_FOLDERS.getConfigLabel(), false));
        try {
            OptionsParser.parse((String[])new String[]{"-append", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            org.junit.jupiter.api.Assertions.fail((String)"Append should fail if update option is not specified");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Append is valid only with update options", (Throwable)e);
        }
        try {
            OptionsParser.parse((String[])new String[]{"-append", "-update", "-skipcrccheck", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            org.junit.jupiter.api.Assertions.fail((String)"Append should fail if skipCrc option is specified");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Append is disallowed when skipping CRC", (Throwable)e);
        }
    }

    private void testSnapshotDiffOption(boolean isDiff) {
        String optionStr = isDiff ? "-diff" : "-rdiff";
        String optionLabel = isDiff ? DistCpOptionSwitch.DIFF.getConfigLabel() : DistCpOptionSwitch.RDIFF.getConfigLabel();
        Configuration conf = new Configuration();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)conf.getBoolean(optionLabel, false));
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"-update", optionStr, "s1", "s2", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        options.appendToConf(conf);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)conf.getBoolean(optionLabel, false));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(isDiff ? options.shouldUseDiff() : options.shouldUseRdiff()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"s1", (Object)options.getFromSnapshot());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"s2", (Object)options.getToSnapshot());
        options = OptionsParser.parse((String[])new String[]{optionStr, "s1", ".", "-update", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        options.appendToConf(conf);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)conf.getBoolean(optionLabel, false));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(isDiff ? options.shouldUseDiff() : options.shouldUseRdiff()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"s1", (Object)options.getFromSnapshot());
        org.junit.jupiter.api.Assertions.assertEquals((Object)".", (Object)options.getToSnapshot());
        try {
            OptionsParser.parse((String[])new String[]{optionStr, "s1", "-update", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            org.junit.jupiter.api.Assertions.fail((String)(optionStr + " should fail with only one snapshot name"));
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Must provide both the starting and ending snapshot names", (Throwable)e);
        }
        try {
            OptionsParser.parse((String[])new String[]{optionStr, "s1", "s2", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            org.junit.jupiter.api.Assertions.fail((String)(optionStr + " should fail if -update option is not specified"));
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"-diff/-rdiff is valid only with -update option", (Throwable)e);
        }
        try {
            OptionsParser.parse((String[])new String[]{"-diff", "s1", "s2", "-update", "-delete", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            org.junit.jupiter.api.Assertions.fail((String)"Should fail as -delete and -diff/-rdiff are mutually exclusive");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"-delete and -diff/-rdiff are mutually exclusive", (Throwable)e);
        }
        try {
            OptionsParser.parse((String[])new String[]{"-diff", "s1", "s2", "-delete", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            org.junit.jupiter.api.Assertions.fail((String)"Should fail as -delete and -diff/-rdiff are mutually exclusive");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"-delete and -diff/-rdiff are mutually exclusive", (Throwable)e);
        }
        try {
            OptionsParser.parse((String[])new String[]{optionStr, "s1", "s2", "-delete", "-overwrite", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            org.junit.jupiter.api.Assertions.fail((String)"Should fail as -delete and -diff are mutually exclusive");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"-delete and -diff/-rdiff are mutually exclusive", (Throwable)e);
        }
        String optionStrOther = isDiff ? "-rdiff" : "-diff";
        try {
            OptionsParser.parse((String[])new String[]{optionStr, "s1", "s2", optionStrOther, "s2", "s1", "-update", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            org.junit.jupiter.api.Assertions.fail((String)(optionStr + " should fail if " + optionStrOther + " is also specified"));
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"-diff and -rdiff are mutually exclusive", (Throwable)e);
        }
    }

    @Test
    public void testDiffOption() {
        this.testSnapshotDiffOption(true);
    }

    @Test
    public void testRdiffOption() {
        this.testSnapshotDiffOption(false);
    }

    @Test
    public void testExclusionsOption() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertNull((Object)options.getFiltersFile());
        options = OptionsParser.parse((String[])new String[]{"-filters", "/tmp/filters.txt", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assertions.assertThat((String)options.getFiltersFile()).isEqualTo((Object)"/tmp/filters.txt");
    }

    @Test
    public void testParseUpdateRoot() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)options.shouldUpdateRoot());
        options = OptionsParser.parse((String[])new String[]{"-updateRoot", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)options.shouldUpdateRoot());
    }
}

