/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.WithErasureCoding;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.impl.PathCapabilitiesSupport;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.tools.ECAdmin;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.tools.util.DistCpTestUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.util.functional.RemoteIterators;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestDistCpWithRawXAttrs {
    private static MiniDFSCluster cluster;
    private static Configuration conf;
    private static FileSystem fs;
    private static final String rawName1 = "raw.a1";
    private static final byte[] rawValue1;
    private static final String userName1 = "user.a1";
    private static final byte[] userValue1;
    private static final Path dir1;
    private static final Path subDir1;
    private static final Path file1;
    private static final Path FILE_2;
    private static final String rawRootName = "/.reserved/raw";
    private static final String rootedDestName = "/dest";
    private static final String rootedSrcName = "/src";
    private static final String rawDestName = "/.reserved/raw/dest";
    private static final String rawSrcName = "/.reserved/raw/src";
    private static final File base;
    private static final String TEST_ROOT_DIR;
    private static Path[] pathnames;

    @BeforeAll
    public static void init() throws Exception {
        conf = new Configuration();
        conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        conf.setInt("dfs.ls.limit", 2);
        conf.setClass("fs.file.impl", DummyEcFs.class, FileSystem.class);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).format(true).build();
        cluster.waitActive();
        fs = cluster.getFileSystem();
    }

    @AfterAll
    public static void shutdown() {
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{fs});
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreserveRawXAttrs1() throws Exception {
        String relSrc = "/./.reserved/../.reserved/raw/../raw/src/../src";
        String relDst = "/./.reserved/../.reserved/raw/../raw/dest/../dest";
        this.doTestPreserveRawXAttrs("/./.reserved/../.reserved/raw/../raw/src/../src", "/./.reserved/../.reserved/raw/../raw/dest/../dest", "-px", true, true, 0);
        this.doTestStandardPreserveRawXAttrs("-px", true);
        Path savedWd = fs.getWorkingDirectory();
        try {
            fs.setWorkingDirectory(new Path(rawRootName));
            this.doTestPreserveRawXAttrs("../../.reserved/raw/src", "../../.reserved/raw/dest", "-px", true, true, 0);
        }
        finally {
            fs.setWorkingDirectory(savedWd);
        }
    }

    @Test
    public void testPreserveRawXAttrs2() throws Exception {
        this.doTestStandardPreserveRawXAttrs("-p", false);
    }

    @Test
    public void testPreserveRawXAttrs3() throws Exception {
        this.doTestStandardPreserveRawXAttrs(null, false);
    }

    @Test
    public void testPreserveRawXAttrs4() throws Exception {
        this.doTestStandardPreserveRawXAttrs("-update -delete", false);
    }

    private static void makeFilesAndDirs(FileSystem fs) throws Exception {
        fs.delete(new Path(rootedSrcName), true);
        fs.delete(new Path(rootedDestName), true);
        fs.mkdirs(subDir1);
        fs.create(file1).close();
    }

    private void initXAttrs() throws Exception {
        TestDistCpWithRawXAttrs.makeFilesAndDirs(fs);
        for (Path p : pathnames) {
            fs.setXAttr(new Path(rawSrcName, p), rawName1, rawValue1);
            fs.setXAttr(new Path(rawSrcName, p), userName1, userValue1);
        }
    }

    private void doTestStandardPreserveRawXAttrs(String options, boolean expectUser) throws Exception {
        this.doTestPreserveRawXAttrs(rootedSrcName, rootedDestName, options, false, expectUser, 0);
        this.doTestPreserveRawXAttrs(rootedSrcName, rawDestName, options, false, expectUser, -1);
        this.doTestPreserveRawXAttrs(rawSrcName, rootedDestName, options, false, expectUser, -1);
        this.doTestPreserveRawXAttrs(rawSrcName, rawDestName, options, true, expectUser, 0);
    }

    private void doTestPreserveRawXAttrs(String src, String dest, String preserveOpts, boolean expectRaw, boolean expectUser, int expectedExitCode) throws Exception {
        this.initXAttrs();
        DistCpTestUtils.assertRunDistCp(expectedExitCode, src, dest, preserveOpts, conf);
        if (expectedExitCode == 0) {
            HashMap xAttrs = Maps.newHashMap();
            for (Path p : pathnames) {
                xAttrs.clear();
                if (expectRaw) {
                    xAttrs.put(rawName1, rawValue1);
                }
                if (expectUser) {
                    xAttrs.put(userName1, userValue1);
                }
                DistCpTestUtils.assertXAttrs(new Path(dest, p), fs, xAttrs);
            }
        }
    }

    @Test
    public void testPreserveAndNoPreserveEC() throws Exception {
        String src = rootedSrcName;
        String dest = rootedDestName;
        Path destDir1 = new Path("/dest/dir1");
        Path destSubDir1 = new Path(destDir1, "subdir1");
        String[] args = new String[]{"-setPolicy", "-path", dir1.toString(), "-policy", "XOR-2-1-1024k"};
        fs.delete(new Path(rootedDestName), true);
        fs.mkdirs(subDir1);
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        dfs.enableErasureCodingPolicy("XOR-2-1-1024k");
        dfs.setErasureCodingPolicy(dir1, "XOR-2-1-1024k");
        fs.create(file1).close();
        fs.create(FILE_2).close();
        int res = ToolRunner.run((Configuration)conf, (Tool)new ECAdmin(conf), (String[])args);
        org.junit.jupiter.api.Assertions.assertEquals((int)res, (int)0, (String)("Unable to set EC policy on " + subDir1.toString()));
        DistCpTestUtils.assertRunDistCp(0, rootedSrcName, rootedDestName, "-pe", conf);
        FileStatus srcStatus = fs.getFileStatus(new Path(rootedSrcName));
        FileStatus srcDir1Status = fs.getFileStatus(dir1);
        FileStatus srcSubDir1Status = fs.getFileStatus(subDir1);
        FileStatus srcFile2Status = fs.getFileStatus(FILE_2);
        FileStatus destStatus = fs.getFileStatus(new Path(rootedDestName));
        FileStatus destDir1Status = fs.getFileStatus(destDir1);
        FileStatus destSubDir1Status = fs.getFileStatus(destSubDir1);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)srcStatus.isErasureCoded(), (String)"/src is erasure coded!");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)destStatus.isErasureCoded(), (String)"/dest is erasure coded!");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)srcDir1Status.isErasureCoded(), (String)"/src/dir1 is not erasure coded!");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)srcFile2Status.isErasureCoded(), (String)"/src/dir1/file2 is not erasure coded");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)destDir1Status.isErasureCoded(), (String)"/dest/dir1 is not erasure coded!");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)srcSubDir1Status.isErasureCoded(), (String)"/src/dir1/subdir1 is not erasure coded!");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)destSubDir1Status.isErasureCoded(), (String)"/dest/dir1/subdir1 is not erasure coded!");
        fs.delete(new Path(rootedDestName), true);
        DistCpTestUtils.assertRunDistCp(0, rootedSrcName, rootedDestName, null, conf);
        FileStatus destFileStatus = fs.getFileStatus(new Path(destDir1, "file2"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)destFileStatus.isErasureCoded());
        org.junit.jupiter.api.Assertions.assertEquals((short)fs.getDefaultReplication(new Path(destDir1, "file2")), (short)destFileStatus.getReplication());
        dfs.unsetErasureCodingPolicy(dir1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreserveECAcrossFilesystems() throws Exception {
        String[] args = new String[]{"-setPolicy", "-path", dir1.toString(), "-policy", "XOR-2-1-1024k"};
        fs.delete(new Path(rootedDestName), true);
        fs.mkdirs(subDir1);
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        dfs.enableErasureCodingPolicy("XOR-2-1-1024k");
        dfs.setErasureCodingPolicy(dir1, "XOR-2-1-1024k");
        fs.create(file1).close();
        int res = ToolRunner.run((Configuration)conf, (Tool)new ECAdmin(conf), (String[])args);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)res, (String)("Unable to set EC policy on " + subDir1.toString()));
        String src = "/src/*";
        Path dest = new Path(TEST_ROOT_DIR, "dest");
        Path dest2Dir1 = new Path(dest, "dir1");
        Path dest2SubDir1 = new Path(dest2Dir1, "subdir1");
        try (DummyEcFs dummyEcFs = (DummyEcFs)FileSystem.get((URI)URI.create("file:///"), (Configuration)conf);){
            Path target = dummyEcFs.makeQualified(dest);
            DistCpTestUtils.assertRunDistCp(0, src, target.toString(), "-pe", conf);
            try {
                FileStatus destDir1Status = dummyEcFs.getFileStatus(dest2Dir1);
                FileStatus destSubDir1Status = dummyEcFs.getFileStatus(dest2SubDir1);
                org.junit.jupiter.api.Assertions.assertNotNull((Object)destDir1Status, (String)("FileStatus for path: " + dest2Dir1 + " is null"));
                org.junit.jupiter.api.Assertions.assertNotNull((Object)destSubDir1Status, (String)("FileStatus for path: " + dest2SubDir1 + " is null"));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)dummyEcFs.isPathErasureCoded(destDir1Status.getPath()), (String)("Path is not erasure coded : " + dest2Dir1));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)dummyEcFs.isPathErasureCoded(destSubDir1Status.getPath()), (String)("Path is not erasure coded : " + dest2SubDir1));
                String dfsTarget = rootedDestName;
                DistCpTestUtils.assertRunDistCp(0, target.toString(), dfsTarget, "-pe", conf);
                Path dfsTargetPath = new Path(dfsTarget);
                Path dfsTargetDir1 = new Path(dfsTarget, "dir1");
                ContractTestUtils.assertPathExists((FileSystem)fs, (String)("Path  doesn't exist:" + dfsTargetPath), (Path)dfsTargetPath);
                ContractTestUtils.assertPathExists((FileSystem)fs, (String)("Path  doesn't exist:" + dfsTargetDir1), (Path)dfsTargetDir1);
                FileStatus targetDir1Status = fs.getFileStatus(dfsTargetDir1);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)targetDir1Status.isErasureCoded(), (String)("Path is not erasure coded : " + targetDir1Status));
                fs.delete(dfsTargetPath, true);
            }
            finally {
                dummyEcFs.delete(new Path(base.getAbsolutePath()), true);
            }
        }
    }

    @Test
    public void testUseIterator() throws Exception {
        Path source = new Path(rootedSrcName);
        Path dest = new Path(rootedDestName);
        fs.delete(source, true);
        fs.delete(dest, true);
        fs.mkdirs(source);
        GenericTestUtils.createFiles((FileSystem)fs, (Path)source, (int)3, (int)10, (int)10);
        DistCpTestUtils.assertRunDistCp(0, source.toString(), dest.toString(), "-useiterator", conf);
        ((ListAssert)Assertions.assertThat((List)RemoteIterators.toList((RemoteIterator)fs.listFiles(dest, true))).describedAs("files", new Object[0])).hasSize(1110);
    }

    static {
        rawValue1 = new byte[]{55, 56, 57};
        userValue1 = new byte[]{56, 56, 56};
        dir1 = new Path("/src/dir1");
        subDir1 = new Path(dir1, "subdir1");
        file1 = new Path("/src/file1");
        FILE_2 = new Path("/src/dir1/file2");
        base = GenericTestUtils.getTestDir((String)"work-dir/localfs");
        TEST_ROOT_DIR = base.getAbsolutePath();
        pathnames = new Path[]{new Path("dir1"), new Path("dir1/subdir1"), new Path("file1")};
    }

    public static class DummyEcFs
    extends LocalFileSystem
    implements WithErasureCoding {
        private Set<Path> erasureCodedPaths = new HashSet<Path>();

        public boolean isPathErasureCoded(Path p) {
            return this.erasureCodedPaths.contains(p);
        }

        public boolean hasPathCapability(Path path, String capability) throws IOException {
            switch (PathCapabilitiesSupport.validatePathCapabilityArgs((Path)this.makeQualified(path), (String)capability)) {
                case "fs.option.openfile.ec.policy": {
                    return true;
                }
            }
            return super.hasPathCapability(path, capability);
        }

        public FileStatus getFileStatus(Path f) throws IOException {
            FileStatus fileStatus = super.getFileStatus(f);
            if (!this.erasureCodedPaths.contains(f)) {
                return fileStatus;
            }
            HashSet<FileStatus.AttrFlags> attrSet = new HashSet<FileStatus.AttrFlags>();
            attrSet.add(FileStatus.AttrFlags.HAS_EC);
            return new FileStatus(fileStatus.getLen(), fileStatus.isDirectory(), (int)fileStatus.getReplication(), fileStatus.getBlockSize(), fileStatus.getModificationTime(), fileStatus.getAccessTime(), fileStatus.getPermission(), fileStatus.getOwner(), fileStatus.getGroup(), fileStatus.isSymlink() ? fileStatus.getSymlink() : null, fileStatus.getPath(), attrSet);
        }

        public String getErasureCodingPolicyName(FileStatus fileStatus) {
            return "XOR-2-1-1024k";
        }

        public void setErasureCodingPolicy(Path path, String ecPolicyName) throws IOException {
            this.erasureCodedPaths.add(path);
        }
    }
}

