/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestDistCpWithAcls {
    private static MiniDFSCluster cluster;
    private static Configuration conf;
    private static FileSystem fs;

    @BeforeAll
    public static void init() throws Exception {
        TestDistCpWithAcls.initCluster(true, true);
        fs.mkdirs(new Path("/src/dir1/subdir1"));
        fs.mkdirs(new Path("/src/dir2"));
        fs.create(new Path("/src/dir2/file2")).close();
        fs.create(new Path("/src/dir2/file3")).close();
        fs.mkdirs(new Path("/src/dir3sticky"));
        fs.create(new Path("/src/file1")).close();
        fs.modifyAclEntries(new Path("/src/dir1"), Arrays.asList(TestDistCpWithAcls.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.ALL)));
        fs.modifyAclEntries(new Path("/src/dir2/file2"), Arrays.asList(TestDistCpWithAcls.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales", FsAction.NONE)));
        fs.setPermission(new Path("/src/dir2/file3"), new FsPermission(432));
        fs.modifyAclEntries(new Path("/src/file1"), Arrays.asList(TestDistCpWithAcls.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ)));
        fs.setPermission(new Path("/src/dir3sticky"), new FsPermission(1023));
    }

    @AfterAll
    public static void shutdown() {
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{fs});
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    public void testPreserveAcls() throws Exception {
        TestDistCpWithAcls.assertRunDistCp(0, "/dstPreserveAcls");
        TestDistCpWithAcls.assertAclEntries("/dstPreserveAcls/dir1", new AclEntry[]{TestDistCpWithAcls.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), TestDistCpWithAcls.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.ALL), TestDistCpWithAcls.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), TestDistCpWithAcls.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), TestDistCpWithAcls.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ_EXECUTE)});
        TestDistCpWithAcls.assertPermission("/dstPreserveAcls/dir1", (short)493);
        TestDistCpWithAcls.assertAclEntries("/dstPreserveAcls/dir1/subdir1", new AclEntry[0]);
        TestDistCpWithAcls.assertPermission("/dstPreserveAcls/dir1/subdir1", (short)493);
        TestDistCpWithAcls.assertAclEntries("/dstPreserveAcls/dir2", new AclEntry[0]);
        TestDistCpWithAcls.assertPermission("/dstPreserveAcls/dir2", (short)493);
        TestDistCpWithAcls.assertAclEntries("/dstPreserveAcls/dir2/file2", new AclEntry[]{TestDistCpWithAcls.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), TestDistCpWithAcls.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales", FsAction.NONE)});
        TestDistCpWithAcls.assertPermission("/dstPreserveAcls/dir2/file2", (short)420);
        TestDistCpWithAcls.assertAclEntries("/dstPreserveAcls/dir2/file3", new AclEntry[0]);
        TestDistCpWithAcls.assertPermission("/dstPreserveAcls/dir2/file3", (short)432);
        TestDistCpWithAcls.assertAclEntries("/dstPreserveAcls/dir3sticky", new AclEntry[0]);
        TestDistCpWithAcls.assertPermission("/dstPreserveAcls/dir3sticky", (short)1023);
        TestDistCpWithAcls.assertAclEntries("/dstPreserveAcls/file1", new AclEntry[]{TestDistCpWithAcls.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ), TestDistCpWithAcls.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)});
        TestDistCpWithAcls.assertPermission("/dstPreserveAcls/file1", (short)420);
    }

    @Test
    public void testAclsNotEnabled() throws Exception {
        try {
            TestDistCpWithAcls.restart(false);
            TestDistCpWithAcls.assertRunDistCp(-3, "/dstAclsNotEnabled");
        }
        finally {
            TestDistCpWithAcls.restart(true);
        }
    }

    @Test
    public void testAclsNotImplemented() throws Exception {
        TestDistCpWithAcls.assertRunDistCp(-3, "stubfs://dstAclsNotImplemented");
    }

    private static AclEntry aclEntry(AclEntryScope scope, AclEntryType type, FsAction permission) {
        return new AclEntry.Builder().setScope(scope).setType(type).setPermission(permission).build();
    }

    private static AclEntry aclEntry(AclEntryScope scope, AclEntryType type, String name, FsAction permission) {
        return new AclEntry.Builder().setScope(scope).setType(type).setName(name).setPermission(permission).build();
    }

    private static void assertAclEntries(String path, AclEntry[] entries) throws Exception {
        Assertions.assertArrayEquals((Object[])entries, (Object[])fs.getAclStatus(new Path(path)).getEntries().toArray(new AclEntry[0]));
    }

    private static void assertPermission(String path, short perm) throws Exception {
        Assertions.assertEquals((short)perm, (short)fs.getFileStatus(new Path(path)).getPermission().toShort());
    }

    private static void assertRunDistCp(int exitCode, String dst) throws Exception {
        DistCp distCp = new DistCp(conf, null);
        Assertions.assertEquals((int)exitCode, (int)ToolRunner.run((Configuration)conf, (Tool)distCp, (String[])new String[]{"-pa", "/src", dst}));
    }

    private static void initCluster(boolean format, boolean aclsEnabled) throws Exception {
        conf = new Configuration();
        conf.setBoolean("dfs.namenode.acls.enabled", aclsEnabled);
        conf.set("fs.defaultFS", "stubfs:///");
        conf.setClass("fs.stubfs.impl", StubFileSystem.class, FileSystem.class);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(format).build();
        cluster.waitActive();
        fs = cluster.getFileSystem();
    }

    private static void restart(boolean aclsEnabled) throws Exception {
        TestDistCpWithAcls.shutdown();
        TestDistCpWithAcls.initCluster(false, aclsEnabled);
    }

    public static class StubFileSystem
    extends FileSystem {
        public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
            return null;
        }

        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            return null;
        }

        public boolean delete(Path f, boolean recursive) throws IOException {
            return false;
        }

        public FileStatus getFileStatus(Path f) throws IOException {
            return null;
        }

        public URI getUri() {
            return URI.create("stubfs:///");
        }

        public Path getWorkingDirectory() {
            return new Path("/");
        }

        public FileStatus[] listStatus(Path f) throws IOException {
            return new FileStatus[0];
        }

        public boolean mkdirs(Path f, FsPermission permission) throws IOException {
            return false;
        }

        public FSDataInputStream open(Path f, int bufferSize) throws IOException {
            return null;
        }

        public boolean rename(Path src, Path dst) throws IOException {
            return false;
        }

        public void setWorkingDirectory(Path dir) {
        }
    }
}

