/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.tools.DistCpOptionSwitch;
import org.apache.hadoop.tools.DistCpOptions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDistCpOptions {
    private static final float DELTA = 0.001f;

    @Test
    public void testSetIgnoreFailure() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assertions.assertFalse((boolean)builder.build().shouldIgnoreFailures());
        builder.withIgnoreFailures(true);
        Assertions.assertTrue((boolean)builder.build().shouldIgnoreFailures());
    }

    @Test
    public void testSetOverwrite() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assertions.assertFalse((boolean)builder.build().shouldOverwrite());
        builder.withOverwrite(true);
        Assertions.assertTrue((boolean)builder.build().shouldOverwrite());
        try {
            builder.withSyncFolder(true).build();
            Assertions.fail((String)"Update and overwrite aren't allowed together");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLogPath() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assertions.assertNull((Object)builder.build().getLogPath());
        Path logPath = new Path("hdfs://localhost:8020/logs");
        builder.withLogPath(logPath);
        Assertions.assertEquals((Object)logPath, (Object)builder.build().getLogPath());
    }

    @Test
    public void testSetBlokcing() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assertions.assertTrue((boolean)builder.build().shouldBlock());
        builder.withBlocking(false);
        Assertions.assertFalse((boolean)builder.build().shouldBlock());
    }

    @Test
    public void testSetBandwidth() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assertions.assertEquals((float)0.0f, (float)builder.build().getMapBandwidth(), (float)0.001f);
        builder.withMapBandwidth(11.0f);
        Assertions.assertEquals((float)11.0f, (float)builder.build().getMapBandwidth(), (float)0.001f);
    }

    @Test
    public void testSetNonPositiveBandwidth() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/")).withMapBandwidth(-11.0f).build());
    }

    @Test
    public void testSetZeroBandwidth() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/")).withMapBandwidth(0.0f).build());
    }

    @Test
    public void testSetSkipCRC() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assertions.assertFalse((boolean)builder.build().shouldSkipCRC());
        DistCpOptions options = builder.withSyncFolder(true).withSkipCRC(true).build();
        Assertions.assertTrue((boolean)options.shouldSyncFolder());
        Assertions.assertTrue((boolean)options.shouldSkipCRC());
    }

    @Test
    public void testSetAtomicCommit() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assertions.assertFalse((boolean)builder.build().shouldAtomicCommit());
        builder.withAtomicCommit(true);
        Assertions.assertTrue((boolean)builder.build().shouldAtomicCommit());
        try {
            builder.withSyncFolder(true).build();
            Assertions.fail((String)"Atomic and sync folders were mutually exclusive");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetWorkPath() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assertions.assertNull((Object)builder.build().getAtomicWorkPath());
        builder.withAtomicCommit(true);
        Assertions.assertNull((Object)builder.build().getAtomicWorkPath());
        Path workPath = new Path("hdfs://localhost:8020/work");
        builder.withAtomicWorkPath(workPath);
        Assertions.assertEquals((Object)workPath, (Object)builder.build().getAtomicWorkPath());
    }

    @Test
    public void testSetSyncFolders() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assertions.assertFalse((boolean)builder.build().shouldSyncFolder());
        builder.withSyncFolder(true);
        Assertions.assertTrue((boolean)builder.build().shouldSyncFolder());
    }

    @Test
    public void testSetDeleteMissing() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assertions.assertFalse((boolean)builder.build().shouldDeleteMissing());
        DistCpOptions options = builder.withSyncFolder(true).withDeleteMissing(true).build();
        Assertions.assertTrue((boolean)options.shouldSyncFolder());
        Assertions.assertTrue((boolean)options.shouldDeleteMissing());
        options = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/")).withOverwrite(true).withDeleteMissing(true).build();
        Assertions.assertTrue((boolean)options.shouldOverwrite());
        Assertions.assertTrue((boolean)options.shouldDeleteMissing());
        try {
            new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/")).withDeleteMissing(true).build();
            Assertions.fail((String)"Delete missing should fail without update or overwrite options");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Delete missing is applicable only with update or overwrite options", (Throwable)e);
        }
        try {
            new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/")).withSyncFolder(true).withDeleteMissing(true).withUseDiff("s1", "s2").build();
            Assertions.fail((String)"Should have failed as -delete and -diff are mutually exclusive.");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"-delete and -diff/-rdiff are mutually exclusive.", (Throwable)e);
        }
    }

    @Test
    public void testSetMaps() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assertions.assertEquals((int)20, (int)builder.build().getMaxMaps());
        builder.maxMaps(1);
        Assertions.assertEquals((int)1, (int)builder.build().getMaxMaps());
        builder.maxMaps(0);
        Assertions.assertEquals((int)1, (int)builder.build().getMaxMaps());
    }

    @Test
    public void testSetNumListtatusThreads() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/"));
        Assertions.assertEquals((int)0, (int)builder.build().getNumListstatusThreads());
        builder.withNumListstatusThreads(12);
        Assertions.assertEquals((int)12, (int)builder.build().getNumListstatusThreads());
        builder.withNumListstatusThreads(0);
        Assertions.assertEquals((int)0, (int)builder.build().getNumListstatusThreads());
        builder.withNumListstatusThreads(80);
        Assertions.assertEquals((int)40, (int)builder.build().getNumListstatusThreads());
    }

    @Test
    public void testSourceListing() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/"));
        Assertions.assertEquals((Object)new Path("hdfs://localhost:8020/source/first"), (Object)builder.build().getSourceFileListing());
    }

    @Test
    public void testMissingTarget() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), null));
    }

    @Test
    public void testToString() {
        DistCpOptions option = new DistCpOptions.Builder(new Path("abc"), new Path("xyz")).build();
        String val = "DistCpOptions{atomicCommit=false, syncFolder=false, deleteMissing=false, ignoreFailures=false, overwrite=false, append=false, useDiff=false, useRdiff=false, fromSnapshot=null, toSnapshot=null, skipCRC=false, blocking=true, numListstatusThreads=0, maxMaps=20, mapBandwidth=0.0, copyStrategy='uniformsize', preserveStatus=[], atomicWorkPath=null, logPath=null, sourceFileListing=abc, sourcePaths=null, targetPath=xyz, filtersFile='null', blocksPerChunk=0, copyBufferSize=8192, verboseLog=false, directWrite=false, useiterator=false, updateRoot=false}";
        String optionString = option.toString();
        Assertions.assertEquals((Object)val, (Object)optionString);
        Assertions.assertNotSame((Object)DistCpOptionSwitch.ATOMIC_COMMIT.toString(), (Object)DistCpOptionSwitch.ATOMIC_COMMIT.name());
    }

    @Test
    public void testCopyStrategy() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/"));
        Assertions.assertEquals((Object)"uniformsize", (Object)builder.build().getCopyStrategy());
        builder.withCopyStrategy("dynamic");
        Assertions.assertEquals((Object)"dynamic", (Object)builder.build().getCopyStrategy());
    }

    @Test
    public void testTargetPath() {
        DistCpOptions options = new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/")).build();
        Assertions.assertEquals((Object)new Path("hdfs://localhost:8020/target/"), (Object)options.getTargetPath());
    }

    @Test
    public void testPreserve() {
        DistCpOptions options = new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/")).build();
        Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        options = new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/")).preserve(DistCpOptions.FileAttribute.ACL).build();
        Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.ACL));
        options = new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/")).preserve(DistCpOptions.FileAttribute.BLOCKSIZE).preserve(DistCpOptions.FileAttribute.REPLICATION).preserve(DistCpOptions.FileAttribute.PERMISSION).preserve(DistCpOptions.FileAttribute.USER).preserve(DistCpOptions.FileAttribute.GROUP).preserve(DistCpOptions.FileAttribute.CHECKSUMTYPE).build();
        Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        Assertions.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        Assertions.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.XATTR));
    }

    @Test
    public void testAppendOption() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/")).withSyncFolder(true).withAppend(true);
        Assertions.assertTrue((boolean)builder.build().shouldAppend());
        try {
            new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/")).withAppend(true).build();
            Assertions.fail((String)"Append should fail if update option is not specified");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Append is valid only with update options", (Throwable)e);
        }
        try {
            new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/")).withSyncFolder(true).withAppend(true).withSkipCRC(true).build();
            Assertions.fail((String)"Append should fail if skipCrc option is specified");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Append is disallowed when skipping CRC", (Throwable)e);
        }
    }

    @Test
    public void testDiffOption() {
        DistCpOptions options = new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/")).withSyncFolder(true).withUseDiff("s1", "s2").build();
        Assertions.assertTrue((boolean)options.shouldUseDiff());
        Assertions.assertEquals((Object)"s1", (Object)options.getFromSnapshot());
        Assertions.assertEquals((Object)"s2", (Object)options.getToSnapshot());
        options = new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/")).withSyncFolder(true).withUseDiff("s1", ".").build();
        Assertions.assertTrue((boolean)options.shouldUseDiff());
        Assertions.assertEquals((Object)"s1", (Object)options.getFromSnapshot());
        Assertions.assertEquals((Object)".", (Object)options.getToSnapshot());
        try {
            new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/")).withUseDiff("s1", "s2").build();
            Assertions.fail((String)"-diff should fail if -update option is not specified");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"-diff/-rdiff is valid only with -update option", (Throwable)e);
        }
        try {
            new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/")).withSyncFolder(true).withUseDiff("s1", "s2").withDeleteMissing(true).build();
            Assertions.fail((String)"Should fail as -delete and -diff/-rdiff are mutually exclusive.");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"-delete and -diff/-rdiff are mutually exclusive.", (Throwable)e);
        }
        try {
            new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/")).withUseDiff("s1", "s2").withDeleteMissing(true).build();
            Assertions.fail((String)"-diff should fail if -update option is not specified");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"-delete and -diff/-rdiff are mutually exclusive.", (Throwable)e);
        }
        try {
            new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/")).withDeleteMissing(true).withUseDiff("s1", "s2").build();
            Assertions.fail((String)"Should have failed as -delete and -diff are mutually exclusive");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"-delete and -diff/-rdiff are mutually exclusive", (Throwable)e);
        }
    }

    @Test
    public void testExclusionsOption() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/first"), new Path("hdfs://localhost:8020/target/"));
        Assertions.assertNull((Object)builder.build().getFiltersFile());
        builder.withFiltersFile("/tmp/filters.txt");
        Assertions.assertEquals((Object)"/tmp/filters.txt", (Object)builder.build().getFiltersFile());
    }

    @Test
    public void testSetOptionsForSplitLargeFile() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(new Path("hdfs://localhost:8020/source/"), new Path("hdfs://localhost:8020/target/")).withAppend(true).withSyncFolder(true);
        Assertions.assertFalse((boolean)builder.build().shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assertions.assertTrue((boolean)builder.build().shouldAppend());
        builder.withBlocksPerChunk(5440);
        Assertions.assertTrue((boolean)builder.build().shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assertions.assertFalse((boolean)builder.build().shouldAppend());
    }

    @Test
    public void testSetCopyBufferSize() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assertions.assertEquals((int)8192, (int)builder.build().getCopyBufferSize());
        builder.withCopyBufferSize(0x400000);
        Assertions.assertEquals((int)0x400000, (int)builder.build().getCopyBufferSize());
        builder.withCopyBufferSize(-1);
        Assertions.assertEquals((int)8192, (int)builder.build().getCopyBufferSize());
    }

    @Test
    public void testVerboseLog() {
        DistCpOptions.Builder builder = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/"));
        Assertions.assertFalse((boolean)builder.build().shouldVerboseLog());
        try {
            builder.withVerboseLog(true).build();
            Assertions.fail((String)"-v should fail if -log option is not specified");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"-v is valid only with -log option", (Throwable)e);
        }
        Path logPath = new Path("hdfs://localhost:8020/logs");
        builder.withLogPath(logPath).withVerboseLog(true);
        Assertions.assertTrue((boolean)builder.build().shouldVerboseLog());
    }

    @Test
    public void testAppendToConf() {
        int expectedBlocksPerChunk = 999;
        String expectedValForEmptyConfigKey = "VALUE_OF_EMPTY_CONFIG_KEY";
        DistCpOptions options = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/")).withBlocksPerChunk(999).build();
        Configuration config = new Configuration();
        config.set("", "VALUE_OF_EMPTY_CONFIG_KEY");
        options.appendToConf(config);
        Assertions.assertEquals((int)999, (int)config.getInt(DistCpOptionSwitch.BLOCKS_PER_CHUNK.getConfigLabel(), 0));
        Assertions.assertEquals((Object)"VALUE_OF_EMPTY_CONFIG_KEY", (Object)config.get(""), (String)"Some DistCpOptionSwitch's config label is empty! Pls ensure the config label is provided when apply to config, otherwise it may not be fetched properly");
    }

    @Test
    public void testUpdateRoot() {
        DistCpOptions options = new DistCpOptions.Builder(Collections.singletonList(new Path("hdfs://localhost:8020/source")), new Path("hdfs://localhost:8020/target/")).withUpdateRoot(true).build();
        Assertions.assertTrue((boolean)options.shouldUpdateRoot());
    }
}

