/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.DataInput;
import java.io.DataOutput;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCopyListingFileStatus {
    @Test
    public void testToString() {
        CopyListingFileStatus src = new CopyListingFileStatus(4344L, false, 2, 0x20000000L, 1234L, 5678L, new FsPermission(330), "dingo", "yaks", new Path("hdfs://localhost:4344"));
        src.toString();
        src = new CopyListingFileStatus();
        src.toString();
    }

    @Test
    public void testCopyListingFileStatusSerialization() throws Exception {
        CopyListingFileStatus src = new CopyListingFileStatus(4344L, false, 2, 0x20000000L, 1234L, 5678L, new FsPermission(330), "dingo", "yaks", new Path("hdfs://localhost:4344"));
        DataOutputBuffer dob = new DataOutputBuffer();
        src.write((DataOutput)dob);
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(dob.getData(), 0, dob.getLength());
        CopyListingFileStatus dst = new CopyListingFileStatus();
        dst.readFields((DataInput)dib);
        Assertions.assertEquals((Object)src, (Object)dst);
    }

    @Test
    public void testFileStatusEquality() throws Exception {
        FileStatus stat = new FileStatus(4344L, false, 2, 0x20000000L, 1234L, 5678L, new FsPermission(330), "dingo", "yaks", new Path("hdfs://localhost:4344/foo/bar/baz"));
        CopyListingFileStatus clfs = new CopyListingFileStatus(stat);
        Assertions.assertEquals((long)stat.getLen(), (long)clfs.getLen());
        Assertions.assertEquals((Object)stat.isDirectory(), (Object)clfs.isDirectory());
        Assertions.assertEquals((short)stat.getReplication(), (short)clfs.getReplication());
        Assertions.assertEquals((long)stat.getBlockSize(), (long)clfs.getBlockSize());
        Assertions.assertEquals((long)stat.getAccessTime(), (long)clfs.getAccessTime());
        Assertions.assertEquals((long)stat.getModificationTime(), (long)clfs.getModificationTime());
        Assertions.assertEquals((Object)stat.getPermission(), (Object)clfs.getPermission());
        Assertions.assertEquals((Object)stat.getOwner(), (Object)clfs.getOwner());
        Assertions.assertEquals((Object)stat.getGroup(), (Object)clfs.getGroup());
        Assertions.assertEquals((Object)stat.getPath(), (Object)clfs.getPath());
        Assertions.assertEquals((Object)stat.isErasureCoded(), (Object)clfs.isErasureCoded());
    }
}

