/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.DistCpOptionSwitch;
import org.apache.hadoop.tools.util.DistCpUtils;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class DistCpOptions {
    private static final Logger LOG = LoggerFactory.getLogger(Builder.class);
    public static final int MAX_NUM_LISTSTATUS_THREADS = 40;
    private final Path sourceFileListing;
    private final List<Path> sourcePaths;
    private final Path targetPath;
    private final boolean atomicCommit;
    private final Path atomicWorkPath;
    private final boolean syncFolder;
    private final Path trackPath;
    private boolean deleteMissing;
    private final boolean ignoreFailures;
    private final boolean overwrite;
    private final boolean append;
    private final boolean skipCRC;
    private final boolean blocking;
    private final boolean useDiff;
    private final boolean useRdiff;
    private final boolean verboseLog;
    private final String fromSnapshot;
    private final String toSnapshot;
    private final String filtersFile;
    private final Path logPath;
    private final String copyStrategy;
    private final float mapBandwidth;
    private final int numListstatusThreads;
    private final int maxMaps;
    private final EnumSet<FileAttribute> preserveStatus;
    private final int blocksPerChunk;
    private final int copyBufferSize;
    private final boolean directWrite;
    private final boolean useIterator;
    private final boolean updateRoot;

    private DistCpOptions(Builder builder) {
        this.sourceFileListing = builder.sourceFileListing;
        this.sourcePaths = builder.sourcePaths;
        this.targetPath = builder.targetPath;
        this.atomicCommit = builder.atomicCommit;
        this.atomicWorkPath = builder.atomicWorkPath;
        this.syncFolder = builder.syncFolder;
        this.deleteMissing = builder.deleteMissing;
        this.ignoreFailures = builder.ignoreFailures;
        this.overwrite = builder.overwrite;
        this.append = builder.append;
        this.skipCRC = builder.skipCRC;
        this.blocking = builder.blocking;
        this.useDiff = builder.useDiff;
        this.useRdiff = builder.useRdiff;
        this.fromSnapshot = builder.fromSnapshot;
        this.toSnapshot = builder.toSnapshot;
        this.filtersFile = builder.filtersFile;
        this.logPath = builder.logPath;
        this.copyStrategy = builder.copyStrategy;
        this.mapBandwidth = builder.mapBandwidth;
        this.numListstatusThreads = builder.numListstatusThreads;
        this.maxMaps = builder.maxMaps;
        this.preserveStatus = builder.preserveStatus;
        this.blocksPerChunk = builder.blocksPerChunk;
        this.copyBufferSize = builder.copyBufferSize;
        this.verboseLog = builder.verboseLog;
        this.trackPath = builder.trackPath;
        this.directWrite = builder.directWrite;
        this.useIterator = builder.useIterator;
        this.updateRoot = builder.updateRoot;
    }

    public Path getSourceFileListing() {
        return this.sourceFileListing;
    }

    public List<Path> getSourcePaths() {
        return this.sourcePaths == null ? null : Collections.unmodifiableList(this.getUniquePaths(this.sourcePaths));
    }

    private List<Path> getUniquePaths(List<Path> srcPaths) {
        LinkedHashSet<Path> uniquePaths = new LinkedHashSet<Path>();
        for (Path path : srcPaths) {
            if (uniquePaths.add(path)) continue;
            LOG.info("Path: {} added multiple times, ignoring the redundant entry.", (Object)path);
        }
        return new ArrayList<Path>(uniquePaths);
    }

    public Path getTargetPath() {
        return this.targetPath;
    }

    public boolean shouldAtomicCommit() {
        return this.atomicCommit;
    }

    public Path getAtomicWorkPath() {
        return this.atomicWorkPath;
    }

    public boolean shouldSyncFolder() {
        return this.syncFolder;
    }

    public boolean shouldDeleteMissing() {
        return this.deleteMissing;
    }

    public boolean shouldIgnoreFailures() {
        return this.ignoreFailures;
    }

    public boolean shouldOverwrite() {
        return this.overwrite;
    }

    public boolean shouldAppend() {
        return this.append;
    }

    public boolean shouldSkipCRC() {
        return this.skipCRC;
    }

    public boolean shouldBlock() {
        return this.blocking;
    }

    public boolean shouldUseDiff() {
        return this.useDiff;
    }

    public boolean shouldUseRdiff() {
        return this.useRdiff;
    }

    public boolean shouldUseSnapshotDiff() {
        return this.shouldUseDiff() || this.shouldUseRdiff();
    }

    public String getFromSnapshot() {
        return this.fromSnapshot;
    }

    public String getToSnapshot() {
        return this.toSnapshot;
    }

    public String getFiltersFile() {
        return this.filtersFile;
    }

    public Path getLogPath() {
        return this.logPath;
    }

    public String getCopyStrategy() {
        return this.copyStrategy;
    }

    public int getNumListstatusThreads() {
        return this.numListstatusThreads;
    }

    public int getMaxMaps() {
        return this.maxMaps;
    }

    public float getMapBandwidth() {
        return this.mapBandwidth;
    }

    public Set<FileAttribute> getPreserveAttributes() {
        return this.preserveStatus == null ? null : Collections.unmodifiableSet(this.preserveStatus);
    }

    public boolean shouldPreserve(FileAttribute attribute) {
        return this.preserveStatus.contains((Object)attribute);
    }

    public int getBlocksPerChunk() {
        return this.blocksPerChunk;
    }

    public int getCopyBufferSize() {
        return this.copyBufferSize;
    }

    public boolean shouldVerboseLog() {
        return this.verboseLog;
    }

    public Path getTrackPath() {
        return this.trackPath;
    }

    public boolean shouldDirectWrite() {
        return this.directWrite;
    }

    public boolean shouldUseIterator() {
        return this.useIterator;
    }

    public boolean shouldUpdateRoot() {
        return this.updateRoot;
    }

    public void appendToConf(Configuration conf) {
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.ATOMIC_COMMIT, String.valueOf(this.atomicCommit));
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.IGNORE_FAILURES, String.valueOf(this.ignoreFailures));
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.SYNC_FOLDERS, String.valueOf(this.syncFolder));
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.DELETE_MISSING, String.valueOf(this.deleteMissing));
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.OVERWRITE, String.valueOf(this.overwrite));
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.APPEND, String.valueOf(this.append));
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.DIFF, String.valueOf(this.useDiff));
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.RDIFF, String.valueOf(this.useRdiff));
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.SKIP_CRC, String.valueOf(this.skipCRC));
        if (this.mapBandwidth > 0.0f) {
            DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.BANDWIDTH, String.valueOf(this.mapBandwidth));
        }
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.PRESERVE_STATUS, DistCpUtils.packAttributes(this.preserveStatus));
        if (this.filtersFile != null) {
            DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.FILTERS, this.filtersFile);
        }
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.BLOCKS_PER_CHUNK, String.valueOf(this.blocksPerChunk));
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.COPY_BUFFER_SIZE, String.valueOf(this.copyBufferSize));
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.VERBOSE_LOG, String.valueOf(this.verboseLog));
        if (this.trackPath != null) {
            DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.TRACK_MISSING, String.valueOf(this.trackPath));
        }
        if (this.numListstatusThreads > 0) {
            DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.NUM_LISTSTATUS_THREADS, Integer.toString(this.numListstatusThreads));
        }
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.DIRECT_WRITE, String.valueOf(this.directWrite));
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.USE_ITERATOR, String.valueOf(this.useIterator));
        DistCpOptionSwitch.addToConf(conf, DistCpOptionSwitch.UPDATE_ROOT, String.valueOf(this.updateRoot));
    }

    public String toString() {
        return "DistCpOptions{atomicCommit=" + this.atomicCommit + ", syncFolder=" + this.syncFolder + ", deleteMissing=" + this.deleteMissing + ", ignoreFailures=" + this.ignoreFailures + ", overwrite=" + this.overwrite + ", append=" + this.append + ", useDiff=" + this.useDiff + ", useRdiff=" + this.useRdiff + ", fromSnapshot=" + this.fromSnapshot + ", toSnapshot=" + this.toSnapshot + ", skipCRC=" + this.skipCRC + ", blocking=" + this.blocking + ", numListstatusThreads=" + this.numListstatusThreads + ", maxMaps=" + this.maxMaps + ", mapBandwidth=" + this.mapBandwidth + ", copyStrategy='" + this.copyStrategy + "', preserveStatus=" + this.preserveStatus + ", atomicWorkPath=" + this.atomicWorkPath + ", logPath=" + this.logPath + ", sourceFileListing=" + this.sourceFileListing + ", sourcePaths=" + this.sourcePaths + ", targetPath=" + this.targetPath + ", filtersFile='" + this.filtersFile + "', blocksPerChunk=" + this.blocksPerChunk + ", copyBufferSize=" + this.copyBufferSize + ", verboseLog=" + this.verboseLog + ", directWrite=" + this.directWrite + ", useiterator=" + this.useIterator + ", updateRoot=" + this.updateRoot + "}";
    }

    public static class Builder {
        private Path sourceFileListing;
        private List<Path> sourcePaths;
        private Path targetPath;
        private boolean atomicCommit = false;
        private Path atomicWorkPath;
        private boolean syncFolder = false;
        private boolean deleteMissing = false;
        private boolean ignoreFailures = false;
        private boolean overwrite = false;
        private boolean append = false;
        private boolean skipCRC = false;
        private boolean blocking = true;
        private boolean verboseLog = false;
        private boolean useDiff = false;
        private boolean useRdiff = false;
        private String fromSnapshot;
        private String toSnapshot;
        private String filtersFile;
        private Path logPath;
        private Path trackPath;
        private String copyStrategy = "uniformsize";
        private int numListstatusThreads = 0;
        private int maxMaps = 20;
        private float mapBandwidth = 0.0f;
        private EnumSet<FileAttribute> preserveStatus = EnumSet.noneOf(FileAttribute.class);
        private int blocksPerChunk = 0;
        private int copyBufferSize = 8192;
        private boolean directWrite = false;
        private boolean useIterator = false;
        private boolean updateRoot = false;

        public Builder(List<Path> sourcePaths, Path targetPath) {
            Preconditions.checkArgument((sourcePaths != null && !sourcePaths.isEmpty() ? 1 : 0) != 0, (Object)"Source paths should not be null or empty!");
            Preconditions.checkArgument((targetPath != null ? 1 : 0) != 0, (Object)"Target path should not be null!");
            this.sourcePaths = sourcePaths;
            this.targetPath = targetPath;
        }

        public Builder(Path sourceFileListing, Path targetPath) {
            Preconditions.checkArgument((sourceFileListing != null ? 1 : 0) != 0, (Object)"Source file listing should not be null!");
            Preconditions.checkArgument((targetPath != null ? 1 : 0) != 0, (Object)"Target path should not be null!");
            this.sourceFileListing = sourceFileListing;
            this.targetPath = targetPath;
        }

        public DistCpOptions build() {
            this.setOptionsForSplitLargeFile();
            this.validate();
            return new DistCpOptions(this);
        }

        private void setOptionsForSplitLargeFile() {
            if (this.blocksPerChunk <= 0) {
                return;
            }
            LOG.info("Enabling preserving blocksize since " + DistCpOptionSwitch.BLOCKS_PER_CHUNK.getSwitch() + " is passed.");
            this.preserve(FileAttribute.BLOCKSIZE);
            LOG.info("Set " + DistCpOptionSwitch.APPEND.getSwitch() + " to false since " + DistCpOptionSwitch.BLOCKS_PER_CHUNK.getSwitch() + " is passed.");
            this.append = false;
        }

        private void validate() {
            if ((this.useDiff || this.useRdiff) && this.deleteMissing) {
                throw new IllegalArgumentException("-delete and -diff/-rdiff are mutually exclusive. The -delete option will be ignored.");
            }
            if (!this.atomicCommit && this.atomicWorkPath != null) {
                throw new IllegalArgumentException("-tmp work-path can only be specified along with -atomic");
            }
            if (this.syncFolder && this.atomicCommit) {
                throw new IllegalArgumentException("Atomic commit can't be used with sync folder or overwrite options");
            }
            if (this.deleteMissing && !this.overwrite && !this.syncFolder) {
                throw new IllegalArgumentException("Delete missing is applicable only with update or overwrite options");
            }
            if (this.overwrite && this.syncFolder) {
                throw new IllegalArgumentException("Overwrite and update options are mutually exclusive");
            }
            if (!this.syncFolder && this.append) {
                throw new IllegalArgumentException("Append is valid only with update options");
            }
            if (this.skipCRC && this.append) {
                throw new IllegalArgumentException("Append is disallowed when skipping CRC");
            }
            if (!this.syncFolder && (this.useDiff || this.useRdiff)) {
                throw new IllegalArgumentException("-diff/-rdiff is valid only with -update option");
            }
            if ((this.useDiff || this.useRdiff) && (StringUtils.isBlank((CharSequence)this.fromSnapshot) || StringUtils.isBlank((CharSequence)this.toSnapshot))) {
                throw new IllegalArgumentException("Must provide both the starting and ending snapshot names for -diff/-rdiff");
            }
            if (this.useDiff && this.useRdiff) {
                throw new IllegalArgumentException("-diff and -rdiff are mutually exclusive");
            }
            if (this.verboseLog && this.logPath == null) {
                throw new IllegalArgumentException("-v is valid only with -log option");
            }
        }

        @VisibleForTesting
        Builder withSourcePaths(List<Path> newSourcePaths) {
            this.sourcePaths = newSourcePaths;
            return this;
        }

        public Builder withAtomicCommit(boolean newAtomicCommit) {
            this.atomicCommit = newAtomicCommit;
            return this;
        }

        public Builder withAtomicWorkPath(Path newAtomicWorkPath) {
            this.atomicWorkPath = newAtomicWorkPath;
            return this;
        }

        public Builder withSyncFolder(boolean newSyncFolder) {
            this.syncFolder = newSyncFolder;
            return this;
        }

        public Builder withDeleteMissing(boolean newDeleteMissing) {
            this.deleteMissing = newDeleteMissing;
            return this;
        }

        public Builder withIgnoreFailures(boolean newIgnoreFailures) {
            this.ignoreFailures = newIgnoreFailures;
            return this;
        }

        public Builder withOverwrite(boolean newOverwrite) {
            this.overwrite = newOverwrite;
            return this;
        }

        public Builder withAppend(boolean newAppend) {
            this.append = newAppend;
            return this;
        }

        @Deprecated
        public Builder withCRC(boolean newSkipCRC) {
            this.skipCRC = newSkipCRC;
            return this;
        }

        public Builder withSkipCRC(boolean newSkipCRC) {
            this.skipCRC = newSkipCRC;
            return this;
        }

        public Builder withBlocking(boolean newBlocking) {
            this.blocking = newBlocking;
            return this;
        }

        public Builder withUseDiff(String newFromSnapshot, String newToSnapshot) {
            this.useDiff = true;
            this.fromSnapshot = newFromSnapshot;
            this.toSnapshot = newToSnapshot;
            return this;
        }

        public Builder withUseRdiff(String newFromSnapshot, String newToSnapshot) {
            this.useRdiff = true;
            this.fromSnapshot = newFromSnapshot;
            this.toSnapshot = newToSnapshot;
            return this;
        }

        public Builder withFiltersFile(String newFiletersFile) {
            this.filtersFile = newFiletersFile;
            return this;
        }

        public Builder withLogPath(Path newLogPath) {
            this.logPath = newLogPath;
            return this;
        }

        public Builder withTrackMissing(Path path) {
            this.trackPath = path;
            return this;
        }

        public Builder withCopyStrategy(String newCopyStrategy) {
            this.copyStrategy = newCopyStrategy;
            return this;
        }

        public Builder withMapBandwidth(float newMapBandwidth) {
            Preconditions.checkArgument((newMapBandwidth > 0.0f ? 1 : 0) != 0, (Object)("Bandwidth " + newMapBandwidth + " is invalid (should be > 0)"));
            this.mapBandwidth = newMapBandwidth;
            return this;
        }

        public Builder withNumListstatusThreads(int newNumListstatusThreads) {
            this.numListstatusThreads = newNumListstatusThreads > 40 ? 40 : (newNumListstatusThreads > 0 ? newNumListstatusThreads : 0);
            return this;
        }

        public Builder maxMaps(int newMaxMaps) {
            this.maxMaps = Math.max(newMaxMaps, 1);
            return this;
        }

        public Builder preserve(String attributes) {
            if (attributes == null || attributes.isEmpty()) {
                this.preserveStatus = EnumSet.allOf(FileAttribute.class);
            } else {
                for (int index = 0; index < attributes.length(); ++index) {
                    this.preserveStatus.add(FileAttribute.getAttribute(attributes.charAt(index)));
                }
            }
            return this;
        }

        public Builder preserve(FileAttribute attribute) {
            this.preserveStatus.add(attribute);
            return this;
        }

        public Builder withBlocksPerChunk(int newBlocksPerChunk) {
            this.blocksPerChunk = newBlocksPerChunk;
            return this;
        }

        public Builder withCopyBufferSize(int newCopyBufferSize) {
            this.copyBufferSize = newCopyBufferSize > 0 ? newCopyBufferSize : 8192;
            return this;
        }

        public Builder withVerboseLog(boolean newVerboseLog) {
            this.verboseLog = newVerboseLog;
            return this;
        }

        public Builder withDirectWrite(boolean newDirectWrite) {
            this.directWrite = newDirectWrite;
            return this;
        }

        public Builder withUseIterator(boolean useItr) {
            this.useIterator = useItr;
            return this;
        }

        public Builder withUpdateRoot(boolean updateRootAttrs) {
            this.updateRoot = updateRootAttrs;
            return this;
        }
    }

    public static enum FileAttribute {
        REPLICATION,
        BLOCKSIZE,
        USER,
        GROUP,
        PERMISSION,
        CHECKSUMTYPE,
        ACL,
        XATTR,
        TIMES,
        ERASURECODINGPOLICY;


        public static FileAttribute getAttribute(char symbol) {
            for (FileAttribute attribute : FileAttribute.values()) {
                if (attribute.name().charAt(0) != Character.toUpperCase(symbol)) continue;
                return attribute;
            }
            throw new NoSuchElementException("No attribute for " + symbol);
        }
    }
}

