/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.tools.DistCpContext;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.FileBasedCopyListing;
import org.apache.hadoop.tools.GlobbedCopyListing;
import org.apache.hadoop.tools.util.DistCpUtils;
import org.apache.hadoop.util.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CopyListing
extends Configured {
    private Credentials credentials;
    static final Logger LOG = LoggerFactory.getLogger(DistCp.class);

    public final void buildListing(Path pathToListFile, DistCpContext distCpContext) throws IOException {
        this.validatePaths(distCpContext);
        this.doBuildListing(pathToListFile, distCpContext);
        Configuration config = this.getConf();
        config.set("distcp.listing.file.path", pathToListFile.toString());
        config.setLong("mapred.total.bytes.expected", this.getBytesToCopy());
        config.setLong("mapred.number.of.records", this.getNumberOfPaths());
        this.validateFinalListing(pathToListFile, distCpContext);
        LOG.info("Number of paths in the copy list: " + this.getNumberOfPaths());
    }

    protected abstract void validatePaths(DistCpContext var1) throws IOException, InvalidInputException;

    protected abstract void doBuildListing(Path var1, DistCpContext var2) throws IOException;

    protected abstract long getBytesToCopy();

    protected abstract long getNumberOfPaths();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateFinalListing(Path pathToListFile, DistCpContext context) throws DuplicateFileException, IOException {
        Configuration config = this.getConf();
        boolean splitLargeFile = context.splitLargeFile();
        Path checkPath = splitLargeFile ? pathToListFile : DistCpUtils.sortListing(config, pathToListFile);
        SequenceFile.Reader reader = new SequenceFile.Reader(config, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)checkPath)});
        try {
            Text lastKey = new Text("*");
            long lastChunkOffset = -1L;
            long lastChunkLength = -1L;
            CopyListingFileStatus lastFileStatus = new CopyListingFileStatus();
            Text currentKey = new Text();
            HashSet aclSupportCheckFsSet = Sets.newHashSet();
            HashSet xAttrSupportCheckFsSet = Sets.newHashSet();
            long idx = 0L;
            while (reader.next((Writable)currentKey)) {
                FileSystem lastFs;
                URI lastFsUri;
                if (currentKey.equals((Object)lastKey)) {
                    CopyListingFileStatus currentFileStatus = new CopyListingFileStatus();
                    reader.getCurrentValue((Writable)currentFileStatus);
                    if (!splitLargeFile) {
                        throw new DuplicateFileException("File " + lastFileStatus.getPath() + " and " + currentFileStatus.getPath() + " would cause duplicates. Aborting");
                    }
                    if (lastChunkOffset + lastChunkLength != currentFileStatus.getChunkOffset()) {
                        throw new InvalidInputException("File " + lastFileStatus.getPath() + " " + lastChunkOffset + "," + lastChunkLength + " and " + currentFileStatus.getPath() + " " + currentFileStatus.getChunkOffset() + "," + currentFileStatus.getChunkLength() + " are not continuous. Aborting");
                    }
                }
                reader.getCurrentValue((Writable)lastFileStatus);
                if (context.shouldPreserve(DistCpOptions.FileAttribute.ACL) && !aclSupportCheckFsSet.contains(lastFsUri = (lastFs = lastFileStatus.getPath().getFileSystem(config)).getUri())) {
                    DistCpUtils.checkFileSystemAclSupport(lastFs);
                    aclSupportCheckFsSet.add(lastFsUri);
                }
                if (context.shouldPreserve(DistCpOptions.FileAttribute.XATTR) && !xAttrSupportCheckFsSet.contains(lastFsUri = (lastFs = lastFileStatus.getPath().getFileSystem(config)).getUri())) {
                    DistCpUtils.checkFileSystemXAttrSupport(lastFs);
                    xAttrSupportCheckFsSet.add(lastFsUri);
                }
                lastKey.set(currentKey);
                if (splitLargeFile) {
                    lastChunkOffset = lastFileStatus.getChunkOffset();
                    lastChunkLength = lastFileStatus.getChunkLength();
                }
                if (!context.shouldUseDiff() || !LOG.isDebugEnabled()) continue;
                LOG.debug("Copy list entry " + idx + ": " + lastFileStatus.getPath().toUri().getPath());
                ++idx;
            }
        }
        finally {
            IOUtils.closeStream((Closeable)reader);
        }
    }

    protected CopyListing(Configuration configuration, Credentials credentials) {
        this.setConf(configuration);
        this.setCredentials(credentials);
    }

    protected void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    protected Credentials getCredentials() {
        return this.credentials;
    }

    protected Text getFileListingKey(Path sourcePathRoot, CopyListingFileStatus fileStatus) {
        return new Text(DistCpUtils.getRelativePath(sourcePathRoot, fileStatus.getPath()));
    }

    protected CopyListingFileStatus getFileListingValue(CopyListingFileStatus fileStatus) {
        return fileStatus;
    }

    public static CopyListing getCopyListing(Configuration configuration, Credentials credentials, DistCpContext context) throws IOException {
        String copyListingClassName = configuration.get("distcp.copy.listing.class", "");
        try {
            Class copyListingClass = !copyListingClassName.isEmpty() ? configuration.getClass("distcp.copy.listing.class", GlobbedCopyListing.class, CopyListing.class) : (context.getSourceFileListing() == null ? GlobbedCopyListing.class : FileBasedCopyListing.class);
            copyListingClassName = copyListingClass.getName();
            Constructor constructor = copyListingClass.getDeclaredConstructor(Configuration.class, Credentials.class);
            return (CopyListing)((Object)constructor.newInstance(configuration, credentials));
        }
        catch (Exception e) {
            throw new IOException("Unable to instantiate " + copyListingClassName, e);
        }
    }

    static class DuplicateFileException
    extends RuntimeException {
        public DuplicateFileException(String message) {
            super(message);
        }
    }

    static class InvalidInputException
    extends RuntimeException {
        public InvalidInputException(String message) {
            super(message);
        }

        public InvalidInputException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class XAttrsNotSupportedException
    extends RuntimeException {
        public XAttrsNotSupportedException(String message) {
            super(message);
        }
    }

    public static class AclsNotSupportedException
    extends RuntimeException {
        public AclsNotSupportedException(String message) {
            super(message);
        }
    }
}

