/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.cosn;

import com.qcloud.cos.auth.COSCredentialsProvider;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.cosn.auth.COSCredentialsProviderList;
import org.apache.hadoop.fs.cosn.auth.EnvironmentVariableCredentialsProvider;
import org.apache.hadoop.fs.cosn.auth.SimpleCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CosNUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CosNUtils.class);
    static final String INSTANTIATION_EXCEPTION = "instantiation exception";
    static final String NOT_COS_CREDENTIAL_PROVIDER = "is not cos credential provider";
    static final String ABSTRACT_CREDENTIAL_PROVIDER = "is abstract and therefore cannot be created";

    private CosNUtils() {
    }

    public static COSCredentialsProviderList createCosCredentialsProviderSet(URI uri, Configuration conf) throws IOException {
        COSCredentialsProviderList credentialProviderList = new COSCredentialsProviderList();
        Class<?>[] cosClasses = CosNUtils.loadCosProviderClasses(conf, "fs.cosn.credentials.provider", new Class[0]);
        if (0 == cosClasses.length) {
            credentialProviderList.add(new SimpleCredentialsProvider(uri, conf));
            credentialProviderList.add(new EnvironmentVariableCredentialsProvider(uri, conf));
        } else {
            for (Class<?> credClass : cosClasses) {
                credentialProviderList.add(CosNUtils.createCOSCredentialProvider(uri, conf, credClass));
            }
        }
        return credentialProviderList;
    }

    public static Class<?>[] loadCosProviderClasses(Configuration conf, String key, Class<?> ... defaultValue) throws IOException {
        try {
            return conf.getClasses(key, (Class[])defaultValue);
        }
        catch (RuntimeException e) {
            Throwable c = e.getCause() != null ? e.getCause() : e;
            throw new IOException("From option " + key + " " + c, c);
        }
    }

    public static COSCredentialsProvider createCOSCredentialProvider(URI uri, Configuration conf, Class<?> credClass) throws IOException {
        if (!COSCredentialsProvider.class.isAssignableFrom(credClass)) {
            throw new IllegalArgumentException("class " + credClass + " is not cos credential provider");
        }
        if (Modifier.isAbstract(credClass.getModifiers())) {
            throw new IllegalArgumentException("class " + credClass + " is abstract and therefore cannot be created");
        }
        LOG.debug("Credential Provider class: " + credClass.getName());
        try {
            Constructor<?> constructor = CosNUtils.getConstructor(credClass, new Class[0]);
            if (constructor != null) {
                COSCredentialsProvider credentialsProvider = (COSCredentialsProvider)constructor.newInstance(new Object[0]);
                return credentialsProvider;
            }
            constructor = CosNUtils.getConstructor(credClass, Configuration.class);
            if (null != constructor) {
                COSCredentialsProvider credentialsProvider = (COSCredentialsProvider)constructor.newInstance(conf);
                return credentialsProvider;
            }
            constructor = CosNUtils.getConstructor(credClass, URI.class, Configuration.class);
            if (null != constructor) {
                COSCredentialsProvider credentialsProvider = (COSCredentialsProvider)constructor.newInstance(uri, conf);
                return credentialsProvider;
            }
            Method factory = CosNUtils.getFactoryMethod(credClass, COSCredentialsProvider.class, "getInstance");
            if (null != factory) {
                COSCredentialsProvider credentialsProvider = (COSCredentialsProvider)factory.invoke(null, new Object[0]);
                return credentialsProvider;
            }
            throw new IllegalArgumentException("Not supported constructor or factory method found");
        }
        catch (IllegalAccessException e) {
            throw new IOException(credClass.getName() + " instantiation exception: " + e, e);
        }
        catch (InstantiationException e) {
            throw new IOException(credClass.getName() + " instantiation exception: " + e, e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException == null) {
                targetException = e;
            }
            throw new IOException(credClass.getName() + " instantiation exception: " + targetException, targetException);
        }
    }

    private static Constructor<?> getConstructor(Class<?> cl, Class<?> ... args) {
        try {
            Constructor<?> constructor = cl.getDeclaredConstructor(args);
            return Modifier.isPublic(constructor.getModifiers()) ? constructor : null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Method getFactoryMethod(Class<?> cl, Class<?> returnType, String methodName) {
        try {
            Method m = cl.getDeclaredMethod(methodName, new Class[0]);
            if (Modifier.isPublic(m.getModifiers()) && Modifier.isStatic(m.getModifiers()) && returnType.isAssignableFrom(m.getReturnType())) {
                return m;
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

