/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.cosn;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.cosn.BufferPool;
import org.apache.hadoop.fs.cosn.CosNCopyFileContext;
import org.apache.hadoop.fs.cosn.CosNCopyFileTask;
import org.apache.hadoop.fs.cosn.CosNInputStream;
import org.apache.hadoop.fs.cosn.CosNOutputStream;
import org.apache.hadoop.fs.cosn.CosNativeFileSystemStore;
import org.apache.hadoop.fs.cosn.FileMetadata;
import org.apache.hadoop.fs.cosn.NativeFileSystemStore;
import org.apache.hadoop.fs.cosn.PartialListing;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.util.BlockingThreadPoolExecutorService;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class CosNFileSystem
extends FileSystem {
    static final Logger LOG = LoggerFactory.getLogger(CosNFileSystem.class);
    public static final String SCHEME = "cosn";
    public static final String PATH_DELIMITER = "/";
    private URI uri;
    private String bucket;
    private NativeFileSystemStore store;
    private Path workingDir;
    private String owner = "Unknown";
    private String group = "Unknown";
    private ExecutorService boundedIOThreadPool;
    private ExecutorService boundedCopyThreadPool;

    public CosNFileSystem() {
    }

    public CosNFileSystem(NativeFileSystemStore store) {
        this.store = store;
    }

    public String getScheme() {
        return SCHEME;
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        super.initialize(name, conf);
        this.bucket = name.getHost();
        if (this.store == null) {
            this.store = CosNFileSystem.createDefaultStore(conf);
        }
        this.store.initialize(name, conf);
        this.setConf(conf);
        this.uri = URI.create(name.getScheme() + "://" + name.getAuthority());
        this.workingDir = new Path("/user", System.getProperty("user.name")).makeQualified(this.uri, this.getWorkingDirectory());
        this.owner = this.getOwnerId();
        this.group = this.getGroupId();
        LOG.debug("owner:" + this.owner + ", group:" + this.group);
        BufferPool.getInstance().initialize(this.getConf());
        int uploadThreadPoolSize = this.getConf().getInt("fs.cosn.upload_thread_pool", 1);
        int readAheadPoolSize = this.getConf().getInt("fs.cosn.read.ahead.queue.size", 5);
        int ioThreadPoolSize = uploadThreadPoolSize + readAheadPoolSize / 3;
        long threadKeepAlive = this.getConf().getLong("fs.cosn.threads.keep_alive_time", 60L);
        this.boundedIOThreadPool = BlockingThreadPoolExecutorService.newInstance((int)(ioThreadPoolSize / 2), (int)ioThreadPoolSize, (long)threadKeepAlive, (TimeUnit)TimeUnit.SECONDS, (String)"cos-transfer-thread-pool");
        int copyThreadPoolSize = this.getConf().getInt("fs.cosn.copy_thread_pool", 1);
        this.boundedCopyThreadPool = BlockingThreadPoolExecutorService.newInstance((int)1, (int)copyThreadPoolSize, (long)60L, (TimeUnit)TimeUnit.SECONDS, (String)"cos-copy-thread-pool");
    }

    private static NativeFileSystemStore createDefaultStore(Configuration conf) {
        CosNativeFileSystemStore store = new CosNativeFileSystemStore();
        RetryPolicy basePolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)conf.getInt("fs.cosn.maxRetries", 3), (long)conf.getLong("fs.cosn.retry.interval.seconds", 3L), (TimeUnit)TimeUnit.SECONDS);
        HashMap<Class<IOException>, RetryPolicy> exceptionToPolicyMap = new HashMap<Class<IOException>, RetryPolicy>();
        exceptionToPolicyMap.put(IOException.class, basePolicy);
        RetryPolicy methodPolicy = RetryPolicies.retryByException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, exceptionToPolicyMap);
        HashMap<String, RetryPolicy> methodNameToPolicyMap = new HashMap<String, RetryPolicy>();
        methodNameToPolicyMap.put("storeFile", methodPolicy);
        methodNameToPolicyMap.put("rename", methodPolicy);
        return (NativeFileSystemStore)RetryProxy.create(NativeFileSystemStore.class, (Object)store, methodNameToPolicyMap);
    }

    private String getOwnerId() {
        return System.getProperty("user.name");
    }

    private String getGroupId() {
        return System.getProperty("user.name");
    }

    private String getOwnerInfo(boolean getOwnerId) {
        String ownerInfoId = "";
        try {
            int c;
            String userName = System.getProperty("user.name");
            String command = "id -u " + userName;
            if (!getOwnerId) {
                command = "id -g " + userName;
            }
            Process child = Runtime.getRuntime().exec(command);
            child.waitFor();
            InputStream in = child.getInputStream();
            StringBuilder strBuffer = new StringBuilder();
            while ((c = in.read()) != -1) {
                strBuffer.append((char)c);
            }
            in.close();
            ownerInfoId = strBuffer.toString();
        }
        catch (IOException | InterruptedException e) {
            LOG.error("Getting owner info occurs a exception", (Throwable)e);
        }
        return ownerInfoId;
    }

    private static String pathToKey(Path path) {
        if (path.toUri().getScheme() != null && path.toUri().getPath().isEmpty()) {
            return "";
        }
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("Path must be absolute: " + path);
        }
        String ret = path.toUri().getPath();
        if (ret.endsWith(PATH_DELIMITER) && ret.indexOf(PATH_DELIMITER) != ret.length() - 1) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    private static Path keyToPath(String key) {
        if (!key.startsWith(PATH_DELIMITER)) {
            return new Path(PATH_DELIMITER + key);
        }
        return new Path(key);
    }

    private Path makeAbsolute(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return new Path(this.workingDir, path);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        try {
            FileStatus fileStatus = this.getFileStatus(f);
            if (fileStatus.isDirectory()) {
                throw new FileAlreadyExistsException(f + " is a directory");
            }
            if (!overwrite) {
                throw new FileAlreadyExistsException(f + " already exists");
            }
        }
        catch (FileNotFoundException e) {
            LOG.debug("Creating a new file: [{}] in COS.", (Object)f);
        }
        Path absolutePath = this.makeAbsolute(f);
        String key = CosNFileSystem.pathToKey(absolutePath);
        return new FSDataOutputStream((OutputStream)new CosNOutputStream(this.getConf(), this.store, key, blockSize, this.boundedIOThreadPool), this.statistics);
    }

    private boolean rejectRootDirectoryDelete(boolean isEmptyDir, boolean recursive) throws PathIOException {
        if (isEmptyDir) {
            return true;
        }
        if (recursive) {
            return false;
        }
        throw new PathIOException(this.bucket, "Can not delete root path");
    }

    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Path parent = f.getParent();
        if (null != parent && !this.getFileStatus(parent).isDirectory()) {
            throw new FileAlreadyExistsException("Not a directory: " + parent);
        }
        return this.create(f, permission, flags.contains(CreateFlag.OVERWRITE), bufferSize, replication, blockSize, progress);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        FileStatus status;
        LOG.debug("Ready to delete path: [{}]. recursive: [{}].", (Object)f, (Object)recursive);
        try {
            status = this.getFileStatus(f);
        }
        catch (FileNotFoundException e) {
            LOG.debug("Ready to delete the file: [{}], but it does not exist.", (Object)f);
            return false;
        }
        Path absolutePath = this.makeAbsolute(f);
        Object key = CosNFileSystem.pathToKey(absolutePath);
        if (((String)key).compareToIgnoreCase(PATH_DELIMITER) == 0) {
            FileStatus[] fileStatuses = this.listStatus(f);
            return this.rejectRootDirectoryDelete(fileStatuses.length == 0, recursive);
        }
        if (status.isDirectory()) {
            PartialListing listing;
            if (!((String)key).endsWith(PATH_DELIMITER)) {
                key = (String)key + PATH_DELIMITER;
            }
            if (!recursive && this.listStatus(f).length > 0) {
                String errMsg = String.format("Can not delete the directory: [%s], as it is not empty and option recursive is false.", f);
                throw new IOException(errMsg);
            }
            this.createParent(f);
            String priorLastKey = null;
            do {
                listing = this.store.list((String)key, 999, priorLastKey, true);
                for (FileMetadata file : listing.getFiles()) {
                    this.store.delete(file.getKey());
                }
                for (FileMetadata commonPrefix : listing.getCommonPrefixes()) {
                    this.store.delete(commonPrefix.getKey());
                }
            } while ((priorLastKey = listing.getPriorLastKey()) != null);
            try {
                this.store.delete((String)key);
            }
            catch (Exception e) {
                LOG.error("Deleting the COS key: [{}] occurs an exception.", key, (Object)e);
            }
        } else {
            LOG.debug("Delete the file: {}", (Object)f);
            this.createParent(f);
            this.store.delete((String)key);
        }
        return true;
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        Path absolutePath = this.makeAbsolute(f);
        Object key = CosNFileSystem.pathToKey(absolutePath);
        if (((String)key).length() == 0) {
            return this.newDirectory(absolutePath);
        }
        LOG.debug("Call the getFileStatus to obtain the metadata for the file: [{}].", (Object)f);
        FileMetadata meta = this.store.retrieveMetadata((String)key);
        if (meta != null) {
            if (meta.isFile()) {
                LOG.debug("Path: [{}] is a file. COS key: [{}]", (Object)f, key);
                return this.newFile(meta, absolutePath);
            }
            LOG.debug("Path: [{}] is a dir. COS key: [{}]", (Object)f, key);
            return this.newDirectory(meta, absolutePath);
        }
        if (!((String)key).endsWith(PATH_DELIMITER)) {
            key = (String)key + PATH_DELIMITER;
        }
        LOG.debug("List COS key: [{}] to check the existence of the path.", key);
        PartialListing listing = this.store.list((String)key, 1);
        if (listing.getFiles().length > 0 || listing.getCommonPrefixes().length > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Path: [{}] is a directory. COS key: [{}]", (Object)f, key);
            }
            return this.newDirectory(absolutePath);
        }
        throw new FileNotFoundException("No such file or directory '" + absolutePath + "'");
    }

    public URI getUri() {
        return this.uri;
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        PartialListing listing;
        FileStatus fileStatus;
        Path absolutePath = this.makeAbsolute(f);
        Object key = CosNFileSystem.pathToKey(absolutePath);
        if (((String)key).length() > 0 && (fileStatus = this.getFileStatus(f)).isFile()) {
            return new FileStatus[]{fileStatus};
        }
        if (!((String)key).endsWith(PATH_DELIMITER)) {
            key = (String)key + PATH_DELIMITER;
        }
        URI pathUri = absolutePath.toUri();
        TreeSet<FileStatus> status = new TreeSet<FileStatus>();
        String priorLastKey = null;
        do {
            Path subPath;
            listing = this.store.list((String)key, 999, priorLastKey, false);
            for (FileMetadata fileMetadata : listing.getFiles()) {
                subPath = CosNFileSystem.keyToPath(fileMetadata.getKey());
                if (fileMetadata.getKey().equals(key)) {
                    LOG.debug("The file list contains the COS key [{}] to be listed.", key);
                    continue;
                }
                status.add(this.newFile(fileMetadata, subPath));
            }
            for (FileMetadata commonPrefix : listing.getCommonPrefixes()) {
                subPath = CosNFileSystem.keyToPath(commonPrefix.getKey());
                String relativePath = pathUri.relativize(subPath.toUri()).getPath();
                status.add(this.newDirectory(commonPrefix, new Path(absolutePath, relativePath)));
            }
        } while ((priorLastKey = listing.getPriorLastKey()) != null);
        return status.toArray(new FileStatus[status.size()]);
    }

    private FileStatus newFile(FileMetadata meta, Path path) {
        return new FileStatus(meta.getLength(), false, 1, this.getDefaultBlockSize(), meta.getLastModified(), 0L, null, this.owner, this.group, path.makeQualified(this.getUri(), this.getWorkingDirectory()));
    }

    private FileStatus newDirectory(Path path) {
        return new FileStatus(0L, true, 1, 0L, 0L, 0L, null, this.owner, this.group, path.makeQualified(this.getUri(), this.getWorkingDirectory()));
    }

    private FileStatus newDirectory(FileMetadata meta, Path path) {
        if (meta == null) {
            return this.newDirectory(path);
        }
        return new FileStatus(0L, true, 1, 0L, meta.getLastModified(), 0L, null, this.owner, this.group, path.makeQualified(this.getUri(), this.getWorkingDirectory()));
    }

    private void validatePath(Path path) throws IOException {
        Path parent = path.getParent();
        while (true) {
            try {
                FileStatus fileStatus = this.getFileStatus(parent);
                if (!fileStatus.isDirectory()) {
                    throw new FileAlreadyExistsException(String.format("Can't make directory for path '%s', it is a file.", parent));
                }
            }
            catch (FileNotFoundException e) {
                LOG.debug("The Path: [{}] does not exist.", (Object)path);
                if ((parent = parent.getParent()) != null) continue;
            }
            break;
        }
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        try {
            FileStatus fileStatus = this.getFileStatus(f);
            if (fileStatus.isDirectory()) {
                return true;
            }
            throw new FileAlreadyExistsException("Path is a file: " + f);
        }
        catch (FileNotFoundException e) {
            this.validatePath(f);
            return this.mkDirRecursively(f, permission);
        }
    }

    public boolean mkDirRecursively(Path f, FsPermission permission) throws IOException {
        Path path;
        Path absolutePath = this.makeAbsolute(f);
        ArrayList<Path> paths = new ArrayList<Path>();
        do {
            paths.add(absolutePath);
        } while ((absolutePath = absolutePath.getParent()) != null);
        Iterator iterator = paths.iterator();
        while (iterator.hasNext() && !(path = (Path)iterator.next()).equals((Object)new Path(PATH_DELIMITER))) {
            try {
                FileStatus fileStatus = this.getFileStatus(path);
                if (fileStatus.isFile()) {
                    throw new FileAlreadyExistsException(String.format("Can't make directory for path: %s, since it is a file.", f));
                }
                if (!fileStatus.isDirectory()) continue;
                break;
            }
            catch (FileNotFoundException e) {
                LOG.debug("Making dir: [{}] in COS", (Object)f);
                Object folderPath = CosNFileSystem.pathToKey(this.makeAbsolute(f));
                if (!((String)folderPath).endsWith(PATH_DELIMITER)) {
                    folderPath = (String)folderPath + PATH_DELIMITER;
                }
                this.store.storeEmptyFile((String)folderPath);
            }
        }
        return true;
    }

    private boolean mkdir(Path f) throws IOException {
        try {
            FileStatus fileStatus = this.getFileStatus(f);
            if (fileStatus.isFile()) {
                throw new FileAlreadyExistsException(String.format("Can't make directory for path '%s' since it is a file.", f));
            }
        }
        catch (FileNotFoundException e) {
            Object folderPath;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Make directory: [{}] in COS.", (Object)f);
            }
            if (!((String)(folderPath = CosNFileSystem.pathToKey(this.makeAbsolute(f)))).endsWith(PATH_DELIMITER)) {
                folderPath = (String)folderPath + PATH_DELIMITER;
            }
            this.store.storeEmptyFile((String)folderPath);
        }
        return true;
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        FileStatus fs = this.getFileStatus(f);
        if (fs.isDirectory()) {
            throw new FileNotFoundException("'" + f + "' is a directory");
        }
        LOG.info("Open the file: [{}] for reading.", (Object)f);
        Path absolutePath = this.makeAbsolute(f);
        String key = CosNFileSystem.pathToKey(absolutePath);
        long fileSize = this.store.getFileLength(key);
        return new FSDataInputStream((InputStream)new BufferedFSInputStream((FSInputStream)new CosNInputStream(this.getConf(), this.store, this.statistics, key, fileSize, this.boundedIOThreadPool), bufferSize));
    }

    public boolean rename(Path src, Path dst) throws IOException {
        boolean result;
        FileStatus srcFileStatus;
        block11: {
            Path dstParentPath;
            LOG.debug("Rename source path: [{}] to dest path: [{}].", (Object)src, (Object)dst);
            if (src.isRoot()) {
                LOG.debug("Cannot rename the root directory of a filesystem.");
                return false;
            }
            srcFileStatus = this.getFileStatus(src);
            if (src.equals((Object)dst)) {
                LOG.debug("Source path and dest path refer to the same file or directory: [{}].", (Object)dst);
                throw new IOException("Source path and dest path refer the same file or directory");
            }
            for (dstParentPath = dst.getParent(); null != dstParentPath && !src.equals((Object)dstParentPath); dstParentPath = dstParentPath.getParent()) {
                LOG.debug("Recursively find the common parent directory of the source and destination paths. The currently found parent path: {}", (Object)dstParentPath);
            }
            if (null != dstParentPath) {
                LOG.debug("It is not allowed to rename a parent directory:[{}] to its subdirectory:[{}].", (Object)src, (Object)dst);
                throw new IOException(String.format("It is not allowed to rename a parent directory: %s to its subdirectory: %s", src, dst));
            }
            try {
                FileStatus[] statuses;
                FileStatus dstFileStatus = this.getFileStatus(dst);
                if (dstFileStatus.isFile()) {
                    throw new FileAlreadyExistsException(String.format("File: %s already exists", dstFileStatus.getPath()));
                }
                dst = new Path(dst, src.getName());
                try {
                    statuses = this.listStatus(dst);
                }
                catch (FileNotFoundException e) {
                    statuses = null;
                }
                if (null != statuses && statuses.length > 0) {
                    LOG.debug("Cannot rename source file: [{}] to dest file: [{}], because the file already exists.", (Object)src, (Object)dst);
                    throw new FileAlreadyExistsException(String.format("File: %s already exists", dst));
                }
            }
            catch (FileNotFoundException e) {
                Path tempDstParentPath = dst.getParent();
                FileStatus dstParentStatus = this.getFileStatus(tempDstParentPath);
                if (dstParentStatus.isDirectory()) break block11;
                throw new IOException(String.format("Cannot rename %s to %s, %s is a file", src, dst, dst.getParent()));
            }
        }
        if (!(result = srcFileStatus.isDirectory() ? this.copyDirectory(src, dst) : this.copyFile(src, dst))) {
            return false;
        }
        return this.delete(src, true);
    }

    private boolean copyFile(Path srcPath, Path dstPath) throws IOException {
        String srcKey = CosNFileSystem.pathToKey(srcPath);
        String dstKey = CosNFileSystem.pathToKey(dstPath);
        this.store.copy(srcKey, dstKey);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyDirectory(Path srcPath, Path dstPath) throws IOException {
        PartialListing objectList;
        Object dstKey;
        Object srcKey = CosNFileSystem.pathToKey(srcPath);
        if (!((String)srcKey).endsWith(PATH_DELIMITER)) {
            srcKey = (String)srcKey + PATH_DELIMITER;
        }
        if (!((String)(dstKey = CosNFileSystem.pathToKey(dstPath))).endsWith(PATH_DELIMITER)) {
            dstKey = (String)dstKey + PATH_DELIMITER;
        }
        if (((String)dstKey).startsWith((String)srcKey)) {
            throw new IOException("can not copy a directory to a subdirectory of self");
        }
        this.store.storeEmptyFile((String)dstKey);
        CosNCopyFileContext copyFileContext = new CosNCopyFileContext();
        int copiesToFinishes = 0;
        String priorLastKey = null;
        block5: do {
            objectList = this.store.list((String)srcKey, 999, priorLastKey, true);
            for (FileMetadata file : objectList.getFiles()) {
                this.boundedCopyThreadPool.execute(new CosNCopyFileTask(this.store, file.getKey(), ((String)dstKey).concat(file.getKey().substring(((String)srcKey).length())), copyFileContext));
                ++copiesToFinishes;
                if (!copyFileContext.isCopySuccess()) continue block5;
            }
        } while (null != (priorLastKey = objectList.getPriorLastKey()));
        copyFileContext.lock();
        try {
            copyFileContext.awaitAllFinish(copiesToFinishes);
        }
        catch (InterruptedException e) {
            LOG.warn("interrupted when wait copies to finish");
        }
        finally {
            copyFileContext.lock();
        }
        return copyFileContext.isCopySuccess();
    }

    private void createParent(Path path) throws IOException {
        Path parent = path.getParent();
        if (parent != null) {
            String key;
            String parentKey = CosNFileSystem.pathToKey(parent);
            LOG.debug("Create parent key: {}", (Object)parentKey);
            if (!parentKey.equals(PATH_DELIMITER) && (key = CosNFileSystem.pathToKey(this.makeAbsolute(parent))).length() > 0) {
                try {
                    this.store.storeEmptyFile(key + PATH_DELIMITER);
                }
                catch (IOException e) {
                    LOG.debug("Store a empty file in COS failed.", (Throwable)e);
                    throw e;
                }
            }
        }
    }

    public long getDefaultBlockSize() {
        return this.getConf().getLong("fs.cosn.block.size", 0x800000L);
    }

    public void setWorkingDirectory(Path newDir) {
        this.workingDir = newDir;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public String getCanonicalServiceName() {
        return null;
    }

    public void close() throws IOException {
        try {
            this.store.close();
            this.boundedIOThreadPool.shutdown();
            this.boundedCopyThreadPool.shutdown();
        }
        finally {
            super.close();
        }
    }
}

