/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.cosn;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.cosn.CosNInputStream;
import org.apache.hadoop.fs.cosn.NativeFileSystemStore;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosNFileReadTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(CosNFileReadTask.class);
    private final String key;
    private final NativeFileSystemStore store;
    private final CosNInputStream.ReadBuffer readBuffer;
    private RetryPolicy retryPolicy;

    public CosNFileReadTask(Configuration conf, String key, NativeFileSystemStore store, CosNInputStream.ReadBuffer readBuffer) {
        this.key = key;
        this.store = store;
        this.readBuffer = readBuffer;
        RetryPolicy defaultPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)conf.getInt("fs.cosn.maxRetries", 3), (long)conf.getLong("fs.cosn.retry.interval.seconds", 3L), (TimeUnit)TimeUnit.SECONDS);
        HashMap<Class<NullPointerException>, RetryPolicy> retryPolicyMap = new HashMap<Class<NullPointerException>, RetryPolicy>();
        retryPolicyMap.put(IOException.class, defaultPolicy);
        retryPolicyMap.put(IndexOutOfBoundsException.class, RetryPolicies.TRY_ONCE_THEN_FAIL);
        retryPolicyMap.put(NullPointerException.class, RetryPolicies.TRY_ONCE_THEN_FAIL);
        this.retryPolicy = RetryPolicies.retryByException((RetryPolicy)defaultPolicy, retryPolicyMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int retries = 0;
        try {
            this.readBuffer.lock();
            while (true) {
                try {
                    InputStream inputStream = this.store.retrieveBlock(this.key, this.readBuffer.getStart(), this.readBuffer.getEnd());
                    IOUtils.readFully((InputStream)inputStream, (byte[])this.readBuffer.getBuffer(), (int)0, (int)this.readBuffer.getBuffer().length);
                    inputStream.close();
                    this.readBuffer.setStatus(0);
                }
                catch (IOException e) {
                    RetryPolicy.RetryAction retryAction;
                    this.readBuffer.setStatus(-1);
                    LOG.warn("Exception occurs when retrieve the block range start: " + String.valueOf(this.readBuffer.getStart()) + " end: " + this.readBuffer.getEnd());
                    try {
                        retryAction = this.retryPolicy.shouldRetry((Exception)e, retries++, 0, true);
                        if (retryAction.action != RetryPolicy.RetryAction.RetryDecision.RETRY) continue;
                        Thread.sleep(retryAction.delayMillis);
                        continue;
                    }
                    catch (Exception e1) {
                        String errMsg = String.format("Exception occurs when retry[%s] to retrieve the block range start: %s, end:%s", this.retryPolicy.toString(), String.valueOf(this.readBuffer.getStart()), String.valueOf(this.readBuffer.getEnd()));
                        LOG.error(errMsg, (Throwable)e1);
                        break;
                    }
                    if (retryAction.action == RetryPolicy.RetryAction.RetryDecision.RETRY) continue;
                }
                break;
            }
            this.readBuffer.signalAll();
        }
        finally {
            this.readBuffer.unLock();
        }
    }
}

