/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HdfsCompatUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsCompatUtil.class);
    private static final Random RANDOM = new Random();

    private HdfsCompatUtil() {
    }

    public static void checkImplementation(ImplementationFunction func) {
        try {
            func.apply();
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (NoSuchMethodError e) {
            throw e;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void createFile(FileSystem fs, Path file, long fileLen) throws IOException {
        HdfsCompatUtil.createFile(fs, file, true, 1024, fileLen, 0x100000L, (short)1);
    }

    public static void createFile(FileSystem fs, Path file, byte[] data) throws IOException {
        HdfsCompatUtil.createFile(fs, file, true, data, 0x100000L, (short)1);
    }

    public static void createFile(FileSystem fs, Path file, boolean overwrite, int bufferSize, long fileLen, long blockSize, short replication) throws IOException {
        assert (bufferSize > 0);
        try (FSDataOutputStream out = fs.create(file, overwrite, bufferSize, replication, blockSize);){
            if (fileLen > 0L) {
                int bytesToWriteNext;
                byte[] toWrite = new byte[bufferSize];
                for (long bytesToWrite = fileLen; bytesToWrite > 0L; bytesToWrite -= (long)bytesToWriteNext) {
                    RANDOM.nextBytes(toWrite);
                    bytesToWriteNext = (long)bufferSize < bytesToWrite ? bufferSize : (int)bytesToWrite;
                    out.write(toWrite, 0, bytesToWriteNext);
                }
            }
        }
    }

    public static void createFile(FileSystem fs, Path file, boolean overwrite, byte[] data, long blockSize, short replication) throws IOException {
        try (FSDataOutputStream out = fs.create(file, overwrite, data.length > 0 ? data.length : 1024, replication, blockSize);){
            if (data.length > 0) {
                out.write(data);
            }
        }
    }

    public static byte[] readFileBuffer(FileSystem fs, Path fileName) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            byte[] byArray;
            block11: {
                FSDataInputStream in = fs.open(fileName);
                try {
                    IOUtils.copyBytes((InputStream)in, (OutputStream)os, (int)1024, (boolean)true);
                    byArray = os.toByteArray();
                    if (in == null) break block11;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return byArray;
        }
    }

    public static void deleteQuietly(FileSystem fs, Path path, boolean recursive) {
        if (fs != null && path != null) {
            try {
                fs.delete(path, recursive);
            }
            catch (Throwable e) {
                LOG.warn("When deleting {}", (Object)path, (Object)e);
            }
        }
    }

    public static interface ImplementationFunction {
        public void apply() throws Exception;
    }
}

