/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.compat.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.BlockStoragePolicySpi;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.compat.common.AbstractHdfsCompatCase;
import org.apache.hadoop.fs.compat.common.HdfsCompatEnvironment;
import org.apache.hadoop.fs.compat.common.HdfsCompatReport;
import org.apache.hadoop.fs.compat.common.HdfsCompatSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsCompatShellScope {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsCompatShellScope.class);
    private static final Random RANDOM = new Random();
    private final HdfsCompatEnvironment env;
    private final HdfsCompatSuite suite;
    private File stdoutDir = null;
    private File passList = null;
    private File failList = null;
    private File skipList = null;
    private Path snapshotPath = null;
    private String storagePolicy = null;
    private Method disallowSnapshot = null;

    public HdfsCompatShellScope(HdfsCompatEnvironment env, HdfsCompatSuite suite) {
        this.env = env;
        this.suite = suite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HdfsCompatReport apply() throws Exception {
        HdfsCompatReport hdfsCompatReport;
        File localTmpDir = null;
        try {
            localTmpDir = new File(this.env.getLocalTmpDir());
            LOG.info("Local tmp dir: " + localTmpDir.getAbsolutePath());
            hdfsCompatReport = this.runShell(localTmpDir);
        }
        catch (Throwable throwable) {
            try {
                if (this.disallowSnapshot != null) {
                    try {
                        this.disallowSnapshot.invoke((Object)this.env.getFileSystem(), this.snapshotPath);
                    }
                    catch (InvocationTargetException e) {
                        LOG.error("Cannot disallow snapshot", e.getCause());
                    }
                    catch (ReflectiveOperationException e) {
                        LOG.error("Disallow snapshot method is invalid", (Throwable)e);
                    }
                }
            }
            finally {
                FileUtils.deleteQuietly((File)localTmpDir);
            }
            throw throwable;
        }
        try {
            if (this.disallowSnapshot != null) {
                try {
                    this.disallowSnapshot.invoke((Object)this.env.getFileSystem(), this.snapshotPath);
                }
                catch (InvocationTargetException e) {
                    LOG.error("Cannot disallow snapshot", e.getCause());
                }
                catch (ReflectiveOperationException e) {
                    LOG.error("Disallow snapshot method is invalid", (Throwable)e);
                }
            }
        }
        finally {
            FileUtils.deleteQuietly((File)localTmpDir);
        }
        return hdfsCompatReport;
    }

    private HdfsCompatReport runShell(File localTmpDir) throws Exception {
        File localDir = new File(localTmpDir, "test");
        File scriptDir = new File(localTmpDir, "scripts");
        File confDir = new File(localTmpDir, "hadoop-conf");
        this.copyScriptsResource(scriptDir);
        try {
            this.setShellLogConf(confDir);
        }
        catch (Exception e) {
            LOG.error("Cannot set new conf dir", (Throwable)e);
            confDir = null;
        }
        this.prepareSnapshot();
        this.storagePolicy = this.getStoragePolicy();
        String[] confEnv = this.getEnv(localDir, scriptDir, confDir);
        ExecResult result = this.exec(confEnv, scriptDir);
        this.printLog(result);
        return this.export();
    }

    private void copyScriptsResource(File scriptDir) throws IOException {
        String[] cases;
        Files.createDirectories(new File(scriptDir, "cases").toPath(), new FileAttribute[0]);
        this.copyResource("/misc.sh", new File(scriptDir, "misc.sh"));
        for (String res : cases = this.suite.getShellCases()) {
            this.copyResource("/cases/" + res, new File(scriptDir, "cases/" + res));
        }
    }

    private void setShellLogConf(File confDir) throws IOException {
        String hadoopHome = System.getenv("HADOOP_HOME");
        String hadoopConfDir = System.getenv("HADOOP_CONF_DIR");
        if (hadoopHome == null || hadoopHome.isEmpty()) {
            LOG.error("HADOOP_HOME not configured");
        }
        if (hadoopConfDir == null || hadoopConfDir.isEmpty()) {
            throw new IOException("HADOOP_CONF_DIR not configured");
        }
        File srcDir = new File(hadoopConfDir).getAbsoluteFile();
        if (!srcDir.isDirectory()) {
            throw new IOException("HADOOP_CONF_DIR is not valid: " + srcDir);
        }
        Files.createDirectories(confDir.toPath(), new FileAttribute[0]);
        FileUtils.copyDirectory((File)srcDir, (File)confDir);
        File logConfFile = new File(confDir, "log4j.properties");
        this.copyResource("/hadoop-compat-bench-log4j.properties", logConfFile, true);
    }

    @VisibleForTesting
    protected void copyResource(String res, File dst) throws IOException {
        this.copyResource(res, dst, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResource(String res, File dst, boolean overwrite) throws IOException {
        try (InputStream in = null;){
            in = this.getClass().getResourceAsStream(res);
            if (in == null) {
                in = this.suite.getClass().getResourceAsStream(res);
            }
            if (in == null) {
                throw new IOException("Resource not found during scripts prepare: " + res);
            }
            if (dst.exists() && !overwrite) {
                throw new IOException("Cannot overwrite existing resource file");
            }
            Files.createDirectories(dst.getParentFile().toPath(), new FileAttribute[0]);
            byte[] buf = new byte[1024];
            try (FileOutputStream out = new FileOutputStream(dst);){
                int nRead = in.read(buf);
                while (nRead != -1) {
                    ((OutputStream)out).write(buf, 0, nRead);
                    nRead = in.read(buf);
                }
            }
        }
    }

    private void prepareSnapshot() {
        this.snapshotPath = AbstractHdfsCompatCase.getUniquePath(this.env.getBase());
        Method allowSnapshot = null;
        try {
            FileSystem fs = this.env.getFileSystem();
            fs.mkdirs(this.snapshotPath);
            Method allowSnapshotMethod = fs.getClass().getMethod("allowSnapshot", Path.class);
            allowSnapshotMethod.setAccessible(true);
            allowSnapshotMethod.invoke((Object)fs, this.snapshotPath);
            allowSnapshot = allowSnapshotMethod;
            Method disallowSnapshotMethod = fs.getClass().getMethod("disallowSnapshot", Path.class);
            disallowSnapshotMethod.setAccessible(true);
            this.disallowSnapshot = disallowSnapshotMethod;
        }
        catch (IOException e) {
            LOG.error("Cannot prepare snapshot path", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.error("Cannot allow snapshot", e.getCause());
        }
        catch (ReflectiveOperationException e) {
            LOG.warn("Get admin snapshot methods failed.");
        }
        catch (Exception e) {
            LOG.warn("Prepare snapshot failed", (Throwable)e);
        }
        if (allowSnapshot == null) {
            LOG.warn("No allowSnapshot method found.");
        }
        if (this.disallowSnapshot == null) {
            LOG.warn("No disallowSnapshot method found.");
        }
    }

    private String getStoragePolicy() {
        String[] policies;
        BlockStoragePolicySpi def;
        try {
            FileSystem fs = this.env.getFileSystem();
            String[] base = this.env.getBase();
            fs.mkdirs((Path)base);
            def = fs.getStoragePolicy((Path)base);
            policies = this.env.getStoragePolicyNames();
        }
        catch (Exception e) {
            LOG.warn("Cannot get storage policy", (Throwable)e);
            return "Hot";
        }
        ArrayList<String> differentPolicies = new ArrayList<String>();
        for (String policyName : policies) {
            if (def != null && policyName.equalsIgnoreCase(def.getName())) continue;
            differentPolicies.add(policyName);
        }
        if (differentPolicies.isEmpty()) {
            String defPolicyName;
            if (def == null || def.getName() == null) {
                defPolicyName = "Hot";
                LOG.warn("No valid storage policy name found, use Hot.");
            } else {
                defPolicyName = def.getName();
                LOG.warn("There is only one storage policy: " + defPolicyName);
            }
            return defPolicyName;
        }
        return (String)differentPolicies.get(RANDOM.nextInt(differentPolicies.size()));
    }

    @VisibleForTesting
    protected String[] getEnv(File localDir, File scriptDir, File confDir) throws IOException {
        ArrayList<CallSite> confEnv = new ArrayList<CallSite>();
        Map<String, String> environments = System.getenv();
        for (Map.Entry<String, String> entry : environments.entrySet()) {
            confEnv.add((CallSite)((Object)(entry.getKey() + "=" + entry.getValue())));
        }
        if (confDir != null) {
            confEnv.add((CallSite)((Object)("HADOOP_CONF_DIR=" + confDir.getAbsolutePath())));
        }
        String timestamp = String.valueOf(System.currentTimeMillis());
        Path baseUri = new Path(this.env.getBase(), timestamp);
        File localUri = new File(localDir, timestamp).getAbsoluteFile();
        File resultDir = new File(localDir, timestamp);
        Files.createDirectories(resultDir.toPath(), new FileAttribute[0]);
        this.stdoutDir = new File(resultDir, "output").getAbsoluteFile();
        this.passList = new File(resultDir, "passed").getAbsoluteFile();
        this.failList = new File(resultDir, "failed").getAbsoluteFile();
        this.skipList = new File(resultDir, "skipped").getAbsoluteFile();
        Files.createFile(this.passList.toPath(), new FileAttribute[0]);
        Files.createFile(this.failList.toPath(), new FileAttribute[0]);
        Files.createFile(this.skipList.toPath(), new FileAttribute[0]);
        String prefix = "HADOOP_COMPAT_";
        confEnv.add((CallSite)((Object)("HADOOP_COMPAT_BASE_URI=" + baseUri)));
        confEnv.add((CallSite)((Object)("HADOOP_COMPAT_LOCAL_URI=" + localUri.getAbsolutePath())));
        confEnv.add((CallSite)((Object)("HADOOP_COMPAT_SNAPSHOT_URI=" + this.snapshotPath.toString())));
        confEnv.add((CallSite)((Object)("HADOOP_COMPAT_STORAGE_POLICY=" + this.storagePolicy)));
        confEnv.add((CallSite)((Object)("HADOOP_COMPAT_STDOUT_DIR=" + this.stdoutDir.getAbsolutePath())));
        confEnv.add((CallSite)((Object)("HADOOP_COMPAT_PASS_FILE=" + this.passList.getAbsolutePath())));
        confEnv.add((CallSite)((Object)("HADOOP_COMPAT_FAIL_FILE=" + this.failList.getAbsolutePath())));
        confEnv.add((CallSite)((Object)("HADOOP_COMPAT_SKIP_FILE=" + this.skipList.getAbsolutePath())));
        return confEnv.toArray(new String[0]);
    }

    private ExecResult exec(String[] confEnv, File scriptDir) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec("prove -r cases", confEnv, scriptDir);
        StreamPrinter out = new StreamPrinter(process.getInputStream());
        StreamPrinter err = new StreamPrinter(process.getErrorStream());
        out.start();
        err.start();
        int code = process.waitFor();
        out.join();
        err.join();
        return new ExecResult(code, out.lines, err.lines);
    }

    private void printLog(ExecResult execResult) {
        LOG.info("Shell prove\ncode: {}\nstdout:\n\t{}\nstderr:\n\t{}", new Object[]{execResult.code, String.join((CharSequence)"\n\t", execResult.out), String.join((CharSequence)"\n\t", execResult.err)});
        File casesRoot = new File(this.stdoutDir, "cases").getAbsoluteFile();
        String[] casesDirList = casesRoot.list();
        if (casesDirList == null) {
            LOG.error("stdout/stderr root directory is invalid: " + casesRoot);
            return;
        }
        Arrays.sort(casesDirList, (o1, o2) -> {
            if (o1.length() == o2.length()) {
                return o1.compareTo((String)o2);
            }
            return o1.length() - o2.length();
        });
        for (String casesDir : casesDirList) {
            this.printCasesLog(new File(casesRoot, casesDir).getAbsoluteFile());
        }
    }

    private void printCasesLog(File casesDir) {
        String[] caseNames;
        File stdout = new File(casesDir, "stdout").getAbsoluteFile();
        File stderr = new File(casesDir, "stderr").getAbsoluteFile();
        File[] stdoutFiles = stdout.listFiles();
        File[] stderrFiles = stderr.listFiles();
        HashSet<String> cases = new HashSet<String>();
        if (stdoutFiles != null) {
            for (File c : stdoutFiles) {
                cases.add(c.getName());
            }
        }
        if (stderrFiles != null) {
            for (File c : stderrFiles) {
                cases.add(c.getName());
            }
        }
        for (String caseName : caseNames = (String[])cases.stream().sorted((o1, o2) -> {
            if (o1.length() == o2.length()) {
                return o1.compareTo((String)o2);
            }
            return o1.length() - o2.length();
        }).toArray(String[]::new)) {
            File stdoutFile = new File(stdout, caseName);
            File stderrFile = new File(stderr, caseName);
            try {
                List<Object> stdoutLines = stdoutFile.exists() ? this.readLines(stdoutFile) : new ArrayList();
                List<Object> stderrLines = stderrFile.exists() ? this.readLines(stderrFile) : new ArrayList();
                LOG.info("Shell case {} - #{}\nstdout:\n\t{}\nstderr:\n\t{}", new Object[]{casesDir.getName(), caseName, String.join((CharSequence)"\n\t", stdoutLines), String.join((CharSequence)"\n\t", stderrLines)});
            }
            catch (Exception e) {
                LOG.warn("Read shell stdout or stderr file failed", (Throwable)e);
            }
        }
    }

    private HdfsCompatReport export() throws IOException {
        HdfsCompatReport report = new HdfsCompatReport();
        report.addPassedCase(this.readLines(this.passList));
        report.addFailedCase(this.readLines(this.failList));
        report.addSkippedCase(this.readLines(this.skipList));
        return report;
    }

    private List<String> readLines(File file) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            String line = br.readLine();
            while (line != null) {
                lines.add(line);
                line = br.readLine();
            }
        }
        return lines;
    }

    private static final class ExecResult {
        private final int code;
        private final List<String> out;
        private final List<String> err;

        private ExecResult(int code, List<String> out, List<String> err) {
            this.code = code;
            this.out = out;
            this.err = err;
        }
    }

    private static final class StreamPrinter
    extends Thread {
        private final InputStream in;
        private final List<String> lines;

        private StreamPrinter(InputStream in) {
            this.in = in;
            this.lines = new ArrayList<String>();
        }

        @Override
        public void run() {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(this.in, StandardCharsets.UTF_8));){
                String line = br.readLine();
                while (line != null) {
                    this.lines.add(line);
                    line = br.readLine();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

